/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.configuration;

import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyRequestScope;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosTarget;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import de.codecentric.spring.boot.chaos.monkey.watcher.advice.ChaosMonkeyBeanPostProcessor;
import de.codecentric.spring.boot.chaos.monkey.watcher.advice.ChaosMonkeyDefaultAdvice;
import de.codecentric.spring.boot.chaos.monkey.watcher.advice.ChaosMonkeyHealthIndicatorAdvice;
import de.codecentric.spring.boot.chaos.monkey.watcher.advice.advisor.ChaosMonkeyAnnotationPointcutAdvisor;
import de.codecentric.spring.boot.chaos.monkey.watcher.advice.advisor.ChaosMonkeyPointcutAdvisor;
import de.codecentric.spring.boot.chaos.monkey.watcher.advice.filter.ChaosMonkeyBaseClassFilter;
import de.codecentric.spring.boot.chaos.monkey.watcher.advice.filter.MethodNameFilter;
import de.codecentric.spring.boot.chaos.monkey.watcher.advice.filter.RepositoryAnnotatedClassFilter;
import de.codecentric.spring.boot.chaos.monkey.watcher.advice.filter.RepositoryClassFilter;
import de.codecentric.spring.boot.chaos.monkey.watcher.advice.filter.SpringHookMethodsFilter;
import lombok.Generated;
import org.aopalliance.aop.Advice;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.support.ClassFilters;
import org.springframework.aop.support.RootClassFilter;
import org.springframework.aop.support.annotation.AnnotationClassFilter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;

@Configuration
public class ChaosMonkeyAdvisorConfiguration {
    private final WatcherProperties watcherProperties;

    @Bean
    public ChaosMonkeyBaseClassFilter chaosMonkeyBaseClassFilter() {
        return new ChaosMonkeyBaseClassFilter(this.watcherProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"controllerPointcutAdvisor"})
    public ChaosMonkeyPointcutAdvisor controllerPointcutAdvisor(ChaosMonkeyBaseClassFilter baseClassFilter, ChaosMonkeyRequestScope requestScope, MetricEventPublisher eventPublisher) {
        return new ChaosMonkeyAnnotationPointcutAdvisor(baseClassFilter, (Advice)new ChaosMonkeyDefaultAdvice(requestScope, eventPublisher, ChaosTarget.CONTROLLER, this.watcherProperties::isController), Controller.class);
    }

    @Bean
    @ConditionalOnMissingBean(name={"restControllerPointcutAdvisor"})
    public ChaosMonkeyPointcutAdvisor restControllerPointcutAdvisor(ChaosMonkeyBaseClassFilter baseClassFilter, ChaosMonkeyRequestScope requestScope, MetricEventPublisher eventPublisher) {
        return new ChaosMonkeyAnnotationPointcutAdvisor(baseClassFilter, (Advice)new ChaosMonkeyDefaultAdvice(requestScope, eventPublisher, ChaosTarget.REST_CONTROLLER, this.watcherProperties::isRestController), RestController.class);
    }

    @Bean
    @ConditionalOnMissingBean(name={"servicePointcutAdvisor"})
    public ChaosMonkeyPointcutAdvisor servicePointcutAdvisor(ChaosMonkeyBaseClassFilter baseClassFilter, ChaosMonkeyRequestScope requestScope, MetricEventPublisher eventPublisher) {
        return new ChaosMonkeyAnnotationPointcutAdvisor(baseClassFilter, (Advice)new ChaosMonkeyDefaultAdvice(requestScope, eventPublisher, ChaosTarget.SERVICE, this.watcherProperties::isService), Service.class, (MethodMatcher)SpringHookMethodsFilter.INSTANCE);
    }

    @Bean
    @ConditionalOnMissingBean(name={"componentPointcutAdvisor"})
    public ChaosMonkeyPointcutAdvisor componentPointcutAdvisor(ChaosMonkeyBaseClassFilter baseClassFilter, ChaosMonkeyRequestScope requestScope, MetricEventPublisher eventPublisher) {
        return new ChaosMonkeyAnnotationPointcutAdvisor(baseClassFilter, (Advice)new ChaosMonkeyDefaultAdvice(requestScope, eventPublisher, ChaosTarget.COMPONENT, this.watcherProperties::isComponent), Component.class, (MethodMatcher)SpringHookMethodsFilter.INSTANCE);
    }

    @Bean
    @ConditionalOnMissingBean(name={"repositoryPointcutAdvisor"})
    @ConditionalOnClass(name={"org.springframework.data.repository.Repository"})
    public ChaosMonkeyPointcutAdvisor repositoryPointcutAdvisor(ChaosMonkeyBaseClassFilter baseClassFilter, ChaosMonkeyRequestScope requestScope, MetricEventPublisher eventPublisher) throws ClassNotFoundException {
        Class<?> repositoryDefinition = Class.forName("org.springframework.data.repository.RepositoryDefinition");
        ClassFilter[] filters = new ClassFilter[]{new RepositoryClassFilter(), new RepositoryAnnotatedClassFilter(), new AnnotationClassFilter(repositoryDefinition)};
        return new ChaosMonkeyPointcutAdvisor(baseClassFilter, (Advice)new ChaosMonkeyDefaultAdvice(requestScope, eventPublisher, ChaosTarget.REPOSITORY, this.watcherProperties::isRepository), ClassFilters.union((ClassFilter[])filters), (MethodMatcher)SpringHookMethodsFilter.INSTANCE);
    }

    @Bean
    @ConditionalOnMissingBean(name={"healthIndicatorAdviceProvider"})
    @ConditionalOnClass(name={"org.springframework.boot.actuate.health.HealthIndicator"})
    public ChaosMonkeyPointcutAdvisor healthIndicatorAdviceProvider(ChaosMonkeyBaseClassFilter baseClassFilter, ChaosMonkeyRequestScope requestScope) throws ClassNotFoundException {
        Class<?> healthIndicatorClass = Class.forName("org.springframework.boot.actuate.health.HealthIndicator");
        return new ChaosMonkeyPointcutAdvisor(baseClassFilter, (Advice)new ChaosMonkeyHealthIndicatorAdvice(requestScope, this.watcherProperties), (ClassFilter)new RootClassFilter(healthIndicatorClass), (MethodMatcher)new MethodNameFilter("getHealth"));
    }

    @Bean
    @ConditionalOnMissingBean
    public ChaosMonkeyBeanPostProcessor chaosMonkeyBeanPostProcessor(ChaosMonkeyRequestScope chaosMonkeyRequestScope, MetricEventPublisher publisher) {
        return new ChaosMonkeyBeanPostProcessor(this.watcherProperties, chaosMonkeyRequestScope, publisher);
    }

    @Generated
    public ChaosMonkeyAdvisorConfiguration(WatcherProperties watcherProperties) {
        this.watcherProperties = watcherProperties;
    }
}

