/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.component;

import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyRuntimeAssault;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.config.CronTask;
import org.springframework.scheduling.config.ScheduledTask;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

public class ChaosMonkeyScheduler {
    private static final Logger Logger = LoggerFactory.getLogger(ChaosMonkeyScheduler.class);
    private final ScheduledTaskRegistrar scheduler;
    private final AssaultProperties config;
    private final List<ChaosMonkeyRuntimeAssault> assaults;
    private final Map<ChaosMonkeyRuntimeAssault, ScheduledTask> currentTasks = new HashMap<ChaosMonkeyRuntimeAssault, ScheduledTask>();

    public ChaosMonkeyScheduler(ScheduledTaskRegistrar scheduler, AssaultProperties config, List<ChaosMonkeyRuntimeAssault> assaults) {
        this.scheduler = scheduler;
        this.config = config;
        this.assaults = assaults;
        this.reloadConfig();
    }

    public void reloadConfig() {
        Map<ChaosMonkeyRuntimeAssault, String> cronExpressions = this.getCronExpressions();
        if (!this.currentTasks.isEmpty()) {
            this.removeUnchangedExpressions(cronExpressions);
            this.cancelOldTasks(cronExpressions);
        }
        this.scheduleNewTasks(cronExpressions);
    }

    private Map<ChaosMonkeyRuntimeAssault, String> getCronExpressions() {
        return this.assaults.stream().collect(Collectors.toMap(Function.identity(), assault -> assault.getCronExpression(this.config)));
    }

    private void removeUnchangedExpressions(Map<ChaosMonkeyRuntimeAssault, String> cronExpressions) {
        cronExpressions.entrySet().removeIf(entry -> {
            ScheduledTask task = this.currentTasks.get(entry.getKey());
            return task != null && task.getTask() instanceof CronTask && Objects.equals(((CronTask)task.getTask()).getExpression(), entry.getValue());
        });
    }

    private void cancelOldTasks(Map<ChaosMonkeyRuntimeAssault, String> cronExpressions) {
        cronExpressions.forEach((assault, expression) -> {
            ScheduledTask task = this.currentTasks.remove(assault);
            if (task != null) {
                task.cancel();
            }
        });
    }

    private void scheduleNewTasks(Map<ChaosMonkeyRuntimeAssault, String> cronExpressions) {
        Logger.info("Schedule  %s cron task(s)".formatted(cronExpressions.size()));
        cronExpressions.forEach((assault, expression) -> {
            if (expression != null && !"OFF".equals(expression)) {
                this.scheduleRuntimeAssault(this.scheduler, (ChaosMonkeyRuntimeAssault)assault, (String)expression);
            }
        });
    }

    private void scheduleRuntimeAssault(ScheduledTaskRegistrar scheduler, ChaosMonkeyRuntimeAssault assault, String cron) {
        CronTask cronTask = new CronTask(() -> {
            if (assault.isActive()) {
                assault.attack();
            }
        }, cron);
        ScheduledTask scheduledTask = scheduler.scheduleCronTask(cronTask);
        this.currentTasks.put(assault, scheduledTask);
    }
}

