/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.watcher.outgoing;

import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkeyRequestScope;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosTarget;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultProperties;
import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class ChaosMonkeyWebClientWatcher
implements ExchangeFilterFunction {
    private final ChaosMonkeyRequestScope chaosMonkeyRequestScope;
    private final WatcherProperties watcherProperties;
    private final AssaultProperties assaultProperties;
    private static final String ALREADY_FILTERED_SUFFIX = ".FILTERED";

    public ChaosMonkeyWebClientWatcher(ChaosMonkeyRequestScope chaosMonkeyRequestScope, WatcherProperties watcherProperties, AssaultProperties assaultProperties) {
        this.chaosMonkeyRequestScope = chaosMonkeyRequestScope;
        this.watcherProperties = watcherProperties;
        this.assaultProperties = assaultProperties;
    }

    public Mono<ClientResponse> filter(ClientRequest clientRequest, ExchangeFunction exchangeFunction) {
        RequestFilterWrapper requestFilterWrapper = this.handleOncePerRequest(clientRequest);
        Mono response = exchangeFunction.exchange(requestFilterWrapper.clientRequest);
        if (requestFilterWrapper.filter.booleanValue() && this.watcherProperties.isWebClient()) {
            try {
                this.chaosMonkeyRequestScope.callChaosMonkey(ChaosTarget.WEB_CLIENT, clientRequest.url().toString());
            }
            catch (Exception exception) {
                try {
                    if (!exception.getClass().equals(this.assaultProperties.getException().getExceptionClass())) {
                        throw exception;
                    }
                    response = Mono.just((Object)ErrorClientResponse.getResponse());
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return response;
    }

    private RequestFilterWrapper handleOncePerRequest(ClientRequest clientRequest) {
        ClientRequest request;
        Boolean filter;
        String filterName = this.getClass().getName() + ALREADY_FILTERED_SUFFIX;
        if (clientRequest.attribute(filterName).isPresent()) {
            filter = Boolean.FALSE;
            request = clientRequest;
        } else {
            filter = Boolean.TRUE;
            request = ClientRequest.from((ClientRequest)clientRequest).attribute(filterName, (Object)Boolean.TRUE).build();
        }
        return new RequestFilterWrapper(request, filter);
    }

    static class ErrorClientResponse {
        static final String ERROR_BODY = "{\"error\": \"This is a Chaos Monkey for Spring Boot generated failure\"}";

        ErrorClientResponse() {
        }

        private static ClientResponse getResponse() {
            return ClientResponse.create((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(ERROR_BODY).build();
        }
    }

    private static class RequestFilterWrapper {
        private final ClientRequest clientRequest;
        private final Boolean filter;

        public ClientRequest getClientRequest() {
            return this.clientRequest;
        }

        public Boolean getFilter() {
            return this.filter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestFilterWrapper)) {
                return false;
            }
            RequestFilterWrapper other = (RequestFilterWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$filter = this.getFilter();
            Boolean other$filter = other.getFilter();
            if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
                return false;
            }
            ClientRequest this$clientRequest = this.getClientRequest();
            ClientRequest other$clientRequest = other.getClientRequest();
            return !(this$clientRequest == null ? other$clientRequest != null : !this$clientRequest.equals(other$clientRequest));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RequestFilterWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $filter = this.getFilter();
            result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
            ClientRequest $clientRequest = this.getClientRequest();
            result = result * 59 + ($clientRequest == null ? 43 : $clientRequest.hashCode());
            return result;
        }

        public String toString() {
            return "ChaosMonkeyWebClientWatcher.RequestFilterWrapper(clientRequest=" + this.getClientRequest() + ", filter=" + this.getFilter() + ")";
        }

        public RequestFilterWrapper(ClientRequest clientRequest, Boolean filter) {
            this.clientRequest = clientRequest;
            this.filter = filter;
        }
    }
}

