/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.component;

import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import de.codecentric.spring.boot.chaos.monkey.events.MetricEvent;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.context.ApplicationListener;

public class Metrics
implements ApplicationListener<MetricEvent> {
    private MeterRegistry meterRegistry = io.micrometer.core.instrument.Metrics.globalRegistry;

    private void counter(MetricType type, String ... tags) {
        if (this.meterRegistry != null && tags != null) {
            this.meterRegistry.counter(type.getMetricName(), tags).increment();
        }
    }

    private void counterWatcher(MetricType type, String name) {
        if (this.meterRegistry != null) {
            this.meterRegistry.counter(String.valueOf(type.getMetricName()) + ".watcher", new String[]{"component", this.extractComponent(name)}).increment();
        }
    }

    private void gauge(MetricType type, double number) {
        if (this.meterRegistry != null) {
            this.meterRegistry.gauge(String.valueOf(type.getMetricName()) + ".gauge.", (Number)number);
        }
    }

    private String extractComponent(String name) {
        return name.replaceAll("execution.", "");
    }

    public void onApplicationEvent(MetricEvent event) {
        if (event.getMetricType().isSignatureOnlyEvent()) {
            this.counterWatcher(event.getMetricType(), event.getMethodSignature());
        } else if (event.getMetricType().isTagEvent()) {
            this.counter(event.getMetricType(), event.getTags());
        } else {
            this.gauge(event.getMetricType(), event.getMetricValue());
            this.counter(event.getMetricType(), event.getTags());
        }
    }
}

