/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.configuration;

import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.ExceptionAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.KillAppAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.LatencyAssault;
import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkey;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.Metrics;
import de.codecentric.spring.boot.chaos.monkey.conditions.AttackComponentCondition;
import de.codecentric.spring.boot.chaos.monkey.conditions.AttackControllerCondition;
import de.codecentric.spring.boot.chaos.monkey.conditions.AttackRepositoryCondition;
import de.codecentric.spring.boot.chaos.monkey.conditions.AttackRestControllerCondition;
import de.codecentric.spring.boot.chaos.monkey.conditions.AttackServiceCondition;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultProperties;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeyProperties;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import de.codecentric.spring.boot.chaos.monkey.endpoints.ChaosMonkeyJmxEndpoint;
import de.codecentric.spring.boot.chaos.monkey.endpoints.ChaosMonkeyRestEndpoint;
import de.codecentric.spring.boot.chaos.monkey.watcher.SpringComponentAspect;
import de.codecentric.spring.boot.chaos.monkey.watcher.SpringControllerAspect;
import de.codecentric.spring.boot.chaos.monkey.watcher.SpringRepositoryAspect;
import de.codecentric.spring.boot.chaos.monkey.watcher.SpringRestControllerAspect;
import de.codecentric.spring.boot.chaos.monkey.watcher.SpringServiceAspect;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StreamUtils;

@Configuration
@Profile(value={"chaos-monkey"})
@EnableConfigurationProperties(value={ChaosMonkeyProperties.class, AssaultProperties.class, WatcherProperties.class})
public class ChaosMonkeyConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChaosMonkey.class);
    private final ChaosMonkeyProperties chaosMonkeyProperties;
    private final WatcherProperties watcherProperties;
    private final AssaultProperties assaultProperties;
    private ApplicationEventPublisher applicationEventPublisher;

    public ChaosMonkeyConfiguration(ChaosMonkeyProperties chaosMonkeyProperties, WatcherProperties watcherProperties, AssaultProperties assaultProperties, ApplicationEventPublisher applicationEventPublisher) {
        this.chaosMonkeyProperties = chaosMonkeyProperties;
        this.watcherProperties = watcherProperties;
        this.assaultProperties = assaultProperties;
        this.applicationEventPublisher = applicationEventPublisher;
        try {
            String chaosLogo = StreamUtils.copyToString((InputStream)new ClassPathResource("chaos-logo.txt").getInputStream(), (Charset)Charset.defaultCharset());
            LOGGER.info(chaosLogo);
        }
        catch (IOException e) {
            LOGGER.info("Chaos Monkey - ready to do evil");
        }
    }

    @Bean
    @ConditionalOnClass(name={"io.micrometer.core.instrument.MeterRegistry"})
    public Metrics metrics() {
        return new Metrics();
    }

    @Bean
    public MetricEventPublisher publisher() {
        return new MetricEventPublisher(this.applicationEventPublisher);
    }

    @Bean
    public ChaosMonkeySettings settings() {
        return new ChaosMonkeySettings(this.chaosMonkeyProperties, this.assaultProperties, this.watcherProperties);
    }

    @Bean
    public LatencyAssault latencyAssault() {
        return new LatencyAssault(this.settings(), this.publisher());
    }

    @Bean
    public ExceptionAssault exceptionAssault() {
        return new ExceptionAssault(this.settings(), this.publisher());
    }

    @Bean
    public KillAppAssault killAppAssault() {
        return new KillAppAssault(this.settings(), this.publisher());
    }

    @Bean
    public ChaosMonkey chaosMonkey(List<ChaosMonkeyAssault> chaosMonkeyAssaults) {
        return new ChaosMonkey(this.settings(), chaosMonkeyAssaults, this.publisher());
    }

    @Bean
    @Conditional(value={AttackControllerCondition.class})
    public SpringControllerAspect controllerAspect(ChaosMonkey chaosMonkey) {
        return new SpringControllerAspect(chaosMonkey, this.publisher());
    }

    @Bean
    @Conditional(value={AttackRestControllerCondition.class})
    public SpringRestControllerAspect restControllerAspect(ChaosMonkey chaosMonkey) {
        return new SpringRestControllerAspect(chaosMonkey, this.publisher());
    }

    @Bean
    @Conditional(value={AttackServiceCondition.class})
    public SpringServiceAspect serviceAspect(ChaosMonkey chaosMonkey) {
        return new SpringServiceAspect(chaosMonkey, this.publisher());
    }

    @Bean
    @Conditional(value={AttackComponentCondition.class})
    public SpringComponentAspect componentAspect(ChaosMonkey chaosMonkey) {
        return new SpringComponentAspect(chaosMonkey, this.publisher());
    }

    @Bean
    @Conditional(value={AttackRepositoryCondition.class})
    public SpringRepositoryAspect repositoryAspect(ChaosMonkey chaosMonkey) {
        return new SpringRepositoryAspect(chaosMonkey, this.publisher());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnEnabledEndpoint
    public ChaosMonkeyRestEndpoint chaosMonkeyRestEndpoint() {
        return new ChaosMonkeyRestEndpoint(this.settings());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnEnabledEndpoint
    public ChaosMonkeyJmxEndpoint chaosMonkeyJmxEndpoint() {
        return new ChaosMonkeyJmxEndpoint(this.settings());
    }
}

