/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.component;

import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyAssault;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class ChaosMonkey {
    private final ChaosMonkeySettings chaosMonkeySettings;
    private final List<ChaosMonkeyAssault> assaults;
    private MetricEventPublisher metricEventPublisher;

    public ChaosMonkey(ChaosMonkeySettings chaosMonkeySettings, List<ChaosMonkeyAssault> assaults, MetricEventPublisher metricEventPublisher) {
        this.chaosMonkeySettings = chaosMonkeySettings;
        this.assaults = assaults;
        this.metricEventPublisher = metricEventPublisher;
    }

    public void callChaosMonkey(String simpleName) {
        if (this.isEnabled() && this.isTrouble()) {
            if (this.metricEventPublisher != null) {
                this.metricEventPublisher.publishMetricEvent(MetricType.APPLICATION_REQ_COUNT, "type", "total");
            }
            if (this.chaosMonkeySettings.getAssaultProperties().isWatchedCustomServicesActive()) {
                if (!this.chaosMonkeySettings.getAssaultProperties().getWatchedCustomServices().isEmpty() && this.chaosMonkeySettings.getAssaultProperties().getWatchedCustomServices().contains(simpleName)) {
                    this.chooseAndRunAttack();
                }
            } else {
                this.chooseAndRunAttack();
            }
        }
    }

    private void chooseAndRunAttack() {
        List<ChaosMonkeyAssault> activeAssaults = this.assaults.stream().filter(ChaosMonkeyAssault::isActive).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(activeAssaults)) {
            return;
        }
        this.getRandomFrom(activeAssaults).attack();
        if (this.metricEventPublisher != null) {
            this.metricEventPublisher.publishMetricEvent(MetricType.APPLICATION_REQ_COUNT, "type", "assaulted");
        }
    }

    private ChaosMonkeyAssault getRandomFrom(List<ChaosMonkeyAssault> activeAssaults) {
        int exceptionRand = this.chaosMonkeySettings.getAssaultProperties().chooseAssault(activeAssaults.size());
        return activeAssaults.get(exceptionRand);
    }

    private boolean isTrouble() {
        return this.chaosMonkeySettings.getAssaultProperties().getTroubleRandom() >= this.chaosMonkeySettings.getAssaultProperties().getLevel();
    }

    private boolean isEnabled() {
        return this.chaosMonkeySettings.getChaosMonkeyProperties().isEnabled();
    }
}

