/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.configuration;

import de.codecentric.spring.boot.chaos.monkey.component.ChaosMonkey;
import de.codecentric.spring.boot.chaos.monkey.conditions.AttackComponentCondition;
import de.codecentric.spring.boot.chaos.monkey.conditions.AttackControllerCondition;
import de.codecentric.spring.boot.chaos.monkey.conditions.AttackRestControllerCondition;
import de.codecentric.spring.boot.chaos.monkey.conditions.AttackServiceCondition;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultProperties;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeyProperties;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import de.codecentric.spring.boot.chaos.monkey.configuration.WatcherProperties;
import de.codecentric.spring.boot.chaos.monkey.endpoints.ChaosMonkeyJmxEndpoint;
import de.codecentric.spring.boot.chaos.monkey.endpoints.ChaosMonkeyRestEndpoint;
import de.codecentric.spring.boot.chaos.monkey.watcher.SpringComponentAspect;
import de.codecentric.spring.boot.chaos.monkey.watcher.SpringControllerAspect;
import de.codecentric.spring.boot.chaos.monkey.watcher.SpringRestControllerAspect;
import de.codecentric.spring.boot.chaos.monkey.watcher.SpringServiceAspect;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StreamUtils;

@Configuration
@Profile(value={"chaos-monkey"})
@EnableConfigurationProperties(value={ChaosMonkeyProperties.class, AssaultProperties.class, WatcherProperties.class})
public class ChaosMonkeyConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChaosMonkey.class);
    private final ChaosMonkeyProperties chaosMonkeyProperties;
    private final WatcherProperties watcherProperties;
    private final AssaultProperties assaultProperties;

    public ChaosMonkeyConfiguration(ChaosMonkeyProperties chaosMonkeyProperties, WatcherProperties watcherProperties, AssaultProperties assaultProperties) {
        this.chaosMonkeyProperties = chaosMonkeyProperties;
        this.watcherProperties = watcherProperties;
        this.assaultProperties = assaultProperties;
        try {
            String chaosLogo = StreamUtils.copyToString((InputStream)new ClassPathResource("chaos-logo.txt").getInputStream(), (Charset)Charset.defaultCharset());
            LOGGER.info(chaosLogo);
        }
        catch (IOException e) {
            LOGGER.info("Chaos Monkey - ready to do evil");
        }
    }

    @Bean
    public ChaosMonkeySettings settings() {
        return new ChaosMonkeySettings(this.chaosMonkeyProperties, this.assaultProperties, this.watcherProperties);
    }

    @Bean
    public ChaosMonkey chaosMonkey() {
        return new ChaosMonkey(this.settings());
    }

    @Bean
    @Conditional(value={AttackControllerCondition.class})
    public SpringControllerAspect controllerAspect() {
        return new SpringControllerAspect(this.chaosMonkey());
    }

    @Bean
    @Conditional(value={AttackRestControllerCondition.class})
    public SpringRestControllerAspect restControllerAspect() {
        return new SpringRestControllerAspect(this.chaosMonkey());
    }

    @Bean
    @Conditional(value={AttackServiceCondition.class})
    public SpringServiceAspect serviceAspect() {
        return new SpringServiceAspect(this.chaosMonkey());
    }

    @Bean
    @Conditional(value={AttackComponentCondition.class})
    public SpringComponentAspect componentAspect() {
        return new SpringComponentAspect(this.chaosMonkey());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnEnabledEndpoint
    public ChaosMonkeyRestEndpoint chaosMonkeyRestEndpoint() {
        return new ChaosMonkeyRestEndpoint(this.settings());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnEnabledEndpoint
    public ChaosMonkeyJmxEndpoint chaosMonkeyJmxEndpoint() {
        return new ChaosMonkeyJmxEndpoint(this.settings());
    }
}

