/*
 * Decompiled with CFR 0.152.
 */
package de.codeboje.requestlogging;

import de.codeboje.requestlogging.Util;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class RequestContextLoggingFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestContextLoggingFilter.class);
    private String requestHeaderId = "X-REQUEST-ID";
    private String logIdentifier = "requestId";

    public RequestContextLoggingFilter(String requestHeaderId, String logIdentifier) {
        if (StringUtils.isNotEmpty((CharSequence)requestHeaderId)) {
            this.requestHeaderId = requestHeaderId;
        }
        if (StringUtils.isNotEmpty((CharSequence)logIdentifier)) {
            this.logIdentifier = logIdentifier;
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            if (!(request instanceof HttpServletRequest)) {
                throw new ServletException("RequestContextLoggingFilter just supports HTTP requests");
            }
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String requestUUID = httpRequest.getHeader(this.requestHeaderId);
            if (StringUtils.isEmpty((CharSequence)requestUUID)) {
                requestUUID = Util.createId();
                LOGGER.info("Got request {} without {} and assign new {}", new Object[]{httpRequest.getRequestURI(), this.requestHeaderId, requestUUID});
            }
            MDC.put((String)this.logIdentifier, (String)requestUUID);
            chain.doFilter(request, response);
        }
        finally {
            MDC.clear();
        }
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

