/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.oauth.interceptor;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.cidaas.oauth.interceptor.OAuthScopes;
import de.cidaas.oauth.interceptor.ValidateToken;
import de.cidaas.oauth.model.OAuthAccessResourceRequest;
import de.cidaas.oauth.model.OAuthUser;
import de.cidaas.oauth.model.ServerResponse;
import de.cidaas.oauth.model.TokenIntrospectionRequest;
import de.cidaas.oauth.model.TokenIntrospectionResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class OAuthInterceptor
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthInterceptor.class);
    private static final List<MediaType> typeJson = new ArrayList<MediaType>();
    private static final List<MediaType> typeXML = new ArrayList<MediaType>();
    private ApplicationContext appContext;
    private static final String ACCESS_DENIED = "Access denied for this resource";

    public OAuthInterceptor() {
    }

    public OAuthInterceptor(ApplicationContext applicationContext) {
        if (applicationContext != null) {
            this.appContext = applicationContext;
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        TokenIntrospectionRequest requestInfo;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        LOGGER.info("Logging Request  {} : {}", (Object)httpRequest.getMethod(), (Object)httpRequest.getRequestURI());
        HandlerMethod handlerMethod = null;
        try {
            RequestMappingHandlerMapping req2HandlerMapping = (RequestMappingHandlerMapping)this.appContext.getBean("requestMappingHandlerMapping");
            HandlerExecutionChain handlerExeChain = req2HandlerMapping.getHandler(httpRequest);
            if (Objects.nonNull(handlerExeChain)) {
                handlerMethod = (HandlerMethod)handlerExeChain.getHandler();
                Method method = handlerMethod.getMethod();
                if (method.isAnnotationPresent(PermitAll.class)) {
                    LOGGER.info("Method has PermitAll:" + method.getName());
                    filterChain.doFilter(request, response);
                    return;
                }
                if (method.isAnnotationPresent(DenyAll.class)) {
                    LOGGER.info("Method has DenyAll:" + method.getName());
                    this.getStatusMessage(httpResponse, 401, ACCESS_DENIED);
                    return;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Lookup the handler method", (Throwable)e);
        }
        try {
            requestInfo = this.prepareTokenRequest(httpRequest, handlerMethod);
        }
        catch (Exception ex) {
            LOGGER.error("Exception {}", (Throwable)ex);
            this.getStatusMessage(httpResponse, 401, ACCESS_DENIED);
            return;
        }
        String accessToken = null;
        try {
            OAuthAccessResourceRequest oauthRequest = new OAuthAccessResourceRequest(httpRequest);
            accessToken = oauthRequest.getAccessToken();
            LOGGER.info("Access Token : {}", (Object)accessToken);
            requestInfo.setToken(accessToken);
        }
        catch (Exception ex) {
            LOGGER.error("Exception {}", (Throwable)ex);
            this.getStatusMessage(httpResponse, 401, ACCESS_DENIED);
            return;
        }
        TokenIntrospectionResponse tokenValidationResp = ValidateToken.getInstance().validateAccessToken(requestInfo);
        if (tokenValidationResp == null || !tokenValidationResp.isActive()) {
            LOGGER.error("Access denied for URL {}", (Object)requestInfo.getRequest_url());
            this.getStatusMessage(httpResponse, 401, ACCESS_DENIED);
            return;
        }
        OAuthUser u = new OAuthUser(accessToken, tokenValidationResp.getSub());
        LOGGER.info("Interceptor got user {} from token {}.", (Object)u.getUserId(), (Object)accessToken);
        request.setAttribute("User-details", (Object)u);
        filterChain.doFilter(request, response);
        LOGGER.info("Logging Response :{}", (Object)response.getContentType());
    }

    public void destroy() {
    }

    private TokenIntrospectionRequest prepareTokenRequest(HttpServletRequest request, HandlerMethod handlerMethod) {
        TokenIntrospectionRequest tokenIntrospectionRequest = new TokenIntrospectionRequest();
        if (handlerMethod != null && handlerMethod.getMethod() != null) {
            tokenIntrospectionRequest.setScopes(this.getAnotationRequestedScope(handlerMethod.getMethod()));
            tokenIntrospectionRequest.setRoles(this.getAnotationRequestedRoles(handlerMethod.getMethod()));
        }
        tokenIntrospectionRequest.setRequest_time(new Date().getTime());
        tokenIntrospectionRequest.setRequest_url(request.getRequestURL().toString());
        ArrayList<String> allHeaders = Collections.list(request.getHeaderNames());
        for (String headerKey : allHeaders) {
            String _headerKey = headerKey.toLowerCase();
            if (_headerKey.contains("cookie") || _headerKey.equalsIgnoreCase("authorization") || _headerKey.equals("__access_token")) continue;
            tokenIntrospectionRequest.getRequest_headers().put(headerKey, request.getHeader(headerKey));
        }
        String ipAddress = request.getHeader("X-FORWARDED-FOR");
        if (ipAddress == null) {
            ipAddress = request.getRemoteAddr();
        }
        if (ipAddress != null && ipAddress.contains(",")) {
            ipAddress = ipAddress.split(",")[0];
        }
        if (!StringUtils.isEmpty((Object)ipAddress)) {
            tokenIntrospectionRequest.getRequest_headers().put("x-forwarded-for", ipAddress);
        }
        return tokenIntrospectionRequest;
    }

    protected String[] getAnotationRequestedScope(Method method) {
        OAuthScopes oAuthScopes;
        if (method.isAnnotationPresent(OAuthScopes.class) && (oAuthScopes = method.getAnnotation(OAuthScopes.class)) != null && oAuthScopes.scopes().length > 0) {
            return oAuthScopes.scopes();
        }
        return null;
    }

    protected String[] getAnotationRequestedRoles(Method method) {
        RolesAllowed rolesAnnotation;
        if (method.isAnnotationPresent(RolesAllowed.class) && (rolesAnnotation = method.getAnnotation(RolesAllowed.class)) != null && rolesAnnotation.value().length > 0) {
            return rolesAnnotation.value();
        }
        return null;
    }

    private HttpServletResponse getStatusMessage(HttpServletResponse httpResponse, int status, String message) throws IOException {
        httpResponse.setStatus(status);
        String json = new ObjectMapper().writeValueAsString((Object)new ServerResponse(message));
        httpResponse.getWriter().write(json);
        httpResponse.flushBuffer();
        return httpResponse;
    }

    static {
        typeJson.add(MediaType.APPLICATION_JSON);
        typeXML.add(MediaType.APPLICATION_XML);
        typeXML.add(MediaType.APPLICATION_ATOM_XML);
        typeXML.add(MediaType.TEXT_XML);
    }
}

