/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.oauth.interceptor;

import de.cidaas.oauth.interceptor.Constants;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.apache.oltu.oauth2.common.validators.AbstractValidator;

public class BearerHeaderOAuthValidator
extends AbstractValidator<HttpServletRequest> {
    public void validateContentType(HttpServletRequest request) throws OAuthProblemException {
    }

    public void validateMethod(HttpServletRequest request) throws OAuthProblemException {
    }

    public void validateRequiredParameters(HttpServletRequest request) throws OAuthProblemException {
        Map values;
        String oauthVersionDiff;
        boolean cidaasStyle = false;
        String authzHeader = request.getHeader("Authorization");
        if (OAuthUtils.isEmpty((String)authzHeader)) {
            authzHeader = request.getHeader(Constants.get_tokenKey());
            if (OAuthUtils.isEmpty((String)authzHeader)) {
                throw OAuthProblemException.error((String)"", (String)"Missing authorization header.");
            }
            cidaasStyle = true;
        }
        if (!cidaasStyle) {
            String authzMethod = OAuthUtils.getAuthzMethod((String)authzHeader);
            if (!"Bearer".equals(authzMethod)) {
                throw OAuthProblemException.error((String)"", (String)"Incorrect authorization method.");
            }
            String headerField = OAuthUtils.getAuthHeaderField((String)authzHeader);
            if (OAuthUtils.isEmpty((String)headerField)) {
                throw OAuthProblemException.error((String)"invalid_request", (String)"Missing required parameter.");
            }
        }
        if (!OAuthUtils.isEmpty((String)(oauthVersionDiff = (String)(values = OAuthUtils.decodeOAuthHeader((String)authzHeader)).get("oauth_signature_method")))) {
            throw OAuthProblemException.error((String)"invalid_request", (String)"Incorrect OAuth version. Found OAuth V1.0.");
        }
    }
}

