/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.config;

import de.cidaas.config.TokenAuthentication;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.GenericFilterBean;

public class TokenFilterBean
extends GenericFilterBean {
    @Autowired
    private AuthenticationManager authenticationManager;

    public void doFilter(ServletRequest req, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        if (SecurityContextHolder.getContext().getAuthentication() != null) {
            this.logger.info((Object)"User already authenticated!");
            chain.doFilter((ServletRequest)request, response);
            return;
        }
        String header = request.getHeader("Authorization");
        if (header == null) {
            chain.doFilter((ServletRequest)request, response);
            return;
        }
        if (!StringUtils.isEmpty((Object)header) && header.startsWith("Bearer ")) {
            try {
                this.logger.debug((Object)("JWT Token " + header));
                String token = header.split("\\s")[1].trim();
                TokenAuthentication tokenAuthentication = new TokenAuthentication();
                tokenAuthentication.setToken(token);
                Authentication authentication = this.authenticationManager.authenticate((Authentication)tokenAuthentication);
                SecurityContextHolder.getContext().setAuthentication(authentication);
            }
            catch (AuthenticationException ex) {
                this.logger.debug((Object)("Authentication failed on header " + header), (Throwable)ex);
                SecurityContextHolder.clearContext();
            }
        }
        chain.doFilter((ServletRequest)request, response);
    }
}

