/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.config;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cidaas.config.TokenAuthentication;
import de.cidaas.oauth.util.DecodeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;

@Service
public class TokenAuthenticationProvider
implements AuthenticationProvider {
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        TokenAuthentication tokenAuthentication = (TokenAuthentication)authentication;
        String userDetails = DecodeToken.getUserInfo(tokenAuthentication.getToken());
        Map map = null;
        try {
            map = (Map)new ObjectMapper().readValue(userDetails, Map.class);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        if (map.containsKey("roles")) {
            if (map.containsKey("roles")) {
                String[] roleList;
                Object rolesObj = map.get("roles");
                String roles = rolesObj.toString().replace("[", "").replace("]", "");
                for (String value : roleList = roles.split(",")) {
                    authorities.add(new SimpleGrantedAuthority("ROLE_" + value.trim()));
                }
            }
        } else if (map.containsKey("scopes")) {
            String[] scopeList;
            Object scopeObj = map.get("scopes");
            String scopes = scopeObj.toString().replace("[", "").replace("]", "");
            for (String value : scopeList = scopes.split(",")) {
                authorities.add(new SimpleGrantedAuthority(value.trim()));
            }
        }
        tokenAuthentication.setDetails(map);
        tokenAuthentication.setAuthorities(authorities);
        tokenAuthentication.setPrincipal(userDetails);
        tokenAuthentication.setName((String)map.get("given_name"));
        tokenAuthentication.setAuthenticated(true);
        return tokenAuthentication;
    }

    public <T> List<T> getValues(Map<?, T> map) {
        return new ArrayList<T>(map.values());
    }

    public boolean supports(Class<?> arg0) {
        return TokenAuthentication.class.isAssignableFrom(arg0);
    }
}

