/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.config;

import de.cidaas.config.KeycloakPublicKeyService;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.keycloak.RSATokenVerifier;
import org.keycloak.exceptions.TokenVerificationException;
import org.keycloak.representations.AccessToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class KeycloakUserDetailsService
implements UserDetailsService {
    private static Map<String, PublicKey> keys = new ConcurrentHashMap<String, PublicKey>();
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    KeycloakPublicKeyService keycloakPublicKeyService;
    @Value(value="${keycloak.realmUrl}")
    private String realmUrl;

    public UserDetails loadUserByUsername(String jwt) throws UsernameNotFoundException {
        try {
            RSATokenVerifier rsaTokenVerifier = RSATokenVerifier.create((String)jwt);
            PublicKey publicKey = this.keycloakPublicKeyService.publicKey(rsaTokenVerifier.getHeader().getKeyId());
            AccessToken accessToken = rsaTokenVerifier.realmUrl(this.realmUrl).publicKey(publicKey).verify().getToken();
            List authorities = accessToken.getRealmAccess().getRoles().stream().map(r -> new SimpleGrantedAuthority("ROLE_" + r)).collect(Collectors.toList());
            return new User(accessToken.getEmail(), "changed", authorities);
        }
        catch (TokenVerificationException e) {
            throw new UsernameNotFoundException("Invalid token signature (or expired)! " + jwt, (Throwable)e);
        }
        catch (Exception e) {
            throw new UsernameNotFoundException("Error validating token" + jwt, (Throwable)e);
        }
    }
}

