package de.cidaas.oauth.interceptor;

import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

import de.cidaas.oauth.util.ConfigurationLoader;


public class Constants {
	/** The Constant LOG. */
	private static final Logger LOG = LoggerFactory.getLogger(Constants.class);

	/** The Constant PROPS. */
	private static final String PROPS = "cidaas_config.properties";

	/** The Constant HEADER_SCOPES. */
	static final String HEADER_SCOPES = "scopes";

	/** The Constant ESCAPE_KEY. */
	static final String ESCAPE_KEY = ConfigurationLoader.getPropertyByKey("swagger_bypass_key", PROPS);

	/** The Constant SWAGGER_UI_CLASS_NAME. */
	static final String SWAGGER_UI_CLASS_NAME = "io.swagger.jaxrs.listing.ApiListingResource";

	/** The Constant SWAGGER_UI_METHOD_NAME. */
	static final String SWAGGER_UI_METHOD_NAME = "getListing";

	/**
	 * Instantiates a new constants.
	 */
	private Constants() {
	}

	/** The token key. */
	private static String tokenKey = null;

	/**
	 * Gets the token key.
	 *
	 * @return the token key
	 */
	public static String get_tokenKey() {
		String prop_variable = "tokenKey";
		tokenKey = ConfigurationLoader.getPropertyByKey(prop_variable, PROPS);
		if (StringUtils.isEmpty(tokenKey)) {
			tokenKey = "access_token";
		}
		return tokenKey;
	}

	/** The cidaas interceptor base url. */
	private static String cidaas_interceptor_base_url = null;

	/**
	 * Gets the cidaas base url.
	 *
	 * @return the cidaas base url
	 */
	private static String get_cidaas_interceptor_base_url() {
		String prop_variable = "cidaas_interceptor_base_url";
		cidaas_interceptor_base_url = ConfigurationLoader.getPropertyByKey(prop_variable, PROPS);
		if (cidaas_interceptor_base_url == null) {
			cidaas_interceptor_base_url = "";
		}

		// TODO : just to support the backward capability to support old
		// "oauth2-login.baseurl" property
		if (StringUtils.isEmpty(cidaas_interceptor_base_url)) {
			String loginBaseURL = ConfigurationLoader.getPropertyByKey("oauth2-login.baseurl", PROPS);
			cidaas_interceptor_base_url = loginBaseURL;
		}

		return cidaas_interceptor_base_url;
	}

	public static int get_max_token_usage_update_count() {
		String prop_variable = "max_token_usage_update_count";
		int count = 50;
		String val = ConfigurationLoader.getPropertyByKey(prop_variable, PROPS);
		if (StringUtils.isEmpty(val)) {
			return count;
		}

		try {
			count = Integer.parseInt(val);
		} catch (Exception ex) {

		}
		return count;
	}
	
	public static int get_token_usage_update_interval() {
		String prop_variable = "token_usage_update_interval";
		int count = 5;
		String val = ConfigurationLoader.getPropertyByKey(prop_variable, PROPS);
		if (StringUtils.isEmpty(val)) {
			return count;
		}

		try {
			count = Integer.parseInt(val);
		} catch (Exception ex) {

		}
		return count;
	}

	public static String get_user_info_by_token() {
		String prop_variable = "user_info_by_token";
		String val = ConfigurationLoader.getPropertyByKey(prop_variable, PROPS);
		if (StringUtils.isEmpty(val)) {
			val = "/tokens/userinfobytoken";
		}

		if (val.startsWith("http://") || val.startsWith("https://")) {
			return val;
		}

		val = combilePath(get_cidaas_interceptor_base_url(), val);

		return val;
	}

	public static String get_update_token_check_urll() {
		String prop_variable = "update_token_check_url";
		String val = ConfigurationLoader.getPropertyByKey(prop_variable, PROPS);
		if (StringUtils.isEmpty(val)) {
			val = "/oauth2/updatetokencheck";
		}

		if (val.startsWith("http://") || val.startsWith("https://")) {
			return val;
		}

		val = combilePath(get_cidaas_interceptor_base_url(), val);

		return val;
	}

	public static String get_private_key_path() {
		String prop_variable = "JWE_Private_Key_Path";
		return ConfigurationLoader.getPropertyByKey(prop_variable, PROPS);
	}

	private static String combilePath(String... paths) {

		String urlToReturn = paths[0];
		for (int i = 1; i < paths.length; i++) {
			if (urlToReturn.endsWith("/") && paths[i].startsWith("/")) {
				urlToReturn = urlToReturn.substring(0, urlToReturn.length() - 1);
				urlToReturn = urlToReturn + paths[i];
			} else if (urlToReturn.endsWith("/") && !paths[i].startsWith("/")) {
				urlToReturn = urlToReturn + paths[i];
			} else if (!urlToReturn.endsWith("/") && paths[i].startsWith("/")) {
				urlToReturn = urlToReturn + paths[i];
			} else if (!urlToReturn.endsWith("/") && !paths[i].startsWith("/")) {
				urlToReturn = urlToReturn + "/" + paths[i];
			}
		}

		if (urlToReturn.endsWith("/")) {
			urlToReturn = urlToReturn.substring(0, urlToReturn.length() - 1);
		}

		return urlToReturn;
	}

	/**
	 * Load string value from property.
	 *
	 * @param prop_cache_variable
	 *            the prop cache variable
	 * @param prop_variable
	 *            the prop variable
	 * @return the string
	 */
	public static String loadStringValueFromProperty(String prop_cache_variable, String prop_variable) {
		if (StringUtils.isEmpty(prop_cache_variable)) {
			prop_cache_variable = ConfigurationLoader.getPropertyByKey(prop_variable, PROPS);
			if (StringUtils.isEmpty(prop_cache_variable)) {
				Properties p = ConfigurationLoader.getPropertiesOfFile(PROPS);
				if (p == null)
					LOG.info(PROPS + " Not found.");
				else
					LOG.info(prop_variable + "not accessible. property file not found: " + PROPS);
			}
		}
		return prop_cache_variable;
	}
}
