package de.cidaas.oauth.interceptor;

import javax.servlet.http.HttpServletRequest;

import org.apache.oltu.oauth2.common.OAuth;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.apache.oltu.oauth2.rs.extractor.TokenExtractor;

public class BearerHeaderTokenExtractor implements TokenExtractor{
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.apache.oltu.oauth2.rs.extractor.TokenExtractor#getAccessToken(javax.
	 * servlet.http.HttpServletRequest)
	 */
	@Override
	public String getAccessToken(HttpServletRequest request) {
		String authzHeader = request.getHeader(OAuth.HeaderType.AUTHORIZATION);
		if (authzHeader == null) {
			return request.getHeader(Constants.get_tokenKey());
		} else {
			return OAuthUtils.getAuthHeaderField(authzHeader);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.apache.oltu.oauth2.rs.extractor.TokenExtractor#getAccessToken(javax.
	 * servlet.http.HttpServletRequest, java.lang.String)
	 */
	@Override
	public String getAccessToken(HttpServletRequest request, String tokenName) {
		String authzHeader = request.getHeader(OAuth.HeaderType.AUTHORIZATION);
		if (authzHeader == null) {
			return request.getHeader(Constants.get_tokenKey());
		} else {
			return OAuthUtils.getAuthHeaderField(authzHeader);
		}
	}
}
