package de.cidaas.config;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Objects;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.filter.GenericFilterBean;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import de.cidaas.oauth.interceptor.OAuthInterceptor;

public class OptionsFilter extends GenericFilterBean {

	@Autowired
	private org.springframework.context.ApplicationContext appContext;

	@Override
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
			throws IOException, ServletException {

		HttpServletRequest req = (HttpServletRequest) request;
		HttpServletResponse resp = (HttpServletResponse) response;

		resp.addHeader("Access-Control-Allow-Origin", req.getHeader("Origin"));
		resp.addHeader("Access-Control-Allow-Methods", "GET, POST, OPTIONS, PUT, DELETE, PATCH");
		resp.addHeader("Access-Control-Allow-Headers",
				"accept, authorization, content-type, x-requested-with,Authorization");
		resp.addHeader("Access-Control-Allow-Credentials", "true");
		resp.addHeader("Access-Control-Max-Age", "1");
		resp.addHeader("Access-Control-Expose-Headers", "Location");
		OAuthInterceptor interceptor = new OAuthInterceptor(appContext);


		if (req.getMethod().equalsIgnoreCase("OPTIONS")) {
			chain.doFilter(request, response);
		} else {
//			 chain.doFilter(request, response);
			interceptor.doFilter(request, response, chain);
		}
	}
}
