/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.oauth.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cidaas.oauth.util.ConfigurationLoader;
import de.cidaas.oauth.util.OpenIdConfiguration;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CidaasConfigResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationLoader.class);
    private static final String PROPS = "cidaas_config.properties";
    private ObjectMapper om = this.om.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
    private static CidaasConfigResolver _URLResolver;
    public OpenIdConfiguration openIdConfiguration;
    public String client_id;
    public String client_secret;

    public static synchronized CidaasConfigResolver getInstance() throws Exception {
        if (_URLResolver == null) {
            _URLResolver = new CidaasConfigResolver();
        }
        return _URLResolver;
    }

    public CidaasConfigResolver() throws Exception {
        String cidaas_base_url = System.getenv("cidaas_base_url");
        if (StringUtils.isEmpty((CharSequence)cidaas_base_url) && StringUtils.isEmpty((CharSequence)(cidaas_base_url = ConfigurationLoader.getPropertyByKey("base_url", PROPS)))) {
            throw new Exception("Cidaas Base URL is must not be empty. Please add it in the Environment Variable wiht Key : cidaas_base_url or Create the cidaas_config.properties file and the property as base_url");
        }
        this.openIdConfiguration = this.resolveOpenIdConnectURL(cidaas_base_url);
        String cidaas_client_id = System.getenv("cidaas_client_id");
        if (StringUtils.isEmpty((CharSequence)cidaas_client_id) && StringUtils.isEmpty((CharSequence)(cidaas_client_id = ConfigurationLoader.getPropertyByKey("client_id", PROPS)))) {
            throw new Exception("Cidaas client_id is must not be empty. Please add it in the Environment Variable wiht Key : cidaas_client_id or Create the cidaas_config.properties file and the property as client_id");
        }
        this.client_id = cidaas_client_id;
        String cidaas_client_secret = System.getenv("cidaas_client_secret");
        if (StringUtils.isEmpty((CharSequence)cidaas_client_secret) && StringUtils.isEmpty((CharSequence)(cidaas_client_secret = ConfigurationLoader.getPropertyByKey("client_secret", PROPS)))) {
            throw new Exception("Cidaas client_secret is must not be empty. Please add it in the Environment Variable wiht Key : cidaas_client_secret or Create the cidaas_config.properties file and the property as client_secret");
        }
        this.client_secret = cidaas_client_secret;
    }

    private OpenIdConfiguration resolveOpenIdConnectURL(String base_url) throws Exception {
        try {
            String uri = CidaasConfigResolver.combinePath(base_url, ".well-known/openid-configuration");
            HttpGet resetPost = new HttpGet(new URI(uri));
            CloseableHttpResponse response = HttpClientBuilder.create().build().execute((HttpUriRequest)resetPost);
            int responseStatusCode = response.getStatusLine().getStatusCode();
            if (responseStatusCode == 200) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuffer resultData = new StringBuffer();
                String line = "";
                while ((line = rd.readLine()) != null) {
                    resultData.append(line);
                }
                OpenIdConfiguration json = (OpenIdConfiguration)this.om.readValue(resultData.toString(), OpenIdConfiguration.class);
                return json;
            }
            throw new Exception("Error while resolving the openid-configuration service, status code : " + responseStatusCode);
        }
        catch (Exception ex) {
            throw new Exception("Error while resolving the openid-configuration, Error : " + ex);
        }
    }

    private static String combinePath(String ... paths) {
        String urlToReturn = paths[0];
        for (int i = 1; i < paths.length; ++i) {
            if (urlToReturn.endsWith("/") && paths[i].startsWith("/")) {
                urlToReturn = urlToReturn.substring(0, urlToReturn.length() - 1);
                urlToReturn = urlToReturn + paths[i];
                continue;
            }
            if (urlToReturn.endsWith("/") && !paths[i].startsWith("/")) {
                urlToReturn = urlToReturn + paths[i];
                continue;
            }
            if (!urlToReturn.endsWith("/") && paths[i].startsWith("/")) {
                urlToReturn = urlToReturn + paths[i];
                continue;
            }
            if (urlToReturn.endsWith("/") || paths[i].startsWith("/")) continue;
            urlToReturn = urlToReturn + "/" + paths[i];
        }
        if (urlToReturn.endsWith("/")) {
            urlToReturn = urlToReturn.substring(0, urlToReturn.length() - 1);
        }
        return urlToReturn;
    }
}

