/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.oauth.interceptor;

import de.cidaas.oauth.interceptor.CBBearerResourceServer;
import javax.servlet.http.HttpServletRequest;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.ParameterStyle;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.apache.oltu.oauth2.common.validators.OAuthValidator;
import org.apache.oltu.oauth2.rs.ResourceServer;
import org.apache.oltu.oauth2.rs.extractor.TokenExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CBOAuthAccessResourceRequest {
    private static final Logger LOG = LoggerFactory.getLogger(CBOAuthAccessResourceRequest.class);
    private final HttpServletRequest request;
    private ResourceServer usedResourceServer;
    private TokenExtractor extractor;
    private final ParameterStyle[] parameterStyles = new ParameterStyle[]{ParameterStyle.HEADER, ParameterStyle.BODY, ParameterStyle.QUERY};

    public CBOAuthAccessResourceRequest(HttpServletRequest request) throws OAuthSystemException, OAuthProblemException {
        this.request = request;
        this.validate();
    }

    public String getAccessToken() throws OAuthSystemException {
        return this.extractor.getAccessToken(this.request);
    }

    private void validate() throws OAuthSystemException, OAuthProblemException {
        int foundValidStyles = 0;
        boolean lackAuthInfo = false;
        String lackAuthReason = "OAuth parameters were not found";
        CBBearerResourceServer resourceServer = new CBBearerResourceServer();
        ParameterStyle usedStyle = null;
        for (ParameterStyle style : this.parameterStyles) {
            if (foundValidStyles > 0) continue;
            try {
                OAuthValidator validator = resourceServer.instantiateValidator(style);
                validator.validateContentType(this.request);
                validator.validateMethod(this.request);
                validator.validateRequiredParameters(this.request);
                this.usedResourceServer = resourceServer;
                usedStyle = style;
                ++foundValidStyles;
            }
            catch (OAuthProblemException e) {
                LOG.error("Validation did nod succeed whith style: {}, {}", (Object)style, (Object)e.getMessage());
                if (!OAuthUtils.isEmpty((String)e.getError())) continue;
                lackAuthInfo = true;
                lackAuthReason = e.getDescription();
            }
        }
        if (foundValidStyles > 1) {
            throw OAuthProblemException.error((String)"invalid_request", (String)"Found more than one mechanism for authenticating client");
        }
        if (foundValidStyles == 0 && lackAuthInfo) {
            throw OAuthProblemException.error(null, (String)lackAuthReason);
        }
        if (foundValidStyles == 0) {
            throw OAuthProblemException.error((String)"invalid_request", (String)"OAuth parameters were not found");
        }
        this.extractor = this.usedResourceServer.instantiateExtractor(usedStyle);
    }
}

