/*
 * Decompiled with CFR 0.152.
 */
package de.cidaas.cache;

import de.cidaas.cache.LRUCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTokenCache {
    private static final Logger LOG = LoggerFactory.getLogger(LocalTokenCache.class);
    static LRUCache lru_cache = LRUCache.getInstance(5000);
    private LocalTokenCache _LocalTokenCache = null;

    public LocalTokenCache getInstance() {
        if (this._LocalTokenCache == null) {
            this._LocalTokenCache = new LocalTokenCache();
        }
        return this._LocalTokenCache;
    }

    public boolean isTokenPresent(String token) {
        try {
            int shorten_token = token.hashCode();
            return lru_cache.get(shorten_token) != null;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return false;
        }
    }

    public void storeToken(String token) {
        try {
            int shorten_token = token.hashCode();
            lru_cache.put(shorten_token, shorten_token);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
    }

    public void removeToken(String token) {
        try {
            int shorten_token = token.hashCode();
            lru_cache.remove(shorten_token);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
    }
}

