package de.cidaas.oauth.interceptor;

import java.lang.reflect.Method;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The Class LoggingInterceptor.
 *
 * @author : thomaswidmann
 * @since: 10.12.2016
 *         <p>
 * 				copyright: WidasConcepts 2016
 *         </p>
 */
@Provider
public class LoggingInterceptor implements javax.ws.rs.container.ContainerRequestFilter {

	/** The Constant LOG. */
	private static final Logger LOG = LoggerFactory.getLogger(LoggingInterceptor.class);

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * javax.ws.rs.container.ContainerRequestFilter#filter(javax.ws.rs.container.
	 * ContainerRequestContext)
	 */
	@Override
	public void filter(ContainerRequestContext requestContext) {

		// Get the access token
		// String accessToken = oauthRequest.getAccessToken();
		ResourceMethodInvoker methodInvoker = (ResourceMethodInvoker) requestContext
				.getProperty("org.jboss.resteasy.core.ResourceMethodInvoker");
		Method method = methodInvoker.getMethod();
		LOG.error("Started interception");
		LOG.error("Method:" + method.getName());
		// Access allowed for all
		if (method.isAnnotationPresent(PermitAll.class)) {
			LOG.error("Has PermitAll:");
		}
		// Access denied for all
		if (method.isAnnotationPresent(DenyAll.class)) {
			LOG.error("Has DenyAll:");
		}

	}

}
