package de.cidaas.oauth.interceptor;

import org.apache.oltu.oauth2.common.message.types.ParameterStyle;
import org.apache.oltu.oauth2.rs.ResourceServer;
import org.apache.oltu.oauth2.rs.validator.BearerBodyOAuthValidator;
import org.apache.oltu.oauth2.rs.validator.BearerQueryOAuthValidator;

/**
 * The Class CBBearerResourceServer.
 *
 * @author : thomaswidmann
 * @since: 10.12.2016
 *         <p>
 * 				copyright: WidasConcepts 2016
 *         </p>
 */
public class CBBearerResourceServer extends ResourceServer {

	/**
	 * Instantiates a new CB bearer resource server.
	 */
	public CBBearerResourceServer() {
		extractors.put(ParameterStyle.HEADER, CBBearerHeaderTokenExtractor.class);
		extractors.put(ParameterStyle.BODY, CBBearerBodyTokenExtractor.class);
		extractors.put(ParameterStyle.QUERY, CBBearerQueryTokenExtractor.class);

		validators.put(ParameterStyle.HEADER, CBBearerHeaderOAuthValidator.class);
		validators.put(ParameterStyle.BODY, BearerBodyOAuthValidator.class);
		validators.put(ParameterStyle.QUERY, BearerQueryOAuthValidator.class);
	}

}
