package de.cidaas.cache;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTokenCache {
	private static final Logger LOG = LoggerFactory.getLogger(LocalTokenCache.class);
	static LRUCache lru_cache = LRUCache.getInstance(5000);

	private LocalTokenCache _LocalTokenCache = null;

	public LocalTokenCache getInstance() {
		if (_LocalTokenCache == null) {
			_LocalTokenCache = new LocalTokenCache();
		}
		return _LocalTokenCache;
	}

	public boolean isTokenPresent(String token) {
		try {
			int shorten_token = token.hashCode();
			if (lru_cache.get(shorten_token) != null) {
				return true;
			}
			return false;
		} catch (Exception e) {
			LOG.error(e.getMessage());
			return false;
		}
	}

	public void storeToken(String token) {
		try {
			int shorten_token = token.hashCode();
			lru_cache.put(shorten_token, shorten_token);
		} catch (Exception e) {
			LOG.error(e.getMessage());
		}
	}

	public void removeToken(String token) {
		try {
			int shorten_token = token.hashCode();
			lru_cache.remove(shorten_token);
		} catch (Exception e) {
			LOG.error(e.getMessage());
		}
	}

}