/*
 * Decompiled with CFR 0.152.
 */
package de.carne.jfx.scene.control.aboutinfo;

import de.carne.boot.Exceptions;
import de.carne.jfx.scene.control.DialogController;
import de.carne.jfx.scene.control.aboutinfo.AboutInfoI18N;
import de.carne.util.ManifestInfos;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import org.eclipse.jdt.annotation.Nullable;

public class AboutInfoController
extends DialogController<ButtonType> {
    @FXML
    private TabPane ctlInfoTabs;

    public AboutInfoController setModuleInfo(ManifestInfos moduleInfos) {
        ((Dialog)this.getUI()).setTitle(AboutInfoI18N.formatSTR_STAGE_TITLE(moduleInfos.name()));
        ((Dialog)this.getUI()).setHeaderText(AboutInfoI18N.formatSTR_TEXT_HEADER(moduleInfos.name(), moduleInfos.version(), moduleInfos.build()));
        return this;
    }

    public AboutInfoController setLogo(Image image) {
        ((Dialog)this.getUI()).setGraphic((Node)new ImageView(image));
        return this;
    }

    public AboutInfoController addInfo(@Nullable URL url) {
        if (url != null) {
            try (BufferedReader infoReader = new BufferedReader(new InputStreamReader(url.openStream()));){
                String infoTextLine;
                String infoTitle = infoReader.readLine();
                if (infoTitle == null) {
                    throw new IllegalArgumentException("Empty info resource: " + url);
                }
                StringBuilder infoTextBuffer = new StringBuilder();
                while ((infoTextLine = infoReader.readLine()) != null) {
                    infoTextBuffer.append(infoTextLine).append('\n');
                }
                TextArea infoTextArea = new TextArea(infoTextBuffer.toString());
                infoTextArea.setEditable(false);
                AnchorPane infoTextPane = new AnchorPane(new Node[]{infoTextArea});
                AnchorPane.setLeftAnchor((Node)infoTextArea, (Double)0.0);
                AnchorPane.setTopAnchor((Node)infoTextArea, (Double)0.0);
                AnchorPane.setRightAnchor((Node)infoTextArea, (Double)0.0);
                AnchorPane.setBottomAnchor((Node)infoTextArea, (Double)0.0);
                this.ctlInfoTabs.getTabs().add((Object)new Tab(infoTitle, (Node)infoTextPane));
            }
            catch (IOException e) {
                Exceptions.warn((Throwable)e);
            }
        }
        return this;
    }
}

