/*
 * I18N resource strings
 *
 * Generated on 17.02.2019 08:19:17
 */
package de.carne.jfx.util.validation;

import java.text.MessageFormat;
import java.util.ResourceBundle;

/**
 * Package localization resources.
 */
public final class ValidationAlertsI18N {

	/**
	 * The BUNDLE represented by this class.
	 */
	public static final ResourceBundle BUNDLE = ResourceBundle.getBundle(ValidationAlertsI18N.class.getName());

	/**
	 * Format a resource string.
	 * @param key The resource key.
	 * @param arguments Format arguments.
	 * @return The formated string.
	 */
	public static String format(String key, Object... arguments) {
		String pattern = BUNDLE.getString(key);

		return (arguments.length > 0 ? MessageFormat.format(pattern, arguments) : pattern);
	}

	/**
	 * Resource key {@code STR_MESSAGE_VALIDATION_ERROR}
	 * <p>
	 * Validation error
	 */
	public static final String STR_MESSAGE_VALIDATION_ERROR = "STR_MESSAGE_VALIDATION_ERROR";

	/**
	 * Resource string {@code STR_MESSAGE_VALIDATION_ERROR}
	 * <p>
	 * Validation error
	 *
	 * @param arguments Format arguments.
	 * @return The formated string.
	 */
	public static String formatSTR_MESSAGE_VALIDATION_ERROR(Object... arguments) {
		return format(STR_MESSAGE_VALIDATION_ERROR, arguments);
	}

}
