/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.query.Query;

public abstract class DAO<T> {
    private Morphium morphium;
    private Class<? extends T> type;
    private AnnotationAndReflectionHelper ah = new AnnotationAndReflectionHelper();

    public DAO(Morphium m, Class<? extends T> type) {
        this.type = type;
        this.morphium = m;
    }

    public Query<T> getQuery() {
        return this.morphium.createQueryFor(this.type);
    }

    public Object getValue(Enum field, T obj) throws IllegalAccessException {
        return this.getValue(field.name(), obj);
    }

    public Object getValue(String field, T obj) throws IllegalAccessException {
        return this.ah.getField(this.type, field).get(obj);
    }

    public void setValue(Enum field, Object value, T obj) throws IllegalAccessException {
        this.setValue(field.name(), value, obj);
    }

    public void setValue(String field, Object value, T obj) throws IllegalAccessException {
        this.ah.getField(this.type, field).set(obj, value);
    }

    public boolean existsField(String field) {
        return this.ah.getField(this.type, field) != null;
    }
}

