/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.bulk;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BulkUpdateRequestBuilder;
import com.mongodb.BulkWriteRequestBuilder;
import com.mongodb.DBObject;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumStorageListener;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.query.Query;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class BulkRequestWrapper {
    private Object builder;
    private Morphium morphium;
    private Query query;
    private boolean upsert = false;
    private MorphiumStorageListener.UpdateTypes updateType;

    public BulkRequestWrapper(BulkWriteRequestBuilder b, Morphium m, Query q) {
        this.builder = b;
        this.morphium = m;
        this.query = q;
    }

    public BulkRequestWrapper upsert() {
        if (this.upsert) {
            return this;
        }
        this.builder = ((BulkWriteRequestBuilder)this.builder).upsert();
        this.upsert = true;
        return this;
    }

    public void removeOne() {
        this.updateType = null;
        if (this.upsert) {
            throw new IllegalArgumentException("remove with upsert not supported");
        }
        ((BulkWriteRequestBuilder)this.builder).removeOne();
    }

    public void replaceOne(Object obj) {
        this.updateType = MorphiumStorageListener.UpdateTypes.SET;
        if (this.upsert) {
            ((BulkUpdateRequestBuilder)this.builder).replaceOne(this.morphium.getMapper().marshall(obj));
        } else {
            ((BulkWriteRequestBuilder)this.builder).replaceOne(this.morphium.getMapper().marshall(obj));
        }
    }

    public void remove() {
        this.updateType = null;
        if (this.upsert) {
            throw new IllegalArgumentException("remove with upsert not supported");
        }
        ((BulkWriteRequestBuilder)this.builder).remove();
    }

    private void writeOp(String operation, String field, Object value) {
        if (this.morphium.getARHelper().isAnnotationPresentInHierarchy(value.getClass(), Entity.class) || this.morphium.getARHelper().isAnnotationPresentInHierarchy(value.getClass(), Embedded.class)) {
            if (this.upsert) {
                ((BulkUpdateRequestBuilder)this.builder).update((DBObject)new BasicDBObject(operation, (Object)new BasicDBObject(field, (Object)this.morphium.getMapper().marshall(value))));
            } else {
                ((BulkWriteRequestBuilder)this.builder).update((DBObject)new BasicDBObject(operation, (Object)new BasicDBObject(field, (Object)this.morphium.getMapper().marshall(value))));
            }
        } else if (Map.class.isAssignableFrom(value.getClass())) {
            BasicDBObject map = new BasicDBObject();
            Map valueMap = (Map)value;
            for (Object o : valueMap.keySet()) {
                map.put((Object)((String)o), (Object)this.morphium.getMapper().marshall(valueMap.get(o)));
            }
            if (this.upsert) {
                ((BulkUpdateRequestBuilder)this.builder).update((DBObject)new BasicDBObject(operation, (Object)new BasicDBObject(field, (Object)map)));
            } else {
                ((BulkWriteRequestBuilder)this.builder).update((DBObject)new BasicDBObject(operation, (Object)new BasicDBObject(field, (Object)map)));
            }
        } else if (List.class.isAssignableFrom(value.getClass())) {
            BasicDBList lst = new BasicDBList();
            List valList = (List)value;
            for (Object o : valList) {
                lst.add((Object)this.morphium.getMapper().marshall(o));
            }
            if (this.upsert) {
                ((BulkUpdateRequestBuilder)this.builder).update((DBObject)new BasicDBObject(operation, (Object)new BasicDBObject(field, (Object)lst)));
            } else {
                ((BulkWriteRequestBuilder)this.builder).update((DBObject)new BasicDBObject(operation, (Object)new BasicDBObject(field, (Object)lst)));
            }
        } else if (this.upsert) {
            ((BulkUpdateRequestBuilder)this.builder).update((DBObject)new BasicDBObject(operation, (Object)new BasicDBObject(field, value)));
        } else {
            ((BulkWriteRequestBuilder)this.builder).update((DBObject)new BasicDBObject(operation, (Object)new BasicDBObject(field, value)));
        }
    }

    private void writeOpOne(String operation, String field, Object value) {
        if (this.morphium.getARHelper().isAnnotationPresentInHierarchy(value.getClass(), Entity.class) || this.morphium.getARHelper().isAnnotationPresentInHierarchy(value.getClass(), Embedded.class)) {
            if (this.upsert) {
                ((BulkUpdateRequestBuilder)this.builder).updateOne((DBObject)new BasicDBObject(operation, (Object)new BasicDBObject(field, (Object)this.morphium.getMapper().marshall(value))));
            } else {
                ((BulkWriteRequestBuilder)this.builder).updateOne((DBObject)new BasicDBObject(operation, (Object)new BasicDBObject(field, (Object)this.morphium.getMapper().marshall(value))));
            }
        } else if (Map.class.isAssignableFrom(value.getClass())) {
            BasicDBObject map = new BasicDBObject();
            Map valueMap = (Map)value;
            for (Object o : valueMap.keySet()) {
                map.put((Object)((String)o), (Object)this.morphium.getMapper().marshall(valueMap.get(o)));
            }
            if (this.upsert) {
                ((BulkUpdateRequestBuilder)this.builder).updateOne((DBObject)new BasicDBObject(operation, (Object)new BasicDBObject(field, (Object)map)));
            } else {
                ((BulkWriteRequestBuilder)this.builder).updateOne((DBObject)new BasicDBObject(operation, (Object)new BasicDBObject(field, (Object)map)));
            }
        } else if (List.class.isAssignableFrom(value.getClass())) {
            BasicDBList lst = new BasicDBList();
            List valList = (List)value;
            for (Object o : valList) {
                lst.add((Object)this.morphium.getMapper().marshall(o));
            }
            if (this.upsert) {
                ((BulkUpdateRequestBuilder)this.builder).updateOne((DBObject)new BasicDBObject(operation, (Object)new BasicDBObject(field, (Object)lst)));
            } else {
                ((BulkWriteRequestBuilder)this.builder).updateOne((DBObject)new BasicDBObject(operation, (Object)new BasicDBObject(field, (Object)lst)));
            }
        } else if (this.upsert) {
            ((BulkUpdateRequestBuilder)this.builder).updateOne((DBObject)new BasicDBObject(operation, (Object)new BasicDBObject(field, value)));
        } else {
            ((BulkWriteRequestBuilder)this.builder).updateOne((DBObject)new BasicDBObject(operation, (Object)new BasicDBObject(field, value)));
        }
    }

    public void set(String field, Object val, boolean multiple) {
        this.updateType = MorphiumStorageListener.UpdateTypes.SET;
        if (multiple) {
            this.writeOp("$set", field, val);
        } else {
            this.writeOpOne("$set", field, val);
        }
    }

    public void unset(String field, boolean multiple) {
        this.updateType = MorphiumStorageListener.UpdateTypes.UNSET;
        if (multiple) {
            this.writeOp("$unset", field, 1);
        } else {
            this.writeOpOne("$unset", field, 1);
        }
    }

    public void inc(String field, boolean multiple) {
        this.inc(field, 1.0, multiple);
    }

    public void inc(String field, Number amount, boolean multiple) {
        this.updateType = MorphiumStorageListener.UpdateTypes.INC;
        if (multiple) {
            this.writeOp("$inc", field, amount);
        } else {
            this.writeOpOne("$inc", field, amount);
        }
    }

    public void inc(String field, double amount, boolean multiple) {
        this.updateType = MorphiumStorageListener.UpdateTypes.INC;
        if (multiple) {
            this.writeOp("$inc", field, amount);
        } else {
            this.writeOpOne("$inc", field, amount);
        }
    }

    public void mul(String field, double val, boolean multiple) {
        this.updateType = MorphiumStorageListener.UpdateTypes.MUL;
        if (multiple) {
            this.writeOp("$mul", field, val);
        } else {
            this.writeOpOne("$mul", field, val);
        }
    }

    public void min(String field, double val, boolean multiple) {
        this.updateType = MorphiumStorageListener.UpdateTypes.MIN;
        if (multiple) {
            this.writeOp("$min", field, val);
        } else {
            this.writeOpOne("$min", field, val);
        }
    }

    public void max(String field, double val, boolean multiple) {
        this.updateType = MorphiumStorageListener.UpdateTypes.MAX;
        if (multiple) {
            this.writeOp("$max", field, val);
        } else {
            this.writeOpOne("$max", field, val);
        }
    }

    public void rename(String fieldOld, String fieldNew, boolean multiple) {
        this.updateType = MorphiumStorageListener.UpdateTypes.RENAME;
        if (multiple) {
            this.writeOp("$rename", fieldOld, fieldNew);
        } else {
            this.writeOpOne("$rename", fieldOld, fieldNew);
        }
    }

    public void dec(String field, boolean multiple) {
        this.dec(field, -1.0, multiple);
    }

    public void dec(String field, double amount, boolean multiple) {
        this.updateType = MorphiumStorageListener.UpdateTypes.DEC;
        if (multiple) {
            this.writeOp("$inc", field, -amount);
        } else {
            this.writeOpOne("$inc", field, -amount);
        }
    }

    public void pull(String field, boolean multiple, Object ... value) {
        this.updateType = MorphiumStorageListener.UpdateTypes.PULL;
        if (value.length == 1) {
            if (multiple) {
                this.writeOp("$pull", field, value[0]);
            } else {
                this.writeOpOne("$pull", field, value[0]);
            }
        } else if (multiple) {
            this.writeOp("$pullAll", field, Arrays.asList(value));
        } else {
            this.writeOpOne("$pullAll", field, Arrays.asList(value));
        }
    }

    public void push(String field, boolean multiple, Object ... value) {
        this.updateType = MorphiumStorageListener.UpdateTypes.PUSH;
        if (value.length == 1) {
            if (multiple) {
                this.writeOp("push", field, value[0]);
            } else {
                this.writeOpOne("$push", field, value[0]);
            }
        } else if (multiple) {
            this.writeOp("$pushAll", field, Arrays.asList(value));
        } else {
            this.writeOpOne("$pushAll", field, Arrays.asList(value));
        }
    }

    public void pop(String field, boolean first, boolean multiple) {
        this.updateType = MorphiumStorageListener.UpdateTypes.POP;
        if (multiple) {
            this.writeOp("$pop", field, first ? -1 : 1);
        } else {
            this.writeOpOne("$pop", field, first ? -1 : 1);
        }
    }

    public void preExec() {
        if (this.updateType == null) {
            this.morphium.firePreRemoveEvent(this.query);
        } else {
            this.morphium.firePreUpdateEvent(this.query.getType(), this.updateType);
        }
    }

    public MorphiumStorageListener.UpdateTypes getUpdateType() {
        return this.updateType;
    }

    public Query getQuery() {
        return this.query;
    }

    public void postExec() {
        if (this.updateType == null) {
            this.morphium.firePostRemoveEvent(this.query);
        } else {
            this.morphium.firePostUpdateEvent(this.query.getType(), this.updateType);
        }
        this.morphium.getCache().clearCacheIfNecessary(this.query.getType());
    }
}

