/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium;

import de.caluga.morphium.JavaUtilLoggingDelegate;
import de.caluga.morphium.Log4JLoggerDelegate;
import de.caluga.morphium.LoggerDelegate;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class Logger {
    private int level = 5;
    private String prfx;
    private DateFormat df = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss.SSS");
    private String file;
    private PrintWriter out = new PrintWriter(new OutputStreamWriter(System.out));
    private boolean synced = false;
    private boolean close = false;
    private LoggerDelegate delegate = new DefaultLoggerDelegate();

    public Logger(String name) {
        this.prfx = name;
        String v = this.getSetting("log.level");
        if (this.getSetting("log.level." + name) != null) {
            v = this.getSetting("log.level." + name);
        }
        if (v != null) {
            this.level = Integer.parseInt(v);
        }
        v = this.getSetting("log.file");
        if (this.getSetting("log.file." + name) != null) {
            v = this.getSetting("log.file." + name);
        }
        if (v != null) {
            this.file = v;
            if (v.startsWith("class:")) {
                try {
                    this.delegate = (LoggerDelegate)Class.forName(v.substring(v.indexOf(":") + 1)).newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.out = new PrintWriter(new OutputStreamWriter(System.out));
                }
            } else {
                switch (v) {
                    case "-": 
                    case "STDOUT": {
                        this.out = new PrintWriter(new OutputStreamWriter(System.out));
                        this.close = false;
                        break;
                    }
                    case "STDERR": {
                        this.out = new PrintWriter(new OutputStreamWriter(System.err));
                        this.close = false;
                        break;
                    }
                    default: {
                        try {
                            this.out = new PrintWriter(new BufferedWriter(new FileWriter(v, true)));
                            this.close = true;
                            break;
                        }
                        catch (IOException e) {
                            this.error(null, e);
                        }
                    }
                }
            }
        }
        v = this.getSetting("log.synced");
        if (this.getSetting("log.synced." + name) != null) {
            v = this.getSetting("log.synced." + name);
        }
        if (v != null) {
            this.synced = v.equals("true");
        }
        v = this.getSetting("log.delegate");
        if (this.getSetting("log.delegate." + name) != null) {
            v = this.getSetting("log.delegate." + name);
        }
        if (v != null) {
            if (v.equals("log4j")) {
                this.delegate = new Log4JLoggerDelegate();
            } else if (v.equals("jul")) {
                this.delegate = new JavaUtilLoggingDelegate();
            } else {
                try {
                    this.delegate = (LoggerDelegate)Class.forName(v).newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.out.flush();
        if (this.close) {
            this.out.close();
        }
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String v) {
        this.file = v;
        this.out.flush();
        this.out.close();
        if (this.file == null) {
            this.out = new PrintWriter(new OutputStreamWriter(System.out));
        } else {
            try {
                this.out = new PrintWriter(new BufferedWriter(new FileWriter(v, true)));
            }
            catch (IOException e) {
                this.error(null, e);
            }
        }
    }

    private String getSetting(String s) {
        String v = null;
        s = "morphium." + s;
        if (System.getenv(s.replaceAll("\\.", "_")) != null) {
            v = System.getenv(s.replaceAll("\\.", "_"));
        }
        if (System.getProperty(s) != null) {
            v = System.getProperty(s);
        }
        if (v == null) {
            int lng = 0;
            for (Map.Entry<Object, Object> p : System.getProperties().entrySet()) {
                if (!s.startsWith(p.getKey().toString()) || p.getKey().toString().length() <= lng) continue;
                lng = p.getKey().toString().length();
                v = p.getValue().toString();
            }
        }
        return v;
    }

    public void setLevel(int lv) {
        this.level = lv;
    }

    public void setLevel(Object o) {
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isEnabledFor(Object o) {
        return true;
    }

    public boolean isDebugEnabled() {
        return this.level >= 5;
    }

    public boolean isInfoEnabled() {
        return this.level >= 4;
    }

    public boolean isWarnEnabled() {
        return this.level >= 3;
    }

    public boolean isErrorEnabled() {
        return this.level >= 2;
    }

    public boolean isFatalEnabled() {
        return this.level >= 1;
    }

    public Logger(Class cls) {
        this(cls.getName());
    }

    public void info(Object msg) {
        this.info(msg.toString(), null);
    }

    public void info(String msg) {
        this.info(msg, null);
    }

    public void info(Throwable t) {
        this.info(null, t);
    }

    public void info(String msg, Throwable t) {
        this.doLog(4, msg, t);
    }

    public void debug(Object msg) {
        this.debug(msg.toString());
    }

    public void debug(String msg) {
        this.debug(msg, null);
    }

    public void debug(Throwable t) {
        this.debug(null, t);
    }

    public void debug(String msg, Throwable t) {
        this.doLog(5, msg, t);
    }

    public void warn(Object msg) {
        this.warn(msg.toString(), null);
    }

    public void warn(String msg) {
        this.warn(msg, null);
    }

    public void warn(Throwable t) {
        this.warn(null, t);
    }

    public void warn(String msg, Throwable t) {
        this.doLog(3, msg, t);
    }

    public void error(Object msg) {
        this.error(msg.toString(), null);
    }

    public void error(String msg) {
        this.error(msg, null);
    }

    public void error(Throwable t) {
        this.error(null, t);
    }

    public void error(String msg, Throwable t) {
        this.doLog(2, msg, t);
    }

    public void fatal(Object msg) {
        this.fatal(msg.toString(), null);
    }

    public void fatal(String msg) {
        this.fatal(msg, null);
    }

    public void fatal(Throwable t) {
        this.fatal(null, t);
    }

    public void fatal(String msg, Throwable t) {
        this.doLog(1, msg, t);
    }

    public boolean isSynced() {
        return this.synced;
    }

    public void setSynced(boolean synced) {
        this.synced = synced;
    }

    private void doLog(int lv, String msg, Throwable t) {
        if (this.level >= lv) {
            this.delegate.log(this.prfx, lv, msg, t);
        }
    }

    private class DefaultLoggerDelegate
    implements LoggerDelegate {
        private DefaultLoggerDelegate() {
        }

        @Override
        public void log(String name, int lv, String msg, Throwable t) {
            int idx;
            Logger.this.out.print(Logger.this.df.format(new Date()));
            Logger.this.out.print(":");
            switch (lv) {
                case 5: {
                    Logger.this.out.print(" DEBUG ");
                    break;
                }
                case 4: {
                    Logger.this.out.print(" INFO ");
                    break;
                }
                case 3: {
                    Logger.this.out.print(" WARN ");
                    break;
                }
                case 2: {
                    Logger.this.out.print(" ERROR ");
                    break;
                }
                case 1: {
                    Logger.this.out.print(" FATAL ");
                    break;
                }
                default: {
                    return;
                }
            }
            Logger.this.out.print("[");
            StackTraceElement[] st = new Exception().getStackTrace();
            for (idx = 0; (st[idx].getClassName().equals(this.getClass().getName()) || st[idx].getClassName().equals(Logger.class.getName())) && idx <= st.length; ++idx) {
            }
            Logger.this.out.print(st[idx].getClassName());
            Logger.this.out.print(".");
            Logger.this.out.print(st[idx].getMethodName());
            Logger.this.out.print("():");
            Logger.this.out.print(st[idx].getLineNumber());
            Logger.this.out.print(" - ");
            if (msg != null) {
                Logger.this.out.print(msg);
            }
            Logger.this.out.println();
            if (t != null) {
                t.printStackTrace();
            }
            if (Logger.this.synced) {
                Logger.this.out.flush();
            }
        }
    }
}

