/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.replicaset;

import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumConfig;
import de.caluga.morphium.replicaset.ConfNode;
import de.caluga.morphium.replicaset.ReplicaSetConf;
import de.caluga.morphium.replicaset.ReplicaSetNode;
import de.caluga.morphium.replicaset.ReplicaSetStatus;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class RSMonitor {
    private static Logger logger = Logger.getLogger(RSMonitor.class);
    private Morphium morphium;
    private final ScheduledThreadPoolExecutor executorService;
    private ReplicaSetStatus currentStatus;
    private int nullcounter = 0;

    public RSMonitor(Morphium morphium) {
        this.morphium = morphium;
        this.executorService = new ScheduledThreadPoolExecutor(1);
    }

    public void start() {
        this.execute();
        this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                RSMonitor.this.execute();
            }
        }, (long)this.morphium.getConfig().getReplicaSetMonitoringTimeout(), TimeUnit.MILLISECONDS);
    }

    public void terminate() {
        this.executorService.shutdownNow();
    }

    public void execute() {
        try {
            this.currentStatus = this.getReplicaSetStatus(true);
            this.nullcounter = this.currentStatus == null ? ++this.nullcounter : 0;
            if (this.nullcounter > 10) {
                logger.error((Object)"Getting ReplicasetStatus failed 10 times... will gracefully exit thread");
                this.executorService.shutdownNow();
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ReplicaSetStatus getReplicaSetStatus(boolean full) {
        if (this.morphium.isReplicaSet()) {
            try {
                DB adminDB = this.morphium.getMongo().getDB("admin");
                MorphiumConfig config = this.morphium.getConfig();
                if (config.getMongoAdminUser() != null && !adminDB.authenticate(config.getMongoAdminUser(), config.getMongoAdminPwd().toCharArray())) {
                    logger.error((Object)"Authentication as admin failed!");
                    return null;
                }
                CommandResult res = adminDB.command("replSetGetStatus");
                ReplicaSetStatus status = this.morphium.getMapper().unmarshall(ReplicaSetStatus.class, (DBObject)res);
                if (full) {
                    DBCursor rpl = this.morphium.getMongo().getDB("local").getCollection("system.replset").find();
                    DBObject stat = rpl.next();
                    ReplicaSetConf cfg = this.morphium.getMapper().unmarshall(ReplicaSetConf.class, stat);
                    List mem = cfg.getMemberList();
                    ArrayList<ConfNode> cmembers = new ArrayList<ConfNode>();
                    for (Object o : mem) {
                        ConfNode cn = (ConfNode)o;
                        cmembers.add(cn);
                    }
                    cfg.setMembers(cmembers);
                    status.setConfig(cfg);
                }
                List<ReplicaSetNode> lst = status.getMembers();
                ArrayList<ReplicaSetNode> members = new ArrayList<ReplicaSetNode>();
                Iterator<ReplicaSetNode> i$ = lst.iterator();
                while (i$.hasNext()) {
                    ReplicaSetNode l;
                    ReplicaSetNode n = l = i$.next();
                    members.add(n);
                }
                status.setMembers(members);
                return status;
            }
            catch (Exception e) {
                logger.warn((Object)("Could not get Replicaset status: " + e.getMessage()), (Throwable)e);
            }
        }
        return null;
    }

    public ReplicaSetStatus getCurrentStatus() {
        return this.currentStatus;
    }
}

