/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.writer;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.MorphiumStorageListener;
import de.caluga.morphium.PartiallyUpdateable;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.WriteAccessType;
import de.caluga.morphium.annotations.CreationTime;
import de.caluga.morphium.annotations.Embedded;
import de.caluga.morphium.annotations.Entity;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.LastChange;
import de.caluga.morphium.annotations.PartialUpdate;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.writer.MorphiumWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.bson.types.ObjectId;

public class MorphiumWriterImpl
implements MorphiumWriter {
    private static Logger logger = Logger.getLogger(MorphiumWriterImpl.class);
    private Morphium morphium;
    private AnnotationAndReflectionHelper annotationHelper = new AnnotationAndReflectionHelper();
    private ThreadPoolExecutor executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        if (m != null) {
            this.annotationHelper = this.morphium.getARHelper();
            this.executor.setCorePoolSize(m.getConfig().getMaxConnections() / 2);
            this.executor.setMaximumPoolSize((int)((double)(m.getConfig().getMaxConnections() * m.getConfig().getBlockingThreadsMultiplier()) * 0.9));
        } else {
            this.annotationHelper = new AnnotationAndReflectionHelper();
        }
    }

    @Override
    public <T> void store(final T obj, final AsyncOperationCallback<T> callback) {
        if (obj instanceof List) {
            this.store((List)obj, callback);
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    Cache ch;
                    WriteConcern wc;
                    Field f;
                    List<String> lst;
                    Object o = obj;
                    Class<?> type = MorphiumWriterImpl.this.annotationHelper.getRealClass(o.getClass());
                    if (!MorphiumWriterImpl.this.annotationHelper.isAnnotationPresentInHierarchy(type, Entity.class)) {
                        throw new RuntimeException("Not an entity: " + type.getSimpleName() + " Storing not possible!");
                    }
                    MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                    ObjectId id = MorphiumWriterImpl.this.annotationHelper.getId(o);
                    if (MorphiumWriterImpl.this.annotationHelper.isAnnotationPresentInHierarchy(type, PartialUpdate.class) && o instanceof PartiallyUpdateable) {
                        MorphiumWriterImpl.this.updateUsingFields(o, callback, ((PartiallyUpdateable)o).getAlteredFields().toArray(new String[((PartiallyUpdateable)o).getAlteredFields().size()]));
                        ((PartiallyUpdateable)o).clearAlteredFields();
                        return;
                    }
                    o = MorphiumWriterImpl.this.annotationHelper.getRealObject(o);
                    if (o == null) {
                        logger.warn((Object)"Illegal Reference? - cannot store Lazy-Loaded / Partial Update Proxy without delegate!");
                        return;
                    }
                    boolean isNew = id == null;
                    MorphiumWriterImpl.this.morphium.firePreStoreEvent(o, isNew);
                    DBObject marshall = MorphiumWriterImpl.this.morphium.getMapper().marshall(o);
                    if (isNew && MorphiumWriterImpl.this.annotationHelper.isAnnotationPresentInHierarchy(type, CreationTime.class)) {
                        lst = MorphiumWriterImpl.this.annotationHelper.getFields(type, CreationTime.class);
                        if (lst == null || lst.size() == 0) {
                            logger.error((Object)"Unable to store creation time as @CreationTime is missing");
                        } else {
                            long now = System.currentTimeMillis();
                            for (String ctf : lst) {
                                f = MorphiumWriterImpl.this.annotationHelper.getField(type, ctf);
                                if (f != null) {
                                    try {
                                        f.set(o, now);
                                    }
                                    catch (IllegalAccessException e) {
                                        logger.error((Object)"Could not set creation time", (Throwable)e);
                                    }
                                }
                                marshall.put(ctf, (Object)now);
                            }
                        }
                    }
                    if (MorphiumWriterImpl.this.annotationHelper.isAnnotationPresentInHierarchy(type, LastChange.class)) {
                        lst = MorphiumWriterImpl.this.annotationHelper.getFields(type, LastChange.class);
                        if (lst != null && lst.size() > 0) {
                            for (String ctf : lst) {
                                long now = System.currentTimeMillis();
                                f = MorphiumWriterImpl.this.annotationHelper.getField(type, ctf);
                                if (f != null) {
                                    try {
                                        f.set(o, now);
                                    }
                                    catch (IllegalAccessException e) {
                                        logger.error((Object)"Could not set modification time", (Throwable)e);
                                    }
                                }
                                marshall.put(ctf, (Object)now);
                            }
                        } else {
                            logger.warn((Object)"Could not store last change - @LastChange missing!");
                        }
                    }
                    String coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(type);
                    if (!MorphiumWriterImpl.this.morphium.getDatabase().collectionExists(coll)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Collection does not exist - ensuring indices");
                        }
                        MorphiumWriterImpl.this.morphium.ensureIndicesFor(type);
                    }
                    if ((wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(type)) != null) {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).save(marshall, wc);
                    } else {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).save(marshall);
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(o.getClass(), marshall, dur, true, WriteAccessType.SINGLE_INSERT);
                    if (logger.isDebugEnabled()) {
                        String n = "";
                        if (isNew) {
                            n = "NEW ";
                        }
                        logger.debug((Object)(n + "stored " + type.getSimpleName() + " after " + dur + " ms length:" + marshall.toString().length()));
                    }
                    if (isNew) {
                        List<String> flds = MorphiumWriterImpl.this.annotationHelper.getFields(o.getClass(), Id.class);
                        if (flds == null) {
                            throw new RuntimeException("Object does not have an ID field!");
                        }
                        try {
                            MorphiumWriterImpl.this.annotationHelper.getField(o.getClass(), flds.get(0)).set(o, marshall.get("_id"));
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if ((ch = MorphiumWriterImpl.this.annotationHelper.getAnnotationFromHierarchy(o.getClass(), Cache.class)) != null && ch.clearOnWrite()) {
                        MorphiumWriterImpl.this.morphium.clearCachefor(o.getClass());
                    }
                    MorphiumWriterImpl.this.morphium.firePostStoreEvent(o, isNew);
                    if (callback != null) {
                        callback.onOperationSucceeded(AsyncOperationType.WRITE, null, System.currentTimeMillis() - start, null, obj, new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (callback == null) {
                        throw new RuntimeException(e);
                    }
                    callback.onOperationError(AsyncOperationType.WRITE, null, System.currentTimeMillis() - start, e.getMessage(), e, obj, new Object[0]);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void store(final List<T> lst, final AsyncOperationCallback<T> callback) {
        if (!lst.isEmpty()) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    HashMap sorted = new HashMap();
                    HashMap isNew = new HashMap();
                    for (Object o : lst) {
                        Class<?> type = MorphiumWriterImpl.this.annotationHelper.getRealClass(o.getClass());
                        if (!MorphiumWriterImpl.this.annotationHelper.isAnnotationPresentInHierarchy(type, Entity.class)) {
                            logger.error((Object)"Not an entity! Storing not possible! Even not in list!");
                            continue;
                        }
                        MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                        if (MorphiumWriterImpl.this.annotationHelper.isAnnotationPresentInHierarchy(type, PartialUpdate.class) && o instanceof PartiallyUpdateable) {
                            MorphiumWriterImpl.this.morphium.updateUsingFields(o, ((PartiallyUpdateable)o).getAlteredFields().toArray(new String[((PartiallyUpdateable)o).getAlteredFields().size()]));
                            ((PartiallyUpdateable)o).clearAlteredFields();
                            continue;
                        }
                        o = MorphiumWriterImpl.this.annotationHelper.getRealObject(o);
                        if (o == null) {
                            logger.warn((Object)"Illegal Reference? - cannot store Lazy-Loaded / Partial Update Proxy without delegate!");
                            return;
                        }
                        if (sorted.get(o.getClass()) == null) {
                            sorted.put(o.getClass(), new ArrayList());
                        }
                        ((List)sorted.get(o.getClass())).add(o);
                        if (MorphiumWriterImpl.this.morphium.getId(o) == null) {
                            isNew.put(o, true);
                        } else {
                            isNew.put(o, false);
                        }
                        MorphiumWriterImpl.this.morphium.firePreStoreEvent(o, (Boolean)isNew.get(o));
                    }
                    long allStart = System.currentTimeMillis();
                    try {
                        for (Map.Entry es : sorted.entrySet()) {
                            Class c = (Class)es.getKey();
                            ArrayList<DBObject> dbLst = new ArrayList<DBObject>();
                            WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(c);
                            String coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(c);
                            DBCollection collection = MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll);
                            if (!MorphiumWriterImpl.this.morphium.getDatabase().collectionExists(coll)) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Collection does not exist - ensuring indices");
                                }
                                MorphiumWriterImpl.this.morphium.ensureIndicesFor(c);
                            }
                            for (Object record : (List)es.getValue()) {
                                DBObject marshall = MorphiumWriterImpl.this.morphium.getMapper().marshall(record);
                                if (((Boolean)isNew.get(record)).booleanValue()) {
                                    dbLst.add(marshall);
                                    continue;
                                }
                                long start = System.currentTimeMillis();
                                if (wc == null) {
                                    collection.save(marshall);
                                } else {
                                    collection.save(marshall, wc);
                                }
                                long dur = System.currentTimeMillis() - start;
                                MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(c, marshall, dur, false, WriteAccessType.SINGLE_INSERT);
                                MorphiumWriterImpl.this.morphium.firePostStoreEvent(record, (Boolean)isNew.get(record));
                            }
                            long start = System.currentTimeMillis();
                            if (wc == null) {
                                collection.insert(dbLst);
                            } else {
                                collection.insert(dbLst, wc);
                            }
                            long dur = System.currentTimeMillis() - start;
                            MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(c, dbLst, dur, true, WriteAccessType.BULK_INSERT);
                            for (Object record : (List)es.getValue()) {
                                if (!((Boolean)isNew.get(record)).booleanValue()) continue;
                                MorphiumWriterImpl.this.morphium.firePostStoreEvent(record, (Boolean)isNew.get(record));
                            }
                        }
                        if (callback != null) {
                            callback.onOperationSucceeded(AsyncOperationType.WRITE, null, System.currentTimeMillis() - allStart, null, null, lst);
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        if (callback == null) {
                            throw new RuntimeException(e);
                        }
                        callback.onOperationError(AsyncOperationType.WRITE, null, System.currentTimeMillis() - allStart, e.getMessage(), e, null, lst);
                    }
                }
            };
            this.submitAndBlockIfNecessary(callback, r);
        }
    }

    @Override
    public <T> void set(final T toSet, final String field, final Object v, final boolean insertIfNotExist, final boolean multiple, final AsyncOperationCallback<T> callback) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Class<?> cls = toSet.getClass();
                Object value = v;
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
                value = MorphiumWriterImpl.this.marshallIfNecessary(value);
                String coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                BasicDBObject query = new BasicDBObject();
                query.put("_id", (Object)MorphiumWriterImpl.this.morphium.getId(toSet));
                Field f = MorphiumWriterImpl.this.annotationHelper.getField(cls, field);
                if (f == null) {
                    throw new RuntimeException("Unknown field: " + field);
                }
                String fieldName = MorphiumWriterImpl.this.annotationHelper.getFieldName(cls, field);
                BasicDBObject update = new BasicDBObject("$set", (Object)new BasicDBObject(fieldName, value));
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(toSet.getClass());
                long start = System.currentTimeMillis();
                try {
                    if (wc == null) {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update, insertIfNotExist, multiple);
                    } else {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update, insertIfNotExist, multiple, wc);
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, update, dur, false, WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    try {
                        f.set(toSet, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    if (callback != null) {
                        callback.onOperationSucceeded(AsyncOperationType.SET, null, System.currentTimeMillis() - start, null, toSet, field, v);
                    }
                }
                catch (Exception e) {
                    if (callback == null) {
                        throw new RuntimeException(e);
                    }
                    callback.onOperationError(AsyncOperationType.SET, null, System.currentTimeMillis() - start, e.getMessage(), e, toSet, field, v);
                }
                MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    private <T> void submitAndBlockIfNecessary(AsyncOperationCallback<T> callback, Runnable r) {
        if (callback == null) {
            r.run();
        } else {
            while ((double)this.writeBufferCount() >= (double)(this.morphium.getConfig().getMaxConnections() * this.morphium.getConfig().getBlockingThreadsMultiplier()) * 0.9 - 1.0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Have to wait for queue to be more empty - active threads now: " + this.writeBufferCount()));
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.executor.submit(r);
        }
    }

    @Override
    public <T> void updateUsingFields(final T ent, final AsyncOperationCallback<T> callback, final String ... fields) {
        if (ent == null) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ObjectId id = MorphiumWriterImpl.this.annotationHelper.getId(ent);
                if (id == null) {
                    logger.warn((Object)"trying to partially update new object - storing it in full!");
                    MorphiumWriterImpl.this.store(ent, callback);
                    return;
                }
                MorphiumWriterImpl.this.morphium.firePreStoreEvent(ent, false);
                MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                BasicDBObject find = new BasicDBObject();
                find.put("_id", (Object)id);
                BasicDBObject update = new BasicDBObject();
                for (String f : fields) {
                    try {
                        Object value = MorphiumWriterImpl.this.annotationHelper.getValue(ent, f);
                        if (MorphiumWriterImpl.this.annotationHelper.isAnnotationPresentInHierarchy(value.getClass(), Entity.class)) {
                            value = MorphiumWriterImpl.this.morphium.getMapper().marshall(value);
                        }
                        update.put(f, value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                Class<?> type = MorphiumWriterImpl.this.annotationHelper.getRealClass(ent.getClass());
                LastChange t = MorphiumWriterImpl.this.annotationHelper.getAnnotationFromHierarchy(type, LastChange.class);
                if (t != null) {
                    List<String> lst = MorphiumWriterImpl.this.annotationHelper.getFields(ent.getClass(), LastChange.class);
                    long now = System.currentTimeMillis();
                    for (String ctf : lst) {
                        Field f = MorphiumWriterImpl.this.annotationHelper.getField(type, ctf);
                        if (f != null) {
                            try {
                                f.set(ent, now);
                            }
                            catch (IllegalAccessException e) {
                                logger.error((Object)"Could not set modification time", (Throwable)e);
                            }
                        }
                        update.put(ctf, (Object)now);
                    }
                }
                update = new BasicDBObject("$set", (Object)update);
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(type);
                long start = System.currentTimeMillis();
                try {
                    if (wc != null) {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(ent.getClass())).update((DBObject)find, (DBObject)update, false, false, wc);
                    } else {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(ent.getClass())).update((DBObject)find, (DBObject)update, false, false);
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(ent.getClass(), update, dur, false, WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(MorphiumWriterImpl.this.annotationHelper.getRealClass(ent.getClass()));
                    MorphiumWriterImpl.this.morphium.firePostStoreEvent(ent, false);
                    if (callback != null) {
                        callback.onOperationSucceeded(AsyncOperationType.UPDATE, null, System.currentTimeMillis() - start, null, ent, fields);
                    }
                }
                catch (Exception e) {
                    if (callback == null) {
                        throw new RuntimeException(e);
                    }
                    callback.onOperationError(AsyncOperationType.UPDATE, null, System.currentTimeMillis() - start, e.getMessage(), e, ent, fields);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void delete(final List<T> lst, final AsyncOperationCallback<T> callback) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                HashMap sortedMap = new HashMap();
                for (Object o : lst) {
                    if (sortedMap.get(o.getClass()) == null) {
                        ArrayList queries = new ArrayList();
                        sortedMap.put(o.getClass(), queries);
                    }
                    Query<?> q = MorphiumWriterImpl.this.morphium.createQueryFor(o.getClass());
                    q.f(MorphiumWriterImpl.this.annotationHelper.getIdFieldName(o)).eq(MorphiumWriterImpl.this.annotationHelper.getId(o));
                    ((List)sortedMap.get(o.getClass())).add(q);
                }
                long start = System.currentTimeMillis();
                try {
                    for (Class cls : sortedMap.keySet()) {
                        Query orQuery = MorphiumWriterImpl.this.morphium.createQueryFor(cls);
                        orQuery = orQuery.or((List)sortedMap.get(cls));
                        MorphiumWriterImpl.this.delete(orQuery, (AsyncOperationCallback)null);
                    }
                    if (callback != null) {
                        callback.onOperationSucceeded(AsyncOperationType.REMOVE, null, System.currentTimeMillis() - start, null, null, lst);
                    }
                }
                catch (Exception e) {
                    if (callback == null) {
                        throw new RuntimeException(e);
                    }
                    callback.onOperationError(AsyncOperationType.REMOVE, null, System.currentTimeMillis() - start, e.getMessage(), e, null, lst);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void delete(final Query<T> q, final AsyncOperationCallback<T> callback) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                MorphiumWriterImpl.this.morphium.firePreRemoveEvent(q);
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(q.getType());
                long start = System.currentTimeMillis();
                try {
                    if (wc == null) {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(q.getType())).remove(q.toQueryObject());
                    } else {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(q.getType())).remove(q.toQueryObject(), wc);
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(q.getType(), q.toQueryObject(), dur, false, WriteAccessType.BULK_DELETE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(q.getType());
                    MorphiumWriterImpl.this.morphium.firePostRemoveEvent(q);
                    if (callback != null) {
                        callback.onOperationSucceeded(AsyncOperationType.REMOVE, q, System.currentTimeMillis() - start, null, null, new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (callback == null) {
                        throw new RuntimeException(e);
                    }
                    callback.onOperationError(AsyncOperationType.REMOVE, q, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void delete(final T o, final AsyncOperationCallback<T> callback) {
        if (o instanceof List) {
            this.delete((T)((List)o), callback);
            return;
        }
        if (o instanceof Query) {
            this.delete((T)((Query)o), callback);
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ObjectId id = MorphiumWriterImpl.this.annotationHelper.getId(o);
                MorphiumWriterImpl.this.morphium.firePreRemoveEvent(o);
                BasicDBObject db = new BasicDBObject();
                db.append("_id", (Object)id);
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(o.getClass());
                long start = System.currentTimeMillis();
                try {
                    if (wc == null) {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(o.getClass())).remove((DBObject)db);
                    } else {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(o.getClass())).remove((DBObject)db, wc);
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(o.getClass(), o, dur, false, WriteAccessType.SINGLE_DELETE);
                    MorphiumWriterImpl.this.morphium.clearCachefor(o.getClass());
                    MorphiumWriterImpl.this.morphium.inc(StatisticKeys.WRITES);
                    MorphiumWriterImpl.this.morphium.firePostRemoveEvent(o);
                    if (callback != null) {
                        callback.onOperationSucceeded(AsyncOperationType.REMOVE, null, System.currentTimeMillis() - start, null, o, new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (callback == null) {
                        throw new RuntimeException(e);
                    }
                    callback.onOperationError(AsyncOperationType.REMOVE, null, System.currentTimeMillis() - start, e.getMessage(), e, o, new Object[0]);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void inc(final T toInc, final String field, final int amount, final AsyncOperationCallback<T> callback) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Class<?> cls = toInc.getClass();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                String coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                BasicDBObject query = new BasicDBObject();
                query.put("_id", (Object)MorphiumWriterImpl.this.morphium.getId(toInc));
                Field f = MorphiumWriterImpl.this.annotationHelper.getField(cls, field);
                if (f == null) {
                    throw new RuntimeException("Unknown field: " + field);
                }
                String fieldName = MorphiumWriterImpl.this.annotationHelper.getFieldName(cls, field);
                BasicDBObject update = new BasicDBObject("$inc", (Object)new BasicDBObject(fieldName, (Object)amount));
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(toInc.getClass());
                long start = System.currentTimeMillis();
                try {
                    if (wc == null) {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update);
                    } else {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update, false, false, wc);
                    }
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                        try {
                            f.set(toInc, (Integer)f.get(toInc) + amount);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    } else if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
                        try {
                            f.set(toInc, (Double)f.get(toInc) + (double)amount);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    } else if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                        try {
                            f.set(toInc, Float.valueOf(((Float)f.get(toInc)).floatValue() + (float)amount));
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    } else if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                        try {
                            f.set(toInc, (Long)f.get(toInc) + (long)amount);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        logger.error((Object)("Could not set increased value - unsupported type " + cls.getName()));
                    }
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(toInc.getClass(), toInc, System.currentTimeMillis() - start, false, WriteAccessType.SINGLE_UPDATE);
                    if (callback != null) {
                        callback.onOperationSucceeded(AsyncOperationType.INC, null, System.currentTimeMillis() - start, null, toInc, field, amount);
                    }
                }
                catch (RuntimeException e) {
                    if (callback == null) {
                        throw new RuntimeException(e);
                    }
                    callback.onOperationError(AsyncOperationType.INC, null, System.currentTimeMillis() - start, e.getMessage(), e, toInc, field, amount);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void inc(final Query<T> query, final String field, final int amount, final boolean insertIfNotExist, final boolean multiple, final AsyncOperationCallback<T> callback) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Class cls = query.getType();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                String coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                String fieldName = MorphiumWriterImpl.this.annotationHelper.getFieldName(cls, field);
                BasicDBObject update = new BasicDBObject("$inc", (Object)new BasicDBObject(fieldName, (Object)amount));
                DBObject qobj = query.toQueryObject();
                if (insertIfNotExist) {
                    qobj = MorphiumWriterImpl.this.morphium.simplifyQueryObject(qobj);
                }
                if (insertIfNotExist && !MorphiumWriterImpl.this.morphium.getDatabase().collectionExists(coll)) {
                    MorphiumWriterImpl.this.morphium.ensureIndicesFor(cls);
                }
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls);
                long start = System.currentTimeMillis();
                try {
                    if (wc == null) {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple);
                    } else {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple, wc);
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, update, dur, insertIfNotExist, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.INC);
                    if (callback != null) {
                        callback.onOperationSucceeded(AsyncOperationType.INC, query, System.currentTimeMillis() - start, null, null, field, amount);
                    }
                }
                catch (RuntimeException e) {
                    if (callback == null) {
                        throw new RuntimeException(e);
                    }
                    callback.onOperationError(AsyncOperationType.INC, query, System.currentTimeMillis() - start, e.getMessage(), e, null, field, amount);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void set(final Query<T> query, final Map<String, Object> values, final boolean insertIfNotExist, final boolean multiple, final AsyncOperationCallback<T> callback) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Class cls = query.getType();
                String coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
                BasicDBObject toSet = new BasicDBObject();
                for (Map.Entry ef : values.entrySet()) {
                    String fieldName = MorphiumWriterImpl.this.annotationHelper.getFieldName(cls, (String)ef.getKey());
                    toSet.put(fieldName, MorphiumWriterImpl.this.marshallIfNecessary(ef.getValue()));
                }
                DBObject qobj = query.toQueryObject();
                if (insertIfNotExist) {
                    qobj = MorphiumWriterImpl.this.morphium.simplifyQueryObject(qobj);
                }
                if (insertIfNotExist && !MorphiumWriterImpl.this.morphium.getDatabase().collectionExists(coll)) {
                    MorphiumWriterImpl.this.morphium.ensureIndicesFor(cls);
                }
                BasicDBObject update = new BasicDBObject("$set", (Object)toSet);
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls);
                long start = System.currentTimeMillis();
                try {
                    if (wc == null) {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple);
                    } else {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple, wc);
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, update, dur, insertIfNotExist, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.SET);
                    if (callback != null) {
                        callback.onOperationSucceeded(AsyncOperationType.SET, query, System.currentTimeMillis() - start, null, null, values, insertIfNotExist, multiple);
                    }
                }
                catch (RuntimeException e) {
                    if (callback == null) {
                        throw new RuntimeException(e);
                    }
                    callback.onOperationError(AsyncOperationType.SET, query, System.currentTimeMillis() - start, e.getMessage(), e, null, values, insertIfNotExist, multiple);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void unset(final T toSet, final String field, final AsyncOperationCallback<T> callback) {
        if (toSet == null) {
            throw new RuntimeException("Cannot update null!");
        }
        if (this.annotationHelper.getId(toSet) == null) {
            logger.info((Object)"just storing object as it is new...");
            this.store(toSet, callback);
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Class<?> cls = toSet.getClass();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.UNSET);
                String coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                BasicDBObject query = new BasicDBObject();
                query.put("_id", (Object)MorphiumWriterImpl.this.morphium.getId(toSet));
                Field f = MorphiumWriterImpl.this.annotationHelper.getField(cls, field);
                if (f == null) {
                    throw new RuntimeException("Unknown field: " + field);
                }
                String fieldName = MorphiumWriterImpl.this.annotationHelper.getFieldName(cls, field);
                BasicDBObject update = new BasicDBObject("$unset", (Object)new BasicDBObject(fieldName, (Object)1));
                WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(toSet.getClass());
                if (!MorphiumWriterImpl.this.morphium.getDatabase().collectionExists(coll)) {
                    MorphiumWriterImpl.this.morphium.ensureIndicesFor(cls);
                }
                long start = System.currentTimeMillis();
                try {
                    if (wc == null) {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update);
                    } else {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update((DBObject)query, (DBObject)update, false, false, wc);
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(toSet.getClass(), update, dur, false, WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    try {
                        f.set(toSet, null);
                    }
                    catch (IllegalAccessException e) {
                        // empty catch block
                    }
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), MorphiumStorageListener.UpdateTypes.UNSET);
                    if (callback != null) {
                        callback.onOperationSucceeded(AsyncOperationType.UNSET, null, System.currentTimeMillis() - start, null, toSet, field);
                    }
                }
                catch (RuntimeException e) {
                    if (callback == null) {
                        throw new RuntimeException(e);
                    }
                    callback.onOperationError(AsyncOperationType.UNSET, null, System.currentTimeMillis() - start, e.getMessage(), e, toSet, field);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void pushPull(final boolean push, final Query<T> query, final String field, final Object value, final boolean insertIfNotExist, final boolean multiple, final AsyncOperationCallback<T> callback) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Class cls = query.getType();
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL);
                String coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                DBObject qobj = query.toQueryObject();
                if (insertIfNotExist) {
                    qobj = MorphiumWriterImpl.this.morphium.simplifyQueryObject(qobj);
                }
                Object v = MorphiumWriterImpl.this.marshallIfNecessary(value);
                String fieldName = MorphiumWriterImpl.this.annotationHelper.getFieldName(cls, field);
                BasicDBObject set = new BasicDBObject(fieldName, v);
                BasicDBObject update = new BasicDBObject(push ? "$push" : "$pull", (Object)set);
                long start = System.currentTimeMillis();
                try {
                    MorphiumWriterImpl.this.pushIt(push, insertIfNotExist, multiple, cls, coll, qobj, update);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
                    if (callback != null) {
                        callback.onOperationSucceeded(AsyncOperationType.PUSH, query, System.currentTimeMillis() - start, null, null, field, value, insertIfNotExist, multiple);
                    }
                }
                catch (RuntimeException e) {
                    if (callback == null) {
                        throw new RuntimeException(e);
                    }
                    callback.onOperationError(AsyncOperationType.PUSH, query, System.currentTimeMillis() - start, e.getMessage(), e, null, field, value, insertIfNotExist, multiple);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    private Object marshallIfNecessary(Object value) {
        if (value != null) {
            if (this.annotationHelper.isAnnotationPresentInHierarchy(value.getClass(), Entity.class) || this.annotationHelper.isAnnotationPresentInHierarchy(value.getClass(), Embedded.class)) {
                DBObject marshall = this.morphium.getMapper().marshall(value);
                marshall.put("class_name", (Object)this.annotationHelper.getRealClass(value.getClass()).getName());
                value = marshall;
            } else if (List.class.isAssignableFrom(value.getClass())) {
                ArrayList<Object> lst = new ArrayList<Object>();
                for (Object o : (List)value) {
                    if (this.annotationHelper.isAnnotationPresentInHierarchy(o.getClass(), Embedded.class) || this.annotationHelper.isAnnotationPresentInHierarchy(o.getClass(), Entity.class)) {
                        DBObject marshall = this.morphium.getMapper().marshall(o);
                        marshall.put("class_name", (Object)this.annotationHelper.getRealClass(o.getClass()).getName());
                        lst.add(marshall);
                        continue;
                    }
                    lst.add(o);
                }
                value = lst;
            } else if (Map.class.isAssignableFrom(value.getClass())) {
                Iterator i$ = ((Map)((Object)value)).entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry e;
                    Map.Entry en = e = i$.next();
                    if (!String.class.isAssignableFrom(e.getKey().getClass())) {
                        throw new IllegalArgumentException("Can't push maps with Key not of type String!");
                    }
                    if (!this.annotationHelper.isAnnotationPresentInHierarchy(en.getValue().getClass(), Entity.class) && !this.annotationHelper.isAnnotationPresentInHierarchy(en.getValue().getClass(), Embedded.class)) continue;
                    DBObject marshall = this.morphium.getMapper().marshall(en.getValue());
                    marshall.put("class_name", (Object)this.annotationHelper.getRealClass(en.getValue().getClass()).getName());
                    ((Map)((Object)value)).put(en.getKey(), marshall);
                }
            }
        }
        return value;
    }

    private void pushIt(boolean push, boolean insertIfNotExist, boolean multiple, Class<?> cls, String coll, DBObject qobj, BasicDBObject update) {
        if (!this.morphium.getDatabase().collectionExists(coll) && insertIfNotExist) {
            this.morphium.ensureIndicesFor(cls);
        }
        WriteConcern wc = this.morphium.getWriteConcernForClass(cls);
        long start = System.currentTimeMillis();
        if (wc == null) {
            this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple);
        } else {
            this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple, wc);
        }
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingWriteEvent(cls, update, dur, insertIfNotExist, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
        this.morphium.getCache().clearCacheIfNecessary(cls);
        this.morphium.firePostUpdateEvent(this.annotationHelper.getRealClass(cls), push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL);
    }

    @Override
    public <T> void pushPullAll(final boolean push, final Query<T> query, final String f, final List<?> v, final boolean insertIfNotExist, final boolean multiple, final AsyncOperationCallback<T> callback) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ArrayList<Object> value = v;
                String field = f;
                Class cls = query.getType();
                String coll = MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls);
                MorphiumWriterImpl.this.morphium.firePreUpdateEvent(MorphiumWriterImpl.this.annotationHelper.getRealClass(cls), push ? MorphiumStorageListener.UpdateTypes.PUSH : MorphiumStorageListener.UpdateTypes.PULL);
                long start = System.currentTimeMillis();
                ArrayList<Object> lst = new ArrayList<Object>();
                for (Object e : value) {
                    lst.add(MorphiumWriterImpl.this.marshallIfNecessary(e));
                }
                value = lst;
                try {
                    DBObject qobj = query.toQueryObject();
                    if (insertIfNotExist) {
                        qobj = MorphiumWriterImpl.this.morphium.simplifyQueryObject(qobj);
                    }
                    field = MorphiumWriterImpl.this.annotationHelper.getFieldName(cls, field);
                    BasicDBObject basicDBObject = new BasicDBObject(field, value);
                    BasicDBObject update = new BasicDBObject(push ? "$pushAll" : "$pullAll", (Object)basicDBObject);
                    WriteConcern wc = MorphiumWriterImpl.this.morphium.getWriteConcernForClass(cls);
                    if (wc == null) {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple);
                    } else {
                        MorphiumWriterImpl.this.morphium.getDatabase().getCollection(coll).update(qobj, (DBObject)update, insertIfNotExist, multiple, wc);
                    }
                    long dur = System.currentTimeMillis() - start;
                    MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, update, dur, insertIfNotExist, multiple ? WriteAccessType.BULK_UPDATE : WriteAccessType.SINGLE_UPDATE);
                    MorphiumWriterImpl.this.morphium.getCache().clearCacheIfNecessary(cls);
                    MorphiumWriterImpl.this.morphium.firePostUpdateEvent(query.getType(), MorphiumStorageListener.UpdateTypes.PUSH);
                    if (callback != null) {
                        callback.onOperationSucceeded(push ? AsyncOperationType.PUSH : AsyncOperationType.PULL, query, System.currentTimeMillis() - start, null, null, field, value, insertIfNotExist, multiple);
                    }
                }
                catch (RuntimeException e) {
                    if (callback == null) {
                        throw new RuntimeException(e);
                    }
                    callback.onOperationError(push ? AsyncOperationType.PUSH : AsyncOperationType.PULL, query, System.currentTimeMillis() - start, e.getMessage(), e, null, field, value, insertIfNotExist, multiple);
                }
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void dropCollection(final Class<T> cls, AsyncOperationCallback<T> callback) {
        if (!this.annotationHelper.isAnnotationPresentInHierarchy(cls, Entity.class)) {
            throw new RuntimeException("No entity class: " + cls.getName());
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                MorphiumWriterImpl.this.morphium.firePreDropEvent(cls);
                long start = System.currentTimeMillis();
                DBCollection coll = MorphiumWriterImpl.this.morphium.getDatabase().getCollection(MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls));
                coll.drop();
                long dur = System.currentTimeMillis() - start;
                MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, null, dur, false, WriteAccessType.DROP);
                MorphiumWriterImpl.this.morphium.firePostDropEvent(cls);
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public <T> void ensureIndex(final Class<T> cls, final Map<String, Object> index, AsyncOperationCallback<T> callback) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                List<String> fields = MorphiumWriterImpl.this.annotationHelper.getFields(cls, new Class[0]);
                LinkedHashMap idx = new LinkedHashMap();
                for (Map.Entry es : index.entrySet()) {
                    String k = (String)es.getKey();
                    if (!fields.contains(k) && !fields.contains(MorphiumWriterImpl.this.annotationHelper.convertCamelCase(k))) {
                        throw new IllegalArgumentException("Field unknown for type " + cls.getSimpleName() + ": " + k);
                    }
                    String fn = MorphiumWriterImpl.this.annotationHelper.getFieldName(cls, k);
                    idx.put(fn, es.getValue());
                }
                long start = System.currentTimeMillis();
                BasicDBObject keys = new BasicDBObject(idx);
                MorphiumWriterImpl.this.morphium.getDatabase().getCollection(MorphiumWriterImpl.this.morphium.getMapper().getCollectionName(cls)).ensureIndex((DBObject)keys);
                long dur = System.currentTimeMillis() - start;
                MorphiumWriterImpl.this.morphium.fireProfilingWriteEvent(cls, keys, dur, false, WriteAccessType.ENSURE_INDEX);
            }
        };
        this.submitAndBlockIfNecessary(callback, r);
    }

    @Override
    public int writeBufferCount() {
        return this.executor.getActiveCount();
    }
}

