/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.writer;

import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.annotations.caching.WriteBuffer;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.query.Query;
import de.caluga.morphium.writer.MorphiumWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.RejectedExecutionException;
import org.apache.log4j.Logger;

public class BufferedMorphiumWriterImpl
implements MorphiumWriter {
    private Morphium morphium;
    private AnnotationAndReflectionHelper annotationHelper = new AnnotationAndReflectionHelper();
    private MorphiumWriter directWriter;
    private Map<Class<?>, List<WriteBufferEntry>> opLog = new Hashtable();
    private Map<Class<?>, Long> lastRun = new Hashtable();
    private final Thread housekeeping;
    private boolean running = true;
    private Logger logger = Logger.getLogger(BufferedMorphiumWriterImpl.class);

    public BufferedMorphiumWriterImpl() {
        this.housekeeping = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (BufferedMorphiumWriterImpl.this.running) {
                    try {
                        ArrayList<Class> localBuffer = new ArrayList<Class>();
                        Map map = BufferedMorphiumWriterImpl.this.opLog;
                        synchronized (map) {
                            for (Object clz2 : BufferedMorphiumWriterImpl.this.opLog.keySet()) {
                                localBuffer.add((Class)clz2);
                            }
                        }
                        for (Class clz : localBuffer) {
                            List localQueue;
                            Object clz2;
                            clz2 = BufferedMorphiumWriterImpl.this.opLog;
                            synchronized (clz2) {
                                if (BufferedMorphiumWriterImpl.this.opLog.get(clz) == null || ((List)BufferedMorphiumWriterImpl.this.opLog.get(clz)).size() == 0) {
                                    continue;
                                }
                            }
                            WriteBuffer wb = BufferedMorphiumWriterImpl.this.annotationHelper.getAnnotationFromHierarchy(clz, WriteBuffer.class);
                            if (wb.timeout() == -1 && wb.size() > 0 && ((List)BufferedMorphiumWriterImpl.this.opLog.get(clz)).size() < wb.size()) continue;
                            long timeout = BufferedMorphiumWriterImpl.this.morphium.getConfig().getWriteBufferTime();
                            if (wb.timeout() != 0) {
                                timeout = wb.timeout();
                            }
                            if (BufferedMorphiumWriterImpl.this.lastRun.get(clz) != null && System.currentTimeMillis() - (Long)BufferedMorphiumWriterImpl.this.lastRun.get(clz) < timeout) continue;
                            BufferedMorphiumWriterImpl.this.lastRun.put(clz, System.currentTimeMillis());
                            Map map2 = BufferedMorphiumWriterImpl.this.opLog;
                            synchronized (map2) {
                                localQueue = (List)BufferedMorphiumWriterImpl.this.opLog.get(clz);
                                BufferedMorphiumWriterImpl.this.opLog.put(clz, new Vector());
                            }
                            for (WriteBufferEntry entry : localQueue) {
                                BufferedMorphiumWriterImpl.this.waitForWriters();
                                try {
                                    entry.getToRun().run();
                                }
                                catch (RejectedExecutionException e) {
                                    BufferedMorphiumWriterImpl.this.logger.info((Object)"too much load - add write to next run");
                                    ((List)BufferedMorphiumWriterImpl.this.opLog.get(clz)).add(entry);
                                }
                                catch (Exception e) {
                                    BufferedMorphiumWriterImpl.this.logger.error((Object)"could not write", (Throwable)e);
                                }
                            }
                            localQueue = null;
                        }
                    }
                    catch (Exception e) {
                        BufferedMorphiumWriterImpl.this.logger.info((Object)"Got exception during write buffer handling!", (Throwable)e);
                    }
                    try {
                        Thread.sleep(BufferedMorphiumWriterImpl.this.morphium.getConfig().getWriteBufferTimeGranularity());
                    }
                    catch (Exception exception) {}
                }
            }
        };
        this.housekeeping.setDaemon(true);
        this.housekeeping.start();
    }

    private void waitForWriters() {
        while ((double)this.directWriter.writeBufferCount() > (double)(this.morphium.getConfig().getMaxConnections() * this.morphium.getConfig().getBlockingThreadsMultiplier()) * 0.9 - 1.0) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"have to wait - maximum connection limit almost reached");
                }
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToWriteQueue(Class<?> type, Runnable r) {
        WriteBuffer w;
        WriteBufferEntry wb = new WriteBufferEntry(r, System.currentTimeMillis());
        if (this.opLog.get(type) == null) {
            this.opLog.put(type, new Vector());
        }
        if ((w = this.annotationHelper.getAnnotationFromHierarchy(type, WriteBuffer.class)).size() > 0 && this.opLog.get(type).size() > w.size()) {
            this.logger.warn((Object)("WARNING: Write buffer maximum exceeded: " + this.opLog.get(type).size() + " entries now, max is " + w.size()));
            switch (w.strategy()) {
                case JUST_WARN: {
                    break;
                }
                case IGNORE_NEW: {
                    this.logger.warn((Object)"ignoring new incoming...");
                    return;
                }
                case WRITE_NEW: {
                    this.logger.warn((Object)"directly writing data... due to strategy setting");
                    r.run();
                    this.waitForWriters();
                    return;
                }
                case WRITE_OLD: {
                    Map<Class<?>, List<WriteBufferEntry>> map = this.opLog;
                    synchronized (map) {
                        Collections.sort(this.opLog.get(type), new Comparator<WriteBufferEntry>(){

                            @Override
                            public int compare(WriteBufferEntry o1, WriteBufferEntry o2) {
                                return Long.valueOf(o1.getTimestamp()).compareTo(o2.getTimestamp());
                            }
                        });
                        for (int i = 0; i < this.opLog.get(type).size() - w.size(); ++i) {
                            this.opLog.get(type).get(i).getToRun().run();
                            this.opLog.get(type).remove(i);
                            this.waitForWriters();
                        }
                    }
                    return;
                }
                case DEL_OLD: {
                    Map<Class<?>, List<WriteBufferEntry>> map = this.opLog;
                    synchronized (map) {
                        Collections.sort(this.opLog.get(type), new Comparator<WriteBufferEntry>(){

                            @Override
                            public int compare(WriteBufferEntry o1, WriteBufferEntry o2) {
                                return Long.valueOf(o1.getTimestamp()).compareTo(o2.getTimestamp());
                            }
                        });
                        for (int i = 0; i < this.opLog.get(type).size() - w.size(); ++i) {
                            this.opLog.get(type).get(i).getToRun().run();
                            this.opLog.get(type).remove(i);
                        }
                    }
                    return;
                }
            }
        }
        this.opLog.get(type).add(wb);
    }

    @Override
    public <T> void store(final T o, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(o.getClass(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.store(o, callback);
            }
        });
    }

    @Override
    public <T> void store(final List<T> lst, AsyncOperationCallback<T> c) {
        if (lst == null || lst.size() == 0) {
            if (c != null) {
                c.onOperationSucceeded(AsyncOperationType.WRITE, null, 0L, lst, null, new Object[0]);
            }
            return;
        }
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<Object> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(lst.get(0).getClass(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.store(lst, callback);
            }
        });
    }

    @Override
    public <T> void updateUsingFields(final T ent, AsyncOperationCallback<T> c, final String ... fields) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(ent.getClass(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.updateUsingFields(ent, callback, fields);
            }
        });
    }

    @Override
    public <T> void set(final T toSet, final String field, final Object value, final boolean insertIfNotExists, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(toSet.getClass(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.set(toSet, field, value, insertIfNotExists, multiple, callback);
            }
        });
    }

    @Override
    public <T> void set(final Query<T> query, final Map<String, Object> values, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.set(query, values, insertIfNotExist, multiple, callback);
            }
        });
    }

    @Override
    public <T> void inc(final Query<T> query, final String field, final int amount, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.inc(query, field, amount, insertIfNotExist, multiple, callback);
            }
        });
    }

    @Override
    public <T> void inc(final T toInc, final String field, final int amount, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(toInc.getClass(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.inc(toInc, field, amount, callback);
            }
        });
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        this.annotationHelper = m.getARHelper();
        this.directWriter = m.getConfig().getWriter();
    }

    @Override
    public <T> void delete(final List<T> lst, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(lst.get(0).getClass(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.delete(lst, callback);
            }
        });
    }

    @Override
    public <T> void delete(final T o, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(o.getClass(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.delete(o, callback);
            }
        });
    }

    @Override
    public <T> void delete(final Query<T> q, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(q.getType(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.delete(q, callback);
            }
        });
    }

    @Override
    public <T> void pushPull(final boolean push, final Query<T> query, final String field, final Object value, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.pushPull(push, query, field, value, insertIfNotExist, multiple, callback);
            }
        });
    }

    @Override
    public <T> void pushPullAll(final boolean push, final Query<T> query, final String field, final List<?> value, final boolean insertIfNotExist, final boolean multiple, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(query.getType(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.pushPullAll(push, query, field, value, insertIfNotExist, multiple, callback);
            }
        });
    }

    @Override
    public <T> void unset(final T toSet, final String field, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(toSet.getClass(), new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.unset(toSet, field, callback);
            }
        });
    }

    @Override
    public <T> void dropCollection(final Class<T> cls, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(cls, new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.dropCollection(cls, callback);
            }
        });
    }

    @Override
    public <T> void ensureIndex(final Class<T> cls, final Map<String, Object> index, AsyncOperationCallback<T> c) {
        if (c == null) {
            c = new AsyncOpAdapter();
        }
        final AsyncOperationCallback<T> callback = c;
        this.morphium.inc(StatisticKeys.WRITES_CACHED);
        this.addToWriteQueue(cls, new Runnable(){

            @Override
            public void run() {
                BufferedMorphiumWriterImpl.this.directWriter.ensureIndex(cls, index, callback);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeBufferCount() {
        int cnt = 0;
        Map<Class<?>, List<WriteBufferEntry>> map = this.opLog;
        synchronized (map) {
            for (List<WriteBufferEntry> lst : this.opLog.values()) {
                cnt += lst.size();
            }
        }
        return cnt;
    }

    private class AsyncOpAdapter<T>
    implements AsyncOperationCallback<T> {
        private AsyncOpAdapter() {
        }

        @Override
        public void onOperationSucceeded(AsyncOperationType type, Query<T> q, long duration, List<T> result, T entity, Object ... param) {
        }

        @Override
        public void onOperationError(AsyncOperationType type, Query<T> q, long duration, String error, Throwable t, T entity, Object ... param) {
        }
    }

    private class WriteBufferEntry {
        private Runnable toRun;
        private long timestamp;

        private WriteBufferEntry(Runnable toRun, long timestamp) {
            this.toRun = toRun;
            this.timestamp = timestamp;
        }

        public Runnable getToRun() {
            return this.toRun;
        }

        public void setToRun(Runnable toRun) {
            this.toRun = toRun;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }
    }
}

