/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.query;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.FilterExpression;
import de.caluga.morphium.Morphium;
import de.caluga.morphium.ReadAccessType;
import de.caluga.morphium.StatisticKeys;
import de.caluga.morphium.annotations.AdditionalData;
import de.caluga.morphium.annotations.DefaultReadPreference;
import de.caluga.morphium.annotations.Id;
import de.caluga.morphium.annotations.LastAccess;
import de.caluga.morphium.annotations.ReadPreferenceLevel;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.async.AsyncOperationCallback;
import de.caluga.morphium.async.AsyncOperationType;
import de.caluga.morphium.query.MongoField;
import de.caluga.morphium.query.MorphiumIterator;
import de.caluga.morphium.query.Query;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.bson.types.ObjectId;

public class QueryImpl<T>
implements Query<T>,
Cloneable {
    private String where;
    private Class<? extends T> type;
    private List<FilterExpression> andExpr;
    private List<Query<T>> orQueries;
    private List<Query<T>> norQueries;
    private ReadPreferenceLevel readPreferenceLevel;
    private ReadPreference readPreference;
    private boolean additionalDataPresent = false;
    private int limit = 0;
    private int skip = 0;
    private Map<String, Integer> order;
    private Morphium morphium;
    private static Logger log = Logger.getLogger(Query.class);
    private AnnotationAndReflectionHelper annotationHelper = new AnnotationAndReflectionHelper();
    private ThreadPoolExecutor executor;

    public QueryImpl() {
    }

    public QueryImpl(Morphium m, Class<? extends T> type, ThreadPoolExecutor executor) {
        this(m);
        this.setType(type);
        this.executor = executor;
    }

    public ThreadPoolExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        }
        return this.executor;
    }

    @Override
    public void setExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    @Override
    public String getWhere() {
        return this.where;
    }

    @Override
    public Morphium getMorphium() {
        return this.morphium;
    }

    @Override
    public void setMorphium(Morphium m) {
        this.morphium = m;
        this.annotationHelper = m == null ? new AnnotationAndReflectionHelper() : m.getARHelper();
        this.andExpr = new Vector<FilterExpression>();
        this.orQueries = new Vector<Query<T>>();
        this.norQueries = new Vector<Query<T>>();
    }

    public QueryImpl(Morphium m) {
        this.setMorphium(m);
    }

    @Override
    public ReadPreferenceLevel getReadPreferenceLevel() {
        return this.readPreferenceLevel;
    }

    @Override
    public void setReadPreferenceLevel(ReadPreferenceLevel readPreferenceLevel) {
        this.readPreferenceLevel = readPreferenceLevel;
        this.readPreference = readPreferenceLevel.getPref();
    }

    @Override
    public void setType(Class<? extends T> type) {
        List<String> fields;
        this.type = type;
        DefaultReadPreference pr = this.annotationHelper.getAnnotationFromHierarchy(type, DefaultReadPreference.class);
        if (pr != null) {
            this.setReadPreferenceLevel(pr.value());
        }
        this.additionalDataPresent = (fields = this.annotationHelper.getFields(type, AdditionalData.class)) != null && fields.size() != 0;
    }

    @Override
    public Query<T> q() {
        QueryImpl<? extends T> q = new QueryImpl<T>(this.morphium, this.type, this.executor);
        return q;
    }

    @Override
    public List<T> complexQuery(DBObject query) {
        return this.complexQuery(query, (String)null, 0, 0);
    }

    @Override
    public List<T> complexQuery(DBObject query, String sort, int skip, int limit) {
        HashMap<String, Integer> srt = new HashMap<String, Integer>();
        if (sort != null) {
            String[] tok;
            for (String t : tok = sort.split(",")) {
                if (t.startsWith("-")) {
                    srt.put(t.substring(1), -1);
                    continue;
                }
                if (t.startsWith("+")) {
                    srt.put(t.substring(1), 1);
                    continue;
                }
                srt.put(t, 1);
            }
        }
        return this.complexQuery(query, srt, skip, limit);
    }

    @Override
    public List<T> complexQuery(DBObject query, Map<String, Integer> sort, int skip, int limit) {
        String ck = this.morphium.getCache().getCacheKey(query, sort, skip, limit);
        if (this.morphium.getCache().isCached(this.type, ck)) {
            return this.morphium.getCache().getFromCache(this.type, ck);
        }
        long start = System.currentTimeMillis();
        DBCollection c = this.morphium.getDatabase().getCollection(this.morphium.getMapper().getCollectionName(this.type));
        this.setReadPreferenceFor(c);
        List<Field> fldlst = this.annotationHelper.getAllFields(this.type);
        BasicDBObject lst = new BasicDBObject();
        lst.put("_id", (Object)1);
        for (Field f : fldlst) {
            if (f.isAnnotationPresent(AdditionalData.class)) {
                lst = new BasicDBObject();
                break;
            }
            String n = this.annotationHelper.getFieldName(this.type, f.getName());
            lst.put(n, (Object)1);
        }
        DBCursor cursor = c.find(query, (DBObject)lst);
        if (sort != null) {
            BasicDBObject srt = new BasicDBObject();
            srt.putAll(sort);
            cursor.sort((DBObject)srt);
        }
        if (skip > 0) {
            cursor.skip(skip);
        }
        if (limit > 0) {
            cursor.limit(limit);
        }
        ArrayList<T> ret = new ArrayList<T>();
        while (cursor.hasNext()) {
            ret.add(this.morphium.getMapper().unmarshall(this.type, cursor.next()));
        }
        this.morphium.fireProfilingReadEvent(this, System.currentTimeMillis() - start, ReadAccessType.AS_LIST);
        return ret;
    }

    @Override
    public T complexQueryOne(DBObject query) {
        return this.complexQueryOne(query, null, 0);
    }

    @Override
    public T complexQueryOne(DBObject query, Map<String, Integer> sort, int skip) {
        List<T> ret = this.complexQuery(query, sort, skip, 1);
        if (ret != null && ret.isEmpty()) {
            return ret.get(0);
        }
        return null;
    }

    @Override
    public T complexQueryOne(DBObject query, Map<String, Integer> sort) {
        return this.complexQueryOne(query, sort, 0);
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getSkip() {
        return this.skip;
    }

    @Override
    public Map<String, Integer> getOrder() {
        return this.order;
    }

    @Override
    public void addChild(FilterExpression ex) {
        this.andExpr.add(ex);
    }

    @Override
    public Query<T> where(String wh) {
        this.where = wh;
        return this;
    }

    @Override
    public MongoField<T> f(Enum f) {
        return this.f(f.name());
    }

    @Override
    public MongoField<T> f(String f) {
        String cf = f;
        if (f.contains(".")) {
            cf = f.substring(0, f.indexOf("."));
        } else if (this.additionalDataPresent) {
            log.debug((Object)"Additional data is available, not checking field");
            MongoField fld = this.morphium.createMongoField();
            fld.setFieldString(f);
            fld.setMapper(this.morphium.getMapper());
            fld.setQuery(this);
            return fld;
        }
        Field field = this.annotationHelper.getField(this.type, cf);
        if (field == null) {
            throw new IllegalArgumentException("Unknown Field " + f);
        }
        f = field.isAnnotationPresent(Id.class) ? "_id" : this.annotationHelper.getFieldName(this.type, f);
        MongoField fld = this.morphium.createMongoField();
        fld.setFieldString(f);
        fld.setMapper(this.morphium.getMapper());
        fld.setQuery(this);
        return fld;
    }

    @Override
    public Query<T> or(Query<T> ... qs) {
        this.orQueries.addAll(Arrays.asList(qs));
        return this;
    }

    @Override
    public Query<T> or(List<Query<T>> qs) {
        this.orQueries.addAll(qs);
        return this;
    }

    private Query<T> getClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)"Clone not supported?!?!?!");
            throw new RuntimeException(e);
        }
    }

    @Override
    public Query<T> nor(Query<T> ... qs) {
        this.norQueries.addAll(Arrays.asList(qs));
        return this;
    }

    @Override
    public Query<T> limit(int i) {
        this.limit = i;
        return this;
    }

    @Override
    public Query<T> skip(int i) {
        this.skip = i;
        return this;
    }

    @Override
    public Query<T> sort(Map<String, Integer> n) {
        this.order = n;
        return this;
    }

    @Override
    public Query<T> sort(String ... prefixedString) {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        String[] arr$ = prefixedString;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String i;
            String fld = i = arr$[i$];
            int val = 1;
            if (i.startsWith("-")) {
                fld = i.substring(1);
                val = -1;
            } else if (i.startsWith("+")) {
                fld = i.substring(1);
                val = 1;
            }
            if (!fld.contains(".")) {
                fld = this.annotationHelper.getFieldName(this.type, fld);
            }
            m.put(fld, val);
        }
        return this.sort(m);
    }

    @Override
    public Query<T> sort(Enum ... naturalOrder) {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        for (Enum i : naturalOrder) {
            String fld = this.annotationHelper.getFieldName(this.type, i.name());
            m.put(fld, 1);
        }
        return this.sort(m);
    }

    @Override
    public void countAll(final AsyncOperationCallback<T> c) {
        if (c == null) {
            throw new IllegalArgumentException("Not really useful to read from db and not use the result");
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    long ret = QueryImpl.this.countAll();
                    c.onOperationSucceeded(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, null, null, ret);
                }
                catch (Exception e) {
                    c.onOperationError(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
                }
            }
        };
        this.getExecutor().submit(r);
    }

    @Override
    public long countAll() {
        this.morphium.inc(StatisticKeys.READS);
        long start = System.currentTimeMillis();
        DBCollection collection = this.morphium.getDatabase().getCollection(this.morphium.getMapper().getCollectionName(this.type));
        this.setReadPreferenceFor(collection);
        long ret = collection.count(this.toQueryObject());
        this.morphium.fireProfilingReadEvent(this, System.currentTimeMillis() - start, ReadAccessType.COUNT);
        return ret;
    }

    private void setReadPreferenceFor(DBCollection c) {
        if (this.readPreference != null) {
            c.setReadPreference(this.readPreference);
        } else {
            c.setReadPreference(null);
        }
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
        this.readPreferenceLevel = null;
    }

    @Override
    public DBObject toQueryObject() {
        boolean onlyAnd;
        BasicDBObject o = new BasicDBObject();
        BasicDBList lst = new BasicDBList();
        boolean bl = onlyAnd = this.orQueries.isEmpty() && this.norQueries.isEmpty() && this.where == null;
        if (this.where != null) {
            o.put("$where", (Object)this.where);
        }
        if (this.andExpr.size() == 1 && onlyAnd) {
            return this.andExpr.get(0).dbObject();
        }
        if (this.andExpr.size() == 1 && onlyAnd) {
            return this.andExpr.get(0).dbObject();
        }
        if (this.andExpr.isEmpty() && onlyAnd) {
            return o;
        }
        if (this.andExpr.size() > 0) {
            for (FilterExpression filterExpression : this.andExpr) {
                lst.add((Object)filterExpression.dbObject());
            }
            o.put("$and", (Object)lst);
            lst = new BasicDBList();
        }
        if (this.orQueries.size() != 0) {
            for (Query query : this.orQueries) {
                lst.add((Object)query.toQueryObject());
            }
            if (o.get("$and") != null) {
                ((BasicDBList)o.get("$and")).add((Object)new BasicDBObject("$or", (Object)lst));
            } else {
                o.put("$or", (Object)lst);
            }
        }
        if (this.norQueries.size() != 0) {
            for (Query query : this.norQueries) {
                lst.add((Object)query.toQueryObject());
            }
            if (o.get("$and") != null) {
                ((BasicDBList)o.get("$and")).add((Object)new BasicDBObject("$nor", (Object)lst));
            } else {
                o.put("$nor", (Object)lst);
            }
        }
        return o;
    }

    @Override
    public Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public void asList(final AsyncOperationCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    List lst = QueryImpl.this.asList();
                    callback.onOperationSucceeded(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, lst, null, new Object[0]);
                }
                catch (Exception e) {
                    callback.onOperationError(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
                }
            }
        };
        this.getExecutor().submit(r);
    }

    @Override
    public List<T> asList() {
        this.morphium.inc(StatisticKeys.READS);
        Cache c = this.annotationHelper.getAnnotationFromHierarchy(this.type, Cache.class);
        boolean useCache = c != null && c.readCache();
        String ck = this.morphium.getCache().getCacheKey(this);
        if (useCache) {
            if (this.morphium.getCache().isCached(this.type, ck)) {
                this.morphium.inc(StatisticKeys.CHITS);
                return this.morphium.getCache().getFromCache(this.type, ck);
            }
            this.morphium.inc(StatisticKeys.CMISS);
        } else {
            this.morphium.inc(StatisticKeys.NO_CACHED_READS);
        }
        long start = System.currentTimeMillis();
        DBCollection collection = this.morphium.getDatabase().getCollection(this.morphium.getMapper().getCollectionName(this.type));
        this.setReadPreferenceFor(collection);
        List<Field> fldlst = this.annotationHelper.getAllFields(this.type);
        BasicDBObject lst = new BasicDBObject();
        lst.put("_id", (Object)1);
        for (Field f : fldlst) {
            if (f.isAnnotationPresent(AdditionalData.class)) {
                lst = new BasicDBObject();
                break;
            }
            String n = this.annotationHelper.getFieldName(this.type, f.getName());
            lst.put(n, (Object)1);
        }
        DBCursor query = collection.find(this.toQueryObject(), (DBObject)lst);
        if (this.skip > 0) {
            query.skip(this.skip);
        }
        if (this.limit > 0) {
            query.limit(this.limit);
        }
        if (this.order != null) {
            BasicDBObject srt = new BasicDBObject();
            for (String k : this.order.keySet()) {
                srt.append(k, (Object)this.order.get(k));
            }
            query.sort((DBObject)new BasicDBObject((Map)srt));
        }
        Iterator it = query.iterator();
        ArrayList<T> ret = new ArrayList<T>();
        this.morphium.fireProfilingReadEvent(this, System.currentTimeMillis() - start, ReadAccessType.AS_LIST);
        while (it.hasNext()) {
            DBObject o = (DBObject)it.next();
            T unmarshall = this.morphium.getMapper().unmarshall(this.type, o);
            ret.add(unmarshall);
            this.updateLastAccess(o, unmarshall);
            this.morphium.firePostLoadEvent(unmarshall);
        }
        if (useCache) {
            this.morphium.getCache().addToCache(ck, this.type, ret);
        }
        return ret;
    }

    @Override
    public MorphiumIterator<T> asIterable() {
        return this.asIterable(10);
    }

    @Override
    public MorphiumIterator<T> asIterable(int windowSize) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("creating iterable for query - windowsize " + windowSize));
            }
            MorphiumIterator it = this.morphium.getConfig().getIteratorClass().newInstance();
            it.setQuery(this);
            it.setWindowSize(windowSize);
            return it;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateLastAccess(DBObject o, T unmarshall) {
        if (this.annotationHelper.isAnnotationPresentInHierarchy(this.type, LastAccess.class)) {
            List<String> lst = this.annotationHelper.getFields(this.type, LastAccess.class);
            for (String ctf : lst) {
                Field f = this.annotationHelper.getField(this.type, ctf);
                if (f == null) continue;
                try {
                    f.set(unmarshall, System.currentTimeMillis());
                }
                catch (IllegalAccessException e) {
                    System.out.println("Could not set modification time");
                }
            }
            this.morphium.store(unmarshall);
        }
    }

    @Override
    public void getById(final ObjectId id, final AsyncOperationCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback is null");
        }
        Runnable c = new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    Object res = QueryImpl.this.getById(id);
                    ArrayList result = new ArrayList();
                    result.add(res);
                    callback.onOperationSucceeded(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, result, res, new Object[0]);
                }
                catch (Exception e) {
                    callback.onOperationError(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
                }
            }
        };
        this.getExecutor().submit(c);
    }

    @Override
    public T getById(ObjectId id) {
        List<String> flds = this.annotationHelper.getFields(this.type, Id.class);
        if (flds == null || flds.isEmpty()) {
            throw new RuntimeException("Type does not have an ID-Field? " + this.type.getSimpleName());
        }
        String f = flds.get(0);
        Query<T> q = this.q().f(f).eq(id);
        return q.get();
    }

    @Override
    public void get(final AsyncOperationCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback is null");
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    ArrayList ret = new ArrayList();
                    Object ent = QueryImpl.this.get();
                    ret.add(ent);
                    callback.onOperationSucceeded(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, ret, ent, new Object[0]);
                }
                catch (Exception e) {
                    callback.onOperationError(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
                }
            }
        };
        this.getExecutor().submit(r);
    }

    @Override
    public T get() {
        Cache c = this.annotationHelper.getAnnotationFromHierarchy(this.type, Cache.class);
        boolean readCache = c != null && c.readCache();
        String ck = this.morphium.getCache().getCacheKey(this);
        this.morphium.inc(StatisticKeys.READS);
        if (readCache) {
            if (this.morphium.getCache().isCached(this.type, ck)) {
                this.morphium.inc(StatisticKeys.CHITS);
                List<T> lst = this.morphium.getCache().getFromCache(this.type, ck);
                if (lst == null || lst.isEmpty()) {
                    return null;
                }
                return lst.get(0);
            }
            this.morphium.inc(StatisticKeys.CMISS);
        } else {
            this.morphium.inc(StatisticKeys.NO_CACHED_READS);
        }
        long start = System.currentTimeMillis();
        DBCollection coll = this.morphium.getDatabase().getCollection(this.morphium.getMapper().getCollectionName(this.type));
        this.setReadPreferenceFor(coll);
        List<Field> fldlst = this.annotationHelper.getAllFields(this.type);
        BasicDBObject fl = new BasicDBObject();
        fl.put("_id", (Object)1);
        for (Field f : fldlst) {
            if (f.isAnnotationPresent(AdditionalData.class)) {
                fl = new BasicDBObject();
                break;
            }
            String n = this.annotationHelper.getFieldName(this.type, f.getName());
            fl.put(n, (Object)1);
        }
        DBCursor srch = coll.find(this.toQueryObject(), (DBObject)fl);
        srch.limit(1);
        if (this.skip != 0) {
            srch = srch.skip(this.skip);
        }
        if (this.order != null) {
            BasicDBObject srt = new BasicDBObject();
            for (String k : this.order.keySet()) {
                srt.append(k, (Object)this.order.get(k));
            }
            srch.sort((DBObject)new BasicDBObject((Map)srt));
        }
        if (srch.length() == 0) {
            return null;
        }
        DBObject ret = (DBObject)srch.toArray(1).get(0);
        ArrayList<T> lst = new ArrayList<T>(1);
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingReadEvent(this, dur, ReadAccessType.GET);
        if (ret != null) {
            T unmarshall = this.morphium.getMapper().unmarshall(this.type, ret);
            this.morphium.firePostLoadEvent(unmarshall);
            this.updateLastAccess(ret, unmarshall);
            lst.add(unmarshall);
            if (readCache) {
                this.morphium.getCache().addToCache(ck, this.type, lst);
            }
            return unmarshall;
        }
        if (readCache) {
            this.morphium.getCache().addToCache(ck, this.type, lst);
        }
        return null;
    }

    @Override
    public void idList(final AsyncOperationCallback<T> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callable is null?");
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                try {
                    List<ObjectId> ret = QueryImpl.this.idList();
                    callback.onOperationSucceeded(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, null, null, ret);
                }
                catch (Exception e) {
                    callback.onOperationError(AsyncOperationType.READ, QueryImpl.this, System.currentTimeMillis() - start, e.getMessage(), e, null, new Object[0]);
                }
            }
        };
        this.getExecutor().submit(r);
    }

    @Override
    public List<ObjectId> idList() {
        Cache c = this.annotationHelper.getAnnotationFromHierarchy(this.type, Cache.class);
        boolean readCache = c != null && c.readCache();
        ArrayList<ObjectId> ret = new ArrayList<ObjectId>();
        String ck = this.morphium.getCache().getCacheKey(this);
        ck = ck + " idlist";
        this.morphium.inc(StatisticKeys.READS);
        if (readCache) {
            if (this.morphium.getCache().isCached(this.type, ck)) {
                this.morphium.inc(StatisticKeys.CHITS);
                return this.morphium.getCache().getFromCache(this.type, ck);
            }
            this.morphium.inc(StatisticKeys.CMISS);
        } else {
            this.morphium.inc(StatisticKeys.NO_CACHED_READS);
        }
        long start = System.currentTimeMillis();
        DBCollection collection = this.morphium.getDatabase().getCollection(this.morphium.getMapper().getCollectionName(this.type));
        this.setReadPreferenceFor(collection);
        DBCursor query = collection.find(this.toQueryObject(), (DBObject)new BasicDBObject("_id", (Object)1));
        if (this.order != null) {
            query.sort((DBObject)new BasicDBObject(this.order));
        }
        if (this.skip > 0) {
            query.skip(this.skip);
        }
        if (this.limit > 0) {
            query.limit(0);
        }
        for (DBObject o : query) {
            ret.add((ObjectId)o.get("_id"));
        }
        long dur = System.currentTimeMillis() - start;
        this.morphium.fireProfilingReadEvent(this, dur, ReadAccessType.ID_LIST);
        if (readCache) {
            this.morphium.getCache().addToCache(ck, this.type, ret);
        }
        return ret;
    }

    @Override
    public Query<T> clone() throws CloneNotSupportedException {
        try {
            QueryImpl ret = (QueryImpl)super.clone();
            if (this.andExpr != null) {
                ret.andExpr = new Vector<FilterExpression>();
                ret.andExpr.addAll(this.andExpr);
            }
            if (this.norQueries != null) {
                ret.norQueries = new Vector<Query<T>>();
                ret.norQueries.addAll(this.norQueries);
            }
            if (this.order != null) {
                ret.order = new Hashtable<String, Integer>();
                ret.order.putAll(this.order);
            }
            if (this.orQueries != null) {
                ret.orQueries = new Vector<Query<T>>();
                ret.orQueries.addAll(this.orQueries);
            }
            if (this.readPreferenceLevel != null) {
                ret.readPreferenceLevel = this.readPreferenceLevel;
            }
            if (this.readPreference != null) {
                ret.readPreference = this.readPreference;
            }
            if (this.where != null) {
                ret.where = this.where;
            }
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Query<T> order(Map<String, Integer> n) {
        return this.sort(n);
    }

    @Override
    public Query<T> order(String ... prefixedString) {
        return this.sort(prefixedString);
    }

    @Override
    public int getNumberOfPendingRequests() {
        return this.getExecutor().getActiveCount();
    }
}

