/*
 * Decompiled with CFR 0.152.
 */
package de.caluga.morphium.cache;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import de.caluga.morphium.AnnotationAndReflectionHelper;
import de.caluga.morphium.annotations.caching.Cache;
import de.caluga.morphium.cache.CacheElement;
import de.caluga.morphium.cache.MorphiumCache;
import de.caluga.morphium.query.Query;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bson.types.ObjectId;

public class MorphiumCacheImpl
implements MorphiumCache {
    private Hashtable<Class<?>, Hashtable<String, CacheElement>> cache;
    private Hashtable<Class<?>, Hashtable<ObjectId, Object>> idCache;
    private AnnotationAndReflectionHelper annotationHelper = new AnnotationAndReflectionHelper();
    private Logger logger = Logger.getLogger(MorphiumCacheImpl.class);

    public MorphiumCacheImpl() {
        this.cache = new Hashtable();
        this.idCache = new Hashtable();
    }

    @Override
    public <T> void addToCache(String k, Class<?> type, List<T> ret) {
        if (k == null) {
            return;
        }
        if (ret != null) {
            Hashtable<Class<?>, Hashtable<ObjectId, Object>> idCacheClone = this.cloneIdCache();
            for (T record : ret) {
                if (idCacheClone.get(type) == null) {
                    idCacheClone.put(type, new Hashtable());
                }
                idCacheClone.get(type).put(this.annotationHelper.getId(record), record);
            }
            this.setIdCache(idCacheClone);
        }
        CacheElement<T> e = new CacheElement<T>(ret);
        e.setLru(System.currentTimeMillis());
        Hashtable cl = (Hashtable)this.cache.clone();
        if (cl.get(type) == null) {
            cl.put(type, new Hashtable());
        }
        ((Hashtable)cl.get(type)).put(k, e);
        this.cache = cl;
    }

    @Override
    public void clearCacheIfNecessary(Class cls) {
        Cache c = this.annotationHelper.getAnnotationFromHierarchy(cls, Cache.class);
        if (c != null && c.clearOnWrite()) {
            this.clearCachefor(cls);
        }
    }

    @Override
    public boolean isCached(Class<?> type, String k) {
        Cache c = this.annotationHelper.getAnnotationFromHierarchy(type, Cache.class);
        if (c != null) {
            if (!c.readCache()) {
                return false;
            }
        } else {
            return false;
        }
        return this.cache.get(type) != null && this.cache.get(type).get(k) != null && this.cache.get(type).get(k).getFound() != null;
    }

    @Override
    public <T> List<T> getFromCache(Class<? extends T> type, String k) {
        if (this.cache.get(type) == null || this.cache.get(type).get(k) == null) {
            return null;
        }
        CacheElement cacheElement = this.cache.get(type).get(k);
        cacheElement.setLru(System.currentTimeMillis());
        return cacheElement.getFound();
    }

    @Override
    public Hashtable<Class<?>, Hashtable<String, CacheElement>> cloneCache() {
        return (Hashtable)this.cache.clone();
    }

    @Override
    public Hashtable<Class<?>, Hashtable<ObjectId, Object>> cloneIdCache() {
        return (Hashtable)this.idCache.clone();
    }

    @Override
    public <T> T getFromIDCache(Class<? extends T> type, ObjectId id) {
        if (this.idCache.get(type) != null) {
            return (T)this.idCache.get(type).get(id);
        }
        return null;
    }

    @Override
    public String getCacheKey(DBObject qo, Map<String, Integer> sort, int skip, int limit) {
        StringBuffer b = new StringBuffer();
        b.append(qo.toString());
        b.append(" l:");
        b.append(limit);
        b.append(" s:");
        b.append(skip);
        if (sort != null) {
            b.append(" sort:");
            b.append(new BasicDBObject(sort).toString());
        }
        return b.toString();
    }

    @Override
    public String getCacheKey(Query q) {
        return this.getCacheKey(q.toQueryObject(), q.getOrder(), q.getSkip(), q.getLimit());
    }

    @Override
    public void clearCachefor(Class<?> cls) {
        if (this.cache.get(cls) != null) {
            this.cache.get(cls).clear();
        }
        if (this.idCache.get(cls) != null) {
            this.idCache.get(cls).clear();
        }
    }

    @Override
    public void resetCache() {
        this.setCache(new Hashtable());
    }

    @Override
    public void setCache(Hashtable<Class<?>, Hashtable<String, CacheElement>> cache) {
        this.cache = cache;
    }

    @Override
    public void removeEntryFromCache(Class cls, ObjectId id) {
        Hashtable<Class<?>, Hashtable<String, CacheElement>> c = this.cloneCache();
        Hashtable<Class<?>, Hashtable<ObjectId, Object>> idc = this.cloneIdCache();
        idc.get(cls).remove(id);
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String key : c.get(cls).keySet()) {
            for (Object el : c.get(cls).get(key).getFound()) {
                ObjectId lid = this.annotationHelper.getId(el);
                if (lid == null) {
                    this.logger.error((Object)"Null id in CACHE?");
                    toRemove.add(key);
                }
                if (lid == null || !lid.equals((Object)id)) continue;
                toRemove.add(key);
            }
        }
        for (String k : toRemove) {
            c.get(cls).remove(k);
        }
        this.setCache(c);
        this.setIdCache(idc);
    }

    @Override
    public void setIdCache(Hashtable<Class<?>, Hashtable<ObjectId, Object>> c) {
        this.idCache = c;
    }
}

