/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire;

import de.bwaldvogel.mongo.backend.MongoBackend;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import de.bwaldvogel.mongo.exception.MongoSilentServerException;
import de.bwaldvogel.mongo.exception.NoSuchCommandException;
import de.bwaldvogel.mongo.wire.MongoWireProtocolHandler;
import de.bwaldvogel.mongo.wire.message.MessageHeader;
import de.bwaldvogel.mongo.wire.message.MongoDelete;
import de.bwaldvogel.mongo.wire.message.MongoInsert;
import de.bwaldvogel.mongo.wire.message.MongoQuery;
import de.bwaldvogel.mongo.wire.message.MongoReply;
import de.bwaldvogel.mongo.wire.message.MongoUpdate;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;

public class MongoDatabaseHandler
extends SimpleChannelUpstreamHandler {
    private final AtomicInteger idSequence = new AtomicInteger();
    private final MongoBackend mongoBackend;
    private static final Logger log = Logger.getLogger(MongoWireProtocolHandler.class);
    private ChannelGroup channelGroup;
    private long started;
    private Date startDate;

    public MongoDatabaseHandler(MongoBackend mongoBackend, ChannelGroup channelGroup) {
        this.mongoBackend = mongoBackend;
        this.channelGroup = channelGroup;
        this.started = System.nanoTime();
        this.startDate = new Date();
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel channel = e.getChannel();
        this.channelGroup.add((Object)channel);
        log.info((Object)("client " + channel + " connected"));
        super.channelClosed(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Channel channel = e.getChannel();
        log.info((Object)("channel " + channel + " closed"));
        this.mongoBackend.handleClose(channel);
        super.channelClosed(ctx, e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) throws MongoServerException {
        Object object = event.getMessage();
        if (object instanceof MongoQuery) {
            event.getChannel().write((Object)this.handleQuery(event.getChannel(), (MongoQuery)object));
        } else if (object instanceof MongoInsert) {
            MongoInsert insert = (MongoInsert)object;
            this.mongoBackend.handleInsert(insert);
        } else if (object instanceof MongoDelete) {
            MongoDelete delete = (MongoDelete)object;
            this.mongoBackend.handleDelete(delete);
        } else if (object instanceof MongoUpdate) {
            MongoUpdate update = (MongoUpdate)object;
            this.mongoBackend.handleUpdate(update);
        } else {
            throw new MongoServerException("unknown message: " + object);
        }
    }

    public Date getStartDate() {
        return this.startDate;
    }

    protected MongoReply handleQuery(Channel channel, MongoQuery query) {
        ArrayList<BSONObject> documents = new ArrayList<BSONObject>();
        MessageHeader header = new MessageHeader(this.idSequence.incrementAndGet(), query.getHeader().getRequestID());
        try {
            if (query.getCollectionName().startsWith("$cmd")) {
                documents.add(this.handleCommand(channel, query, documents));
            } else {
                for (BSONObject obj : this.mongoBackend.handleQuery(query)) {
                    documents.add(obj);
                }
            }
        }
        catch (NoSuchCommandException e) {
            log.error((Object)("unknown command: " + query), (Throwable)e);
            BasicBSONObject obj = new BasicBSONObject();
            obj.put("errmsg", (Object)("no such cmd: " + e.getCommand()));
            obj.put("bad cmd", (Object)query.getQuery());
            obj.put("ok", (Object)0);
            documents.add((BSONObject)obj);
        }
        catch (MongoServerError e) {
            log.error((Object)("failed to handle query " + query), (Throwable)e);
            BasicBSONObject obj = new BasicBSONObject();
            obj.put("errmsg", (Object)e.getMessage());
            obj.put("code", (Object)e.getCode());
            obj.put("ok", (Object)0);
            documents.add((BSONObject)obj);
        }
        catch (MongoSilentServerException e) {
            BasicBSONObject obj = new BasicBSONObject();
            obj.put("errmsg", (Object)e.getMessage());
            obj.put("ok", (Object)0);
            documents.add((BSONObject)obj);
        }
        catch (MongoServerException e) {
            log.error((Object)("failed to handle query " + query), (Throwable)e);
            BasicBSONObject obj = new BasicBSONObject();
            obj.put("errmsg", (Object)e.getMessage());
            obj.put("ok", (Object)0);
            documents.add((BSONObject)obj);
        }
        return new MongoReply(header, documents);
    }

    protected BSONObject handleCommand(Channel channel, MongoQuery query, List<BSONObject> documents) throws MongoServerException {
        String collectionName = query.getCollectionName();
        if (collectionName.equals("$cmd.sys.inprog")) {
            Collection<BSONObject> currentOperations = this.mongoBackend.getCurrentOperations(query);
            return new BasicBSONObject("inprog", currentOperations);
        }
        if (collectionName.equals("$cmd")) {
            String command = (String)query.getQuery().keySet().iterator().next();
            if (command.equals("serverStatus")) {
                return this.getServerStatus();
            }
            return this.mongoBackend.handleCommand(channel, query.getDatabaseName(), command, query.getQuery());
        }
        throw new MongoServerException("unknown collection: " + collectionName);
    }

    private BSONObject getServerStatus() throws MongoServerException {
        BasicBSONObject serverStatus = new BasicBSONObject();
        try {
            serverStatus.put("host", (Object)InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            throw new MongoServerException("failed to get hostname", e);
        }
        serverStatus.put("version", (Object)"0.1");
        serverStatus.put("process", (Object)"java");
        serverStatus.put("pid", (Object)this.getProcessId());
        serverStatus.put("uptime", (Object)((int)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.started)));
        serverStatus.put("uptimeMillis", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.started));
        serverStatus.put("localTime", (Object)new Date());
        BasicBSONObject connections = new BasicBSONObject();
        connections.put("current", (Object)this.channelGroup.size());
        serverStatus.put("connections", (Object)connections);
        BasicBSONObject cursors = new BasicBSONObject();
        cursors.put("totalOpen", (Object)0);
        serverStatus.put("cursors", (Object)cursors);
        Utils.markOkay((BSONObject)serverStatus);
        return serverStatus;
    }

    private Integer getProcessId() {
        String runtimeName = ManagementFactory.getRuntimeMXBean().getName();
        if (runtimeName.contains("@")) {
            return Integer.valueOf(runtimeName.substring(0, runtimeName.indexOf(64)));
        }
        return 0;
    }
}

