/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo;

import de.bwaldvogel.mongo.backend.MongoBackend;
import de.bwaldvogel.mongo.backend.memory.MemoryBackend;
import de.bwaldvogel.mongo.wire.MongoDatabaseHandler;
import de.bwaldvogel.mongo.wire.MongoWireEncoder;
import de.bwaldvogel.mongo.wire.MongoWireProtocolHandler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteOrder;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.HeapChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class MongoServer {
    private static final Logger log = Logger.getLogger(MongoServer.class);
    public static final String VERSION = "0.1";
    private MongoBackend backend;
    private ChannelFactory factory;
    private ChannelGroup channelGroup = new DefaultChannelGroup(this.getClass().getSimpleName());
    private Channel serverChannel;

    public static void main(String[] args) throws Exception {
        final MongoServer mongoServer = new MongoServer();
        mongoServer.bind(new InetSocketAddress(InetAddress.getByAddress(new byte[]{0, 0, 0, 0}), 27017));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.info((Object)("shutting down " + mongoServer));
                mongoServer.shutdownNow();
            }
        });
    }

    public MongoServer() {
        this(new MemoryBackend());
    }

    public MongoServer(MongoBackend backend) {
        this.backend = backend;
    }

    public void bind(SocketAddress socketAddress) {
        this.factory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        ServerBootstrap bootstrap = new ServerBootstrap(this.factory);
        bootstrap.setOption("child.bufferFactory", (Object)new HeapChannelBufferFactory(ByteOrder.LITTLE_ENDIAN));
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new MongoWireEncoder(), new MongoWireProtocolHandler(), new MongoDatabaseHandler(MongoServer.this.backend, MongoServer.this.channelGroup)});
            }
        });
        try {
            this.serverChannel = bootstrap.bind(socketAddress);
            log.info((Object)("started " + this));
        }
        catch (RuntimeException e) {
            this.shutdownNow();
            throw e;
        }
    }

    public InetSocketAddress bind() {
        this.bind(new InetSocketAddress("localhost", 0));
        return this.getLocalAddress();
    }

    protected InetSocketAddress getLocalAddress() {
        if (this.serverChannel == null) {
            return null;
        }
        return (InetSocketAddress)this.serverChannel.getLocalAddress();
    }

    public void shutdown() {
        if (this.serverChannel != null) {
            this.serverChannel.close().awaitUninterruptibly();
            this.serverChannel = null;
        }
        if (this.factory != null) {
            this.factory.releaseExternalResources();
            this.factory = null;
        }
        log.info((Object)("completed shutdown of " + this));
    }

    public void shutdownNow() {
        this.shutdown();
        this.closeClients();
    }

    private void closeClients() {
        if (!this.channelGroup.isEmpty()) {
            log.warn((Object)(this.channelGroup.size() + " channels still open. closing now..."));
            this.channelGroup.close().awaitUninterruptibly();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("(");
        InetSocketAddress socketAddress = this.getLocalAddress();
        if (socketAddress != null) {
            sb.append("port: ").append(socketAddress.getPort());
        }
        sb.append(")");
        return sb.toString();
    }
}

