/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire;

import de.bwaldvogel.mongo.wire.OpCode;
import de.bwaldvogel.mongo.wire.message.MongoReply;
import java.nio.ByteOrder;
import java.util.List;
import org.apache.log4j.Logger;
import org.bson.BSON;
import org.bson.BSONObject;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

public class MongoWireEncoder
extends OneToOneEncoder {
    private static final Logger _log = Logger.getLogger(MongoWireEncoder.class);

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer((ByteOrder)ByteOrder.LITTLE_ENDIAN, (int)32);
        buffer.writeInt(0);
        MongoReply reply = (MongoReply)msg;
        buffer.writeInt(reply.getHeader().getRequestID());
        buffer.writeInt(reply.getHeader().getResponseTo());
        buffer.writeInt(OpCode.OP_REPLY.getId());
        buffer.writeInt(reply.getFlags());
        buffer.writeLong(reply.getCursorId());
        buffer.writeInt(reply.getStartingFrom());
        List<BSONObject> documents = reply.getDocuments();
        buffer.writeInt(documents.size());
        for (BSONObject bsonObject : documents) {
            buffer.writeBytes(BSON.encode((BSONObject)bsonObject));
        }
        _log.debug((Object)("wrote reply: " + reply));
        int writerIndex = buffer.writerIndex();
        buffer.setInt(0, writerIndex);
        return buffer;
    }
}

