/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.ValueComparator;
import java.util.Comparator;
import org.bson.BSONObject;

public class DocumentComparator
implements Comparator<BSONObject> {
    private ValueComparator valueComparator = new ValueComparator();
    private BSONObject orderBy;

    public DocumentComparator(BSONObject orderBy) {
        if (orderBy == null || orderBy.keySet().isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.orderBy = orderBy;
    }

    public static Object getSubdocumentValue(BSONObject document, String key) {
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = key.substring(dotPos + 1);
            if (subKey.startsWith("$.")) {
                throw new IllegalArgumentException();
            }
            Object subObject = Utils.getListSafe(document, mainKey);
            if (subObject instanceof BSONObject) {
                return DocumentComparator.getSubdocumentValue((BSONObject)subObject, subKey);
            }
            return null;
        }
        return Utils.getListSafe(document, key);
    }

    @Override
    public int compare(BSONObject document1, BSONObject document2) {
        for (String sortKey : this.orderBy.keySet()) {
            Object value2;
            Object value1 = Utils.getSubdocumentValue(document1, sortKey);
            int cmp = this.valueComparator.compare(value1, value2 = Utils.getSubdocumentValue(document2, sortKey));
            if (cmp == 0) continue;
            if (((Number)this.orderBy.get(sortKey)).intValue() < 0) {
                cmp = -cmp;
            }
            return cmp;
        }
        return 0;
    }
}

