/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import de.bwaldvogel.mongo.wire.BsonEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class Utils {
    public static Number addNumbers(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() + b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(a.floatValue() + b.floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() + b.longValue();
        }
        if (a instanceof Integer || b instanceof Integer) {
            return a.intValue() + b.intValue();
        }
        if (a instanceof Short || b instanceof Short) {
            return (short)(a.shortValue() + b.shortValue());
        }
        throw new UnsupportedOperationException("cannot add " + a + " and " + b);
    }

    public static Number subtractNumbers(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() - b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(a.floatValue() - b.floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() - b.longValue();
        }
        if (a instanceof Integer || b instanceof Integer) {
            return a.intValue() - b.intValue();
        }
        if (a instanceof Short || b instanceof Short) {
            return (short)(a.shortValue() - b.shortValue());
        }
        throw new UnsupportedOperationException("cannot subtract " + a + " and " + b);
    }

    static Number multiplyNumbers(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() * b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(a.floatValue() * b.floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() * b.longValue();
        }
        if (a instanceof Integer || b instanceof Integer) {
            return a.intValue() * b.intValue();
        }
        if (a instanceof Short || b instanceof Short) {
            return (short)(a.shortValue() * b.shortValue());
        }
        throw new UnsupportedOperationException("can not multiply " + a + " and " + b);
    }

    public static Object getSubdocumentValue(Document document, String key) {
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = key.substring(dotPos + 1);
            if (subKey.startsWith("$.")) {
                throw new IllegalArgumentException();
            }
            Object subObject = Utils.getFieldValueListSafe(document, mainKey);
            if (subObject instanceof Document) {
                return Utils.getSubdocumentValue((Document)subObject, subKey);
            }
            return null;
        }
        return Utils.getFieldValueListSafe(document, key);
    }

    public static String getDatabaseNameFromFullName(String fullName) {
        int dotPos = fullName.indexOf(46);
        return fullName.substring(0, dotPos);
    }

    public static String getCollectionNameFromFullName(String fullName) {
        int dotPos = fullName.indexOf(46);
        return fullName.substring(dotPos + 1);
    }

    public static boolean isTrue(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() != 0.0;
        }
        return true;
    }

    static Object normalizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return value;
    }

    static boolean nullAwareEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            byte[] bytesA = (byte[])a;
            byte[] bytesB = (byte[])b;
            return Arrays.equals(bytesA, bytesB);
        }
        Object normalizedA = Utils.normalizeValue(a);
        Object normalizedB = Utils.normalizeValue(b);
        return normalizedA.equals(normalizedB);
    }

    static long calculateSize(Document document) {
        ByteBuf buffer = Unpooled.buffer();
        try {
            new BsonEncoder().encodeDocument(document, buffer);
            long l = buffer.writerIndex();
            return l;
        }
        catch (IOException e) {
            throw new MongoServerException("Failed to calculate document size", e);
        }
        finally {
            buffer.release();
        }
    }

    static boolean containsQueryExpression(Object value) {
        if (value == null) {
            return false;
        }
        if (!(value instanceof Document)) {
            return false;
        }
        Document doc = (Document)value;
        for (String key : doc.keySet()) {
            if (key.startsWith("$")) {
                return true;
            }
            if (!Utils.containsQueryExpression(doc.get(key))) continue;
            return true;
        }
        return false;
    }

    static Object getFieldValueListSafe(Object document, String field) throws IllegalArgumentException {
        if (document == null) {
            return null;
        }
        if (field.equals("$") || field.contains(".")) {
            throw new IllegalArgumentException("illegal field: " + field);
        }
        if (document instanceof List) {
            if (field.matches("\\d+")) {
                int pos = Integer.parseInt(field);
                List list = (List)document;
                if (pos >= 0 && pos < list.size()) {
                    return list.get(pos);
                }
                return null;
            }
            throw new IllegalArgumentException("illegal field: " + field);
        }
        if (document instanceof Document) {
            return ((Document)document).get(field);
        }
        throw new IllegalArgumentException("illegal document: " + document);
    }

    static boolean hasSubdocumentValue(Object document, String key) {
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = Utils.getSubkey(key, dotPos, new AtomicReference<Integer>());
            Object subObject = Utils.getFieldValueListSafe(document, mainKey);
            if (subObject instanceof Document || subObject instanceof List) {
                return Utils.hasSubdocumentValue(subObject, subKey);
            }
            return false;
        }
        return Utils.hasFieldValueListSafe(document, key);
    }

    static String getSubkey(String key, int dotPos, AtomicReference<Integer> matchPos) {
        String subKey = key.substring(dotPos + 1);
        if (subKey.matches("\\$(\\..+)?")) {
            if (matchPos == null || matchPos.get() == null) {
                throw new MongoServerError(16650, "Cannot apply the positional operator without a corresponding query field containing an array.");
            }
            Integer pos = matchPos.getAndSet(null);
            return subKey.replaceFirst("\\$", String.valueOf(pos));
        }
        return subKey;
    }

    static boolean hasFieldValueListSafe(Object document, String field) throws IllegalArgumentException {
        if (document == null) {
            return false;
        }
        if (field.equals("$") || field.contains(".")) {
            throw new IllegalArgumentException("illegal field: " + field);
        }
        if (document instanceof List) {
            if (field.matches("\\d+")) {
                int pos = Integer.parseInt(field);
                List list = (List)document;
                return pos >= 0 && pos < list.size();
            }
            throw new IllegalArgumentException("illegal field: " + field);
        }
        if (document instanceof Document) {
            return ((Document)document).containsKey(field);
        }
        throw new IllegalArgumentException("illegal document: " + document);
    }

    public static void markOkay(Document result) {
        result.put("ok", (Object)1);
    }

    static void setListSafe(Object document, String key, Object obj) {
        if (document instanceof List) {
            int pos = Integer.parseInt(key);
            List list = (List)document;
            while (list.size() <= pos) {
                list.add(null);
            }
            list.set(pos, obj);
        } else {
            ((Document)document).put(key, obj);
        }
    }

    static Object removeListSafe(Object document, String key) {
        if (document instanceof Document) {
            return ((Document)document).remove(key);
        }
        if (document instanceof List) {
            int pos = Integer.parseInt(key);
            List list = (List)document;
            if (list.size() > pos) {
                return list.set(pos, null);
            }
            return null;
        }
        throw new IllegalArgumentException();
    }

    public static String join(List<Integer> array, char c) {
        StringBuilder sb = new StringBuilder();
        for (int value : array) {
            if (sb.length() > 0) {
                sb.append(c);
            }
            sb.append(Integer.toString(value));
        }
        return sb.toString();
    }
}

