/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.backend.aggregation.Accumulator;
import de.bwaldvogel.mongo.backend.aggregation.SimpleSumAccumulation;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Aggregation {
    private static final String ID_FIELD = "_id";
    private final MongoCollection<?> collection;
    private Iterable<Document> documents = null;

    public Aggregation(MongoCollection<?> collection) {
        this.collection = collection;
    }

    private Iterable<Document> getDocuments() throws MongoServerException {
        if (this.documents != null) {
            return this.documents;
        }
        if (this.collection == null) {
            return Collections.emptyList();
        }
        return this.collection.queryAll();
    }

    public void match(Document query) throws MongoServerException {
        if (this.documents != null) {
            throw new MongoServerException("Not yet implemented");
        }
        this.documents = this.collection == null ? Collections.emptyList() : this.collection.handleQuery(query);
    }

    public void skip(Number skip) throws MongoServerException {
        int numSkip = skip.intValue();
        if (!(this.getDocuments() instanceof List)) {
            throw new MongoServerException("Not yet implemented");
        }
        List documents = (List)this.getDocuments();
        numSkip = Math.min(documents.size(), numSkip);
        this.documents = documents.subList(numSkip, documents.size());
    }

    public void limit(Number limit) throws MongoServerException {
        int numLimit = limit.intValue();
        if (!(this.documents instanceof List)) {
            throw new MongoServerException("Not yet implemented");
        }
        List documents = (List)this.documents;
        numLimit = Math.min(documents.size(), numLimit);
        this.documents = documents.subList(0, numLimit);
    }

    public void group(Document groupQuery) throws MongoServerException {
        Document groupResult = new Document();
        String id = (String)groupQuery.get(ID_FIELD);
        groupResult.put(ID_FIELD, (Object)id);
        if (id != null) {
            throw new MongoServerException("Not yet implemented");
        }
        List<Accumulator> accumulators = this.parseAccumulators(groupQuery);
        for (Accumulator accumulator : accumulators) {
            accumulator.initialize(groupResult);
        }
        for (Document document : this.getDocuments()) {
            for (Accumulator accumulator : accumulators) {
                accumulator.aggregate(groupResult, document);
            }
        }
        this.documents = Collections.singletonList(groupResult);
    }

    private List<Accumulator> parseAccumulators(Document groupStage) throws MongoServerException {
        ArrayList<Accumulator> accumulators = new ArrayList<Accumulator>();
        for (Map.Entry<String, Object> aggregationEntry : groupStage.entrySet()) {
            if (aggregationEntry.getKey().equals(ID_FIELD)) continue;
            String key = aggregationEntry.getKey();
            Document entryValue = (Document)aggregationEntry.getValue();
            if (entryValue.size() != 1) {
                throw new MongoServerException("Not yet implemented");
            }
            Map.Entry<String, Object> aggregation = entryValue.entrySet().iterator().next();
            if (!aggregation.getKey().equals("$sum")) continue;
            if (aggregation.getValue().equals(1)) {
                accumulators.add(new SimpleSumAccumulation(key));
                continue;
            }
            throw new MongoServerException("Not yet implemented");
        }
        return accumulators;
    }

    public Iterable<Document> getResult() throws MongoServerException {
        return this.getDocuments();
    }
}

