/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo;

import de.bwaldvogel.mongo.backend.Index;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerException;
import java.util.List;

public interface MongoCollection<P> {
    public String getDatabaseName();

    public String getFullName();

    public String getCollectionName();

    public void addIndex(Index<P> var1);

    public void addDocument(Document var1) throws MongoServerException;

    public void removeDocument(Document var1) throws MongoServerException;

    default public Iterable<Document> queryAll() throws MongoServerException {
        return this.handleQuery(new Document());
    }

    default public Iterable<Document> handleQuery(Document query) throws MongoServerException {
        return this.handleQuery(query, 0, 0);
    }

    default public Iterable<Document> handleQuery(Document query, int numberToSkip, int numberToReturn) throws MongoServerException {
        return this.handleQuery(query, numberToSkip, numberToReturn, null);
    }

    public Iterable<Document> handleQuery(Document var1, int var2, int var3, Document var4) throws MongoServerException;

    public int insertDocuments(List<Document> var1) throws MongoServerException;

    public Document updateDocuments(Document var1, Document var2, boolean var3, boolean var4) throws MongoServerException;

    public int deleteDocuments(Document var1, int var2) throws MongoServerException;

    public Document handleDistinct(Document var1) throws MongoServerException;

    public Document getStats() throws MongoServerException;

    public Document validate() throws MongoServerException;

    public Document findAndModify(Document var1) throws MongoServerException;

    public int count(Document var1, int var2, int var3) throws MongoServerException;

    public int count() throws MongoServerException;

    public int getNumIndexes();

    public void drop() throws MongoServerException;

    public void renameTo(String var1, String var2) throws MongoServerException;
}

