/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import com.mongodb.DefaultDBEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.bson.BSONObject;

public class Utils {
    public static Number addNumbers(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() + b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(a.floatValue() + b.floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() + b.longValue();
        }
        if (a instanceof Integer || b instanceof Integer) {
            return a.intValue() + b.intValue();
        }
        if (a instanceof Short || b instanceof Short) {
            return (short)(a.shortValue() + b.shortValue());
        }
        throw new UnsupportedOperationException("can not add " + a + " and " + b);
    }

    public static Number multiplyNumbers(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() * b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(a.floatValue() * b.floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() * b.longValue();
        }
        if (a instanceof Integer || b instanceof Integer) {
            return a.intValue() * b.intValue();
        }
        if (a instanceof Short || b instanceof Short) {
            return (short)(a.shortValue() * b.shortValue());
        }
        throw new UnsupportedOperationException("can not multiply " + a + " and " + b);
    }

    public static Object getSubdocumentValue(BSONObject document, String key) {
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = key.substring(dotPos + 1);
            Object subObject = Utils.getFieldValueListSafe(document, mainKey);
            if (subObject instanceof BSONObject) {
                return Utils.getSubdocumentValue((BSONObject)subObject, subKey);
            }
            return null;
        }
        return Utils.getFieldValueListSafe(document, key);
    }

    public static String getDatabaseNameFromFullName(String fullName) {
        int dotPos = fullName.indexOf(46);
        return fullName.substring(0, dotPos);
    }

    public static String getCollectionNameFromFullName(String fullName) {
        int dotPos = fullName.indexOf(46);
        return fullName.substring(dotPos + 1);
    }

    public static boolean isTrue(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() != 0.0;
        }
        return true;
    }

    public static Object normalizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return value;
    }

    public static boolean nullAwareEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return a == b;
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            byte[] bytesA = (byte[])a;
            byte[] bytesB = (byte[])b;
            return Arrays.equals(bytesA, bytesB);
        }
        Object normalizedA = Utils.normalizeValue(a);
        Object normalizedB = Utils.normalizeValue(b);
        return normalizedA.equals(normalizedB);
    }

    public static long calculateSize(BSONObject document) {
        return new DefaultDBEncoder().encode(document).length;
    }

    public static List<Object> asList(Object value) {
        return (List)value;
    }

    public static boolean containsQueryExpression(Object value) {
        if (value == null) {
            return false;
        }
        if (!(value instanceof BSONObject)) {
            return false;
        }
        BSONObject doc = (BSONObject)value;
        for (String key : doc.keySet()) {
            if (key.startsWith("$")) {
                return true;
            }
            if (!Utils.containsQueryExpression(doc.get(key))) continue;
            return true;
        }
        return false;
    }

    public static Object getFieldValueListSafe(Object document, String field) throws IllegalArgumentException {
        if (document == null) {
            return null;
        }
        if (field.equals("$") || field.contains(".")) {
            throw new IllegalArgumentException("illegal field: " + field);
        }
        if (document instanceof List) {
            if (field.matches("\\d+")) {
                int pos = Integer.parseInt(field);
                List list = (List)document;
                if (pos >= 0 && pos < list.size()) {
                    return list.get(pos);
                }
                return null;
            }
            throw new IllegalArgumentException("illegal field: " + field);
        }
        if (document instanceof BSONObject) {
            return ((BSONObject)document).get(field);
        }
        throw new IllegalArgumentException("illegal document: " + document);
    }

    public static boolean hasFieldValueListSafe(Object document, String field) throws IllegalArgumentException {
        if (document == null) {
            return false;
        }
        if (field.equals("$") || field.contains(".")) {
            throw new IllegalArgumentException("illegal field: " + field);
        }
        if (document instanceof List) {
            if (field.matches("\\d+")) {
                int pos = Integer.parseInt(field);
                List list = (List)document;
                return pos >= 0 && pos < list.size();
            }
            throw new IllegalArgumentException("illegal field: " + field);
        }
        if (document instanceof BSONObject) {
            return ((BSONObject)document).containsField(field);
        }
        throw new IllegalArgumentException("illegal document: " + document);
    }

    public static void markOkay(BSONObject result) {
        result.put("ok", (Object)1);
    }

    public static Pattern createPattern(String regex, String options) {
        int flags = 0;
        block7: for (char flag : options.toCharArray()) {
            switch (flag) {
                case 'i': {
                    flags |= 2;
                    continue block7;
                }
                case 'm': {
                    flags |= 8;
                    continue block7;
                }
                case 'x': {
                    flags |= 4;
                    continue block7;
                }
                case 's': {
                    flags |= 0x20;
                    continue block7;
                }
                case 'u': {
                    flags |= 0x40;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("unknown pattern flag: '" + flag + "'");
                }
            }
        }
        return Pattern.compile(regex, flags |= 0x40);
    }

    public static void setListSafe(Object document, String key, Object obj) {
        if (document instanceof List) {
            int pos = Integer.parseInt(key);
            List list = (List)document;
            while (list.size() <= pos) {
                list.add(null);
            }
            list.set(pos, obj);
        } else {
            ((BSONObject)document).put(key, obj);
        }
    }

    public static Object removeListSafe(Object document, String key) {
        if (document instanceof BSONObject) {
            return ((BSONObject)document).removeField(key);
        }
        if (document instanceof List) {
            int pos = Integer.parseInt(key);
            List list = (List)document;
            if (list.size() > pos) {
                return list.set(pos, null);
            }
            return null;
        }
        throw new IllegalArgumentException();
    }

    public static String join(int[] array, char c) {
        StringBuilder sb = new StringBuilder();
        for (int value : array) {
            if (sb.length() > 0) {
                sb.append(c);
            }
            sb.append(Integer.toString(value));
        }
        return sb.toString();
    }
}

