/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.backend.DefaultQueryMatcher;
import de.bwaldvogel.mongo.backend.Index;
import de.bwaldvogel.mongo.backend.QueryMatcher;
import de.bwaldvogel.mongo.backend.UpdateOperator;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BSONTimestamp;
import org.bson.types.ObjectId;

public abstract class AbstractMongoCollection<KEY>
implements MongoCollection<KEY> {
    private String collectionName;
    private String databaseName;
    private List<Index<KEY>> indexes = new ArrayList<Index<KEY>>();
    private QueryMatcher matcher = new DefaultQueryMatcher();
    protected final String idField;

    protected AbstractMongoCollection(String databaseName, String collectionName, String idField) {
        this.databaseName = databaseName;
        this.collectionName = collectionName;
        this.idField = idField;
    }

    protected boolean documentMatchesQuery(BSONObject document, BSONObject query) throws MongoServerException {
        return this.matcher.matches(document, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterable<BSONObject> queryDocuments(BSONObject query, BSONObject orderBy, int numberToSkip, int numberToReturn) throws MongoServerException {
        List<Index<KEY>> list = this.indexes;
        synchronized (list) {
            for (Index<KEY> index : this.indexes) {
                if (!index.canHandle(query)) continue;
                Iterable<KEY> keys = index.getKeys(query);
                return this.matchDocuments(query, keys, orderBy, numberToSkip, numberToReturn);
            }
        }
        return this.matchDocuments(query, orderBy, numberToSkip, numberToReturn);
    }

    protected abstract Iterable<BSONObject> matchDocuments(BSONObject var1, BSONObject var2, int var3, int var4) throws MongoServerException;

    protected abstract Iterable<BSONObject> matchDocuments(BSONObject var1, Iterable<KEY> var2, BSONObject var3, int var4, int var5) throws MongoServerException;

    protected abstract BSONObject getDocument(KEY var1);

    protected abstract void updateDataSize(long var1);

    protected abstract long getDataSize();

    protected abstract KEY addDocumentInternal(BSONObject var1);

    @Override
    public synchronized void addDocument(BSONObject document) throws MongoServerException {
        for (Index<KEY> index : this.indexes) {
            index.checkAdd(document);
        }
        KEY pos = this.addDocumentInternal(document);
        for (Index<KEY> index : this.indexes) {
            index.add(document, pos);
        }
        this.updateDataSize(Utils.calculateSize(document));
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public String getFullName() {
        return this.getDatabaseName() + "." + this.getCollectionName();
    }

    @Override
    public String getCollectionName() {
        return this.collectionName;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getFullName() + ")";
    }

    @Override
    public void addIndex(Index<KEY> index) {
        this.indexes.add(index);
    }

    private void assertNotKeyField(String key) throws MongoServerError {
        if (key.equals(this.idField)) {
            throw new MongoServerError(10148, "Mod on " + this.idField + " not allowed");
        }
    }

    private void changeSubdocumentValue(Object document, String key, Object newValue, Integer matchPos) throws MongoServerException {
        this.changeSubdocumentValue(document, key, newValue, new AtomicReference<Integer>(matchPos));
    }

    void changeSubdocumentValue(Object document, String key, Object newValue, AtomicReference<Integer> matchPos) throws MongoServerException {
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = this.getSubkey(key, dotPos, matchPos);
            Object subObject = Utils.getFieldValueListSafe(document, mainKey);
            if (subObject instanceof BSONObject || subObject instanceof List) {
                this.changeSubdocumentValue(subObject, subKey, newValue, matchPos);
            } else {
                BasicBSONObject obj = new BasicBSONObject();
                this.changeSubdocumentValue((Object)obj, subKey, newValue, matchPos);
                Utils.setListSafe(document, mainKey, obj);
            }
        } else {
            Utils.setListSafe(document, key, newValue);
        }
    }

    private String getSubkey(String key, int dotPos, AtomicReference<Integer> matchPos) throws MongoServerError {
        String subKey = key.substring(dotPos + 1);
        if (subKey.matches("\\$(\\..+)?")) {
            if (matchPos == null || matchPos.get() == null) {
                throw new MongoServerError(16650, "Cannot apply the positional operator without a corresponding query field containing an array.");
            }
            Integer pos = matchPos.getAndSet(null);
            return subKey.replaceFirst("\\$", String.valueOf(pos));
        }
        return subKey;
    }

    private Object removeSubdocumentValue(Object document, String key, Integer matchPos) throws MongoServerException {
        return this.removeSubdocumentValue(document, key, new AtomicReference<Integer>(matchPos));
    }

    private Object removeSubdocumentValue(Object document, String key, AtomicReference<Integer> matchPos) throws MongoServerException {
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = this.getSubkey(key, dotPos, matchPos);
            Object subObject = Utils.getFieldValueListSafe(document, mainKey);
            if (subObject instanceof BSONObject || subObject instanceof List) {
                return this.removeSubdocumentValue(subObject, subKey, matchPos);
            }
            throw new MongoServerException("failed to remove subdocument");
        }
        return Utils.removeListSafe(document, key);
    }

    private Object getSubdocumentValue(Object document, String key, Integer matchPos) throws MongoServerException {
        return this.getSubdocumentValue(document, key, new AtomicReference<Integer>(matchPos));
    }

    private Object getSubdocumentValue(Object document, String key, AtomicReference<Integer> matchPos) throws MongoServerException {
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = this.getSubkey(key, dotPos, matchPos);
            Object subObject = Utils.getFieldValueListSafe(document, mainKey);
            if (subObject instanceof BSONObject || subObject instanceof List) {
                return this.getSubdocumentValue(subObject, subKey, matchPos);
            }
            return null;
        }
        return Utils.getFieldValueListSafe(document, key);
    }

    private boolean hasSubdocumentValue(Object document, String key) throws MongoServerException {
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = this.getSubkey(key, dotPos, new AtomicReference<Integer>());
            Object subObject = Utils.getFieldValueListSafe(document, mainKey);
            if (subObject instanceof BSONObject || subObject instanceof List) {
                return this.hasSubdocumentValue(subObject, subKey);
            }
            return false;
        }
        return Utils.hasFieldValueListSafe(document, key);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void modifyField(BSONObject document, String modifier, BSONObject change, Integer matchPos, boolean isUpsert) throws MongoServerException {
        UpdateOperator op;
        try {
            op = UpdateOperator.fromValue(modifier);
        }
        catch (IllegalArgumentException e) {
            throw new MongoServerError(10147, "Invalid modifier specified: " + modifier);
        }
        if (op != UpdateOperator.UNSET) {
            for (Object key : change.keySet()) {
                if (!((String)key).startsWith("$")) continue;
                throw new MongoServerError(15896, "Modified field name may not start with $");
            }
        }
        switch (op) {
            case SET_ON_INSERT: {
                if (!isUpsert) {
                    return;
                }
            }
            case SET: {
                for (Object key : change.keySet()) {
                    Object object;
                    Object newValue = change.get((String)key);
                    if (Utils.nullAwareEquals(newValue, object = this.getSubdocumentValue((Object)document, (String)key, matchPos))) continue;
                    this.assertNotKeyField((String)key);
                    this.changeSubdocumentValue((Object)document, (String)key, newValue, matchPos);
                }
                return;
            }
            case UNSET: {
                for (Object key : change.keySet()) {
                    this.assertNotKeyField((String)key);
                    this.removeSubdocumentValue((Object)document, (String)key, matchPos);
                }
                return;
            }
            case PUSH: 
            case PUSH_ALL: 
            case ADD_TO_SET: {
                this.updatePushAllAddToSet(document, op, change, matchPos);
                return;
            }
            case PULL: 
            case PULL_ALL: {
                for (Object key : change.keySet()) {
                    Object value = this.getSubdocumentValue((Object)document, (String)key, matchPos);
                    if (value == null) {
                        return;
                    }
                    if (!(value instanceof List)) {
                        throw new MongoServerError(10142, "Cannot apply " + modifier + " modifier to non-array");
                    }
                    List<Object> list = Utils.asList(value);
                    Object object = change.get((String)key);
                    if (modifier.equals("$pullAll")) {
                        if (!(object instanceof Collection)) {
                            throw new MongoServerError(10153, "Modifier " + modifier + " allowed for arrays only");
                        }
                        Collection valueList = (Collection)object;
                        while (list.removeAll(valueList)) {
                        }
                        continue;
                    }
                    while (list.remove(object)) {
                    }
                }
                return;
            }
            case POP: {
                for (Object key : change.keySet()) {
                    Object value = this.getSubdocumentValue((Object)document, (String)key, matchPos);
                    if (value == null) {
                        return;
                    }
                    if (!(value instanceof List)) {
                        throw new MongoServerError(10143, "Cannot apply " + modifier + " modifier to non-array");
                    }
                    List<Object> list = Utils.asList(value);
                    Object object = change.get((String)key);
                    if (list.isEmpty()) continue;
                    if (object != null && Utils.normalizeValue(object).equals(-1.0)) {
                        list.remove(0);
                        continue;
                    }
                    list.remove(list.size() - 1);
                }
                return;
            }
            case INC: 
            case MUL: {
                for (Object key : change.keySet()) {
                    Number newValue;
                    void var11_28;
                    this.assertNotKeyField((String)key);
                    String operation = op == UpdateOperator.INC ? "increment" : "multiply";
                    Object object = this.getSubdocumentValue((Object)document, (String)key, matchPos);
                    if (object == null) {
                        Integer n = 0;
                    } else {
                        if (!(object instanceof Number)) throw new MongoServerException("cannot " + operation + " value '" + object + "'");
                        Number number = (Number)object;
                    }
                    Object changeObject = change.get((String)key);
                    if (!(changeObject instanceof Number)) {
                        throw new MongoServerException("cannot " + operation + " with non-numeric value: " + change);
                    }
                    Number changeValue = (Number)changeObject;
                    if (op == UpdateOperator.INC) {
                        newValue = Utils.addNumbers((Number)var11_28, changeValue);
                    } else {
                        if (op != UpdateOperator.MUL) throw new RuntimeException();
                        newValue = Utils.multiplyNumbers((Number)var11_28, changeValue);
                    }
                    this.changeSubdocumentValue((Object)document, (String)key, (Object)newValue, matchPos);
                }
                return;
            }
            case MIN: 
            case MAX: {
                ValueComparator comparator = new ValueComparator();
                for (String key : change.keySet()) {
                    boolean shouldChange;
                    this.assertNotKeyField(key);
                    Object object = change.get(key);
                    Object object2 = this.getSubdocumentValue((Object)document, key, matchPos);
                    int valueComparison = comparator.compare(object, object2);
                    if (object2 == null && !this.hasSubdocumentValue(document, key)) {
                        shouldChange = true;
                    } else if (op == UpdateOperator.MAX) {
                        shouldChange = valueComparison > 0;
                    } else {
                        if (op != UpdateOperator.MIN) throw new RuntimeException();
                        shouldChange = valueComparison < 0;
                    }
                    if (!shouldChange) continue;
                    this.changeSubdocumentValue((Object)document, key, object, matchPos);
                }
                return;
            }
            case CURRENT_DATE: {
                for (String key : change.keySet()) {
                    Date newValue;
                    Object type;
                    boolean bl;
                    this.assertNotKeyField(key);
                    Object object = change.get(key);
                    if (object instanceof Boolean && Utils.isTrue(object)) {
                        bl = true;
                    } else if (object instanceof BSONObject) {
                        type = ((BSONObject)object).get("$type");
                        if (type.equals("timestamp")) {
                            bl = false;
                        } else {
                            if (!type.equals("date")) throw new MongoServerError(2, "The '$type' string field is required to be 'date' or 'timestamp': " + change);
                            bl = true;
                        }
                    } else {
                        type = object != null ? object.getClass().getSimpleName() : "NULL";
                        throw new MongoServerError(2, (String)type + " is not a valid type for $currentDate." + " Please use a boolean ('true') or a $type expression ({$type: 'timestamp/date'})");
                    }
                    if (bl) {
                        newValue = new Date();
                    } else {
                        int time = (int)(System.currentTimeMillis() / 1000L);
                        newValue = new BSONTimestamp(time, 1);
                    }
                    this.changeSubdocumentValue((Object)document, key, (Object)newValue, matchPos);
                }
                return;
            }
            case RENAME: {
                LinkedHashMap<String, String> renames = new LinkedHashMap<String, String>();
                for (String string : change.keySet()) {
                    this.assertNotKeyField(string);
                    Object object = change.get(string);
                    if (!(object instanceof String)) {
                        throw new MongoServerError(2, "The 'to' field for $rename must be a string: " + object);
                    }
                    String newKey = (String)object;
                    this.assertNotKeyField(newKey);
                    if (renames.containsKey(string) || renames.containsValue(string)) {
                        throw new MongoServerError(16837, "Cannot update '" + string + "' and '" + string + "' at the same time");
                    }
                    if (renames.containsKey(newKey) || renames.containsValue(newKey)) {
                        throw new MongoServerError(16837, "Cannot update '" + newKey + "' and '" + newKey + "' at the same time");
                    }
                    renames.put(string, newKey);
                }
                for (Map.Entry entry : renames.entrySet()) {
                    Object object = this.removeSubdocumentValue((Object)document, (String)entry.getKey(), matchPos);
                    this.changeSubdocumentValue((Object)document, (String)entry.getValue(), object, matchPos);
                }
                return;
            }
            default: {
                throw new MongoServerError(10147, "Unsupported modifier: " + modifier);
            }
        }
    }

    private void updatePushAllAddToSet(BSONObject document, UpdateOperator updateOperator, BSONObject change, Integer matchPos) throws MongoServerException {
        for (String key : change.keySet()) {
            List<Object> list;
            Object value = this.getSubdocumentValue((Object)document, key, matchPos);
            if (value == null) {
                list = new ArrayList();
            } else if (value instanceof List) {
                list = Utils.asList(value);
            } else {
                throw new MongoServerError(10141, "Cannot apply " + (Object)((Object)updateOperator) + " modifier to non-array");
            }
            Object changeValue = change.get(key);
            if (updateOperator == UpdateOperator.PUSH_ALL) {
                if (!(changeValue instanceof Collection)) {
                    throw new MongoServerError(10153, "Modifier " + (Object)((Object)updateOperator) + " allowed for arrays only");
                }
                Collection valueList = (Collection)changeValue;
                list.addAll(valueList);
            } else {
                ArrayList<Object> pushValues = new ArrayList<Object>();
                if (changeValue instanceof BSONObject && ((BSONObject)changeValue).keySet().equals(Collections.singleton("$each"))) {
                    Collection values = (Collection)((BSONObject)changeValue).get("$each");
                    pushValues.addAll(values);
                } else {
                    pushValues.add(changeValue);
                }
                for (Object e : pushValues) {
                    if (updateOperator == UpdateOperator.PUSH) {
                        list.add(e);
                        continue;
                    }
                    if (updateOperator == UpdateOperator.ADD_TO_SET) {
                        if (list.contains(e)) continue;
                        list.add(e);
                        continue;
                    }
                    throw new MongoServerException("internal server error. illegal modifier here: " + (Object)((Object)updateOperator));
                }
            }
            this.changeSubdocumentValue((Object)document, key, list, matchPos);
        }
    }

    private void applyUpdate(BSONObject oldDocument, BSONObject newDocument) throws MongoServerException {
        if (newDocument.equals(oldDocument)) {
            return;
        }
        Object oldId = oldDocument.get(this.idField);
        Object newId = newDocument.get(this.idField);
        if (newId != null && !Utils.nullAwareEquals(oldId, newId)) {
            oldId = new BasicBSONObject(this.idField, oldId);
            newId = new BasicBSONObject(this.idField, newId);
            throw new MongoServerError(13596, "cannot change _id of a document old:" + oldId + " new:" + newId);
        }
        if (newId == null && oldId != null) {
            newDocument.put(this.idField, oldId);
        }
        this.cloneInto(oldDocument, newDocument);
    }

    Object deriveDocumentId(BSONObject selector) {
        Object value = selector.get(this.idField);
        if (value != null) {
            if (!Utils.containsQueryExpression(value)) {
                return value;
            }
            return this.deriveIdFromExpression(value);
        }
        return new ObjectId();
    }

    private Object deriveIdFromExpression(Object value) {
        BSONObject expression = (BSONObject)value;
        for (String key : expression.keySet()) {
            Collection list;
            Object expressionValue = expression.get(key);
            if (!key.equals("$in") || (list = (Collection)expressionValue).isEmpty()) continue;
            return list.iterator().next();
        }
        return new ObjectId();
    }

    private BSONObject calculateUpdateDocument(BSONObject oldDocument, BSONObject update, Integer matchPos, boolean isUpsert) throws MongoServerException {
        int numStartsWithDollar = 0;
        for (String key : update.keySet()) {
            if (!key.startsWith("$")) continue;
            ++numStartsWithDollar;
        }
        BasicBSONObject newDocument = new BasicBSONObject(this.idField, oldDocument.get(this.idField));
        if (numStartsWithDollar == update.keySet().size()) {
            this.cloneInto((BSONObject)newDocument, oldDocument);
            for (String key : update.keySet()) {
                this.modifyField((BSONObject)newDocument, key, (BSONObject)update.get(key), matchPos, isUpsert);
            }
        } else if (numStartsWithDollar == 0) {
            this.applyUpdate((BSONObject)newDocument, update);
        } else {
            throw new MongoServerException("illegal update: " + update);
        }
        return newDocument;
    }

    @Override
    public synchronized BSONObject findAndModify(BSONObject query) throws MongoServerException {
        boolean returnNew = Utils.isTrue(query.get("new"));
        if (!query.containsField("remove") && !query.containsField("update")) {
            throw new MongoServerException("need remove or update");
        }
        BasicBSONObject queryObject = new BasicBSONObject();
        if (query.containsField("query")) {
            queryObject.put("query", query.get("query"));
        } else {
            queryObject.put("query", (Object)new BasicBSONObject());
        }
        if (query.containsField("sort")) {
            queryObject.put("orderby", query.get("sort"));
        }
        BasicBSONObject lastErrorObject = null;
        Object returnDocument = null;
        int num = 0;
        for (BSONObject document : this.handleQuery((BSONObject)queryObject, 0, 1)) {
            ++num;
            if (Utils.isTrue(query.get("remove"))) {
                this.removeDocument(document);
                returnDocument = document;
                continue;
            }
            if (query.get("update") == null) continue;
            BSONObject updateQuery = (BSONObject)query.get("update");
            Integer matchPos = this.matcher.matchPosition(document, (BSONObject)queryObject.get("query"));
            BSONObject oldDocument = this.updateDocument(document, updateQuery, matchPos);
            returnDocument = returnNew ? document : oldDocument;
            lastErrorObject = new BasicBSONObject("updatedExisting", (Object)Boolean.TRUE);
            lastErrorObject.put("n", (Object)1);
        }
        if (num == 0 && Utils.isTrue(query.get("upsert"))) {
            BSONObject selector = (BSONObject)query.get("query");
            BSONObject updateQuery = (BSONObject)query.get("update");
            BSONObject newDocument = this.handleUpsert(updateQuery, selector);
            returnDocument = returnNew ? newDocument : new BasicBSONObject();
            ++num;
        }
        if (query.get("fields") != null) {
            BSONObject fields = (BSONObject)query.get("fields");
            returnDocument = AbstractMongoCollection.projectDocument(returnDocument, fields, this.idField);
        }
        BasicBSONObject result = new BasicBSONObject();
        if (lastErrorObject != null) {
            result.put("lastErrorObject", lastErrorObject);
        }
        result.put("value", returnDocument);
        Utils.markOkay((BSONObject)result);
        return result;
    }

    private static BSONObject projectDocument(BSONObject document, BSONObject fields, String idField) {
        if (document == null) {
            return null;
        }
        BasicBSONObject newDocument = new BasicBSONObject();
        if (AbstractMongoCollection.onlyExclusions(fields)) {
            newDocument.putAll(document);
            for (String excludedField : fields.keySet()) {
                newDocument.removeField(excludedField);
            }
        } else {
            for (String key : fields.keySet()) {
                if (!Utils.isTrue(fields.get(key))) continue;
                AbstractMongoCollection.projectField(document, (BSONObject)newDocument, key);
            }
        }
        if (!fields.containsField(idField)) {
            newDocument.put(idField, document.get(idField));
        }
        return newDocument;
    }

    private static boolean onlyExclusions(BSONObject fields) {
        for (String key : fields.keySet()) {
            if (!Utils.isTrue(fields.get(key))) continue;
            return false;
        }
        return true;
    }

    private static void projectField(BSONObject document, BSONObject newDocument, String key) {
        if (document == null) {
            return;
        }
        int dotPos = key.indexOf(46);
        if (dotPos > 0) {
            String mainKey = key.substring(0, dotPos);
            String subKey = key.substring(dotPos + 1);
            Object object = document.get(mainKey);
            if (object instanceof BSONObject) {
                if (!newDocument.containsField(mainKey)) {
                    newDocument.put(mainKey, (Object)new BasicBSONObject());
                }
                AbstractMongoCollection.projectField((BSONObject)object, (BSONObject)newDocument.get(mainKey), subKey);
            }
        } else {
            newDocument.put(key, document.get(key));
        }
    }

    public synchronized Iterable<BSONObject> handleQuery(BSONObject queryObject, int numberToSkip, int numberToReturn) throws MongoServerException {
        return this.handleQuery(queryObject, numberToSkip, numberToReturn, null);
    }

    @Override
    public synchronized Iterable<BSONObject> handleQuery(BSONObject queryObject, int numberToSkip, int numberToReturn, BSONObject fieldSelector) throws MongoServerException {
        BSONObject query;
        BSONObject orderBy = null;
        if (numberToReturn < 0) {
            numberToReturn = -numberToReturn;
        }
        if (queryObject.containsField("query")) {
            query = (BSONObject)queryObject.get("query");
            orderBy = (BSONObject)queryObject.get("orderby");
        } else if (queryObject.containsField("$query")) {
            query = (BSONObject)queryObject.get("$query");
            orderBy = (BSONObject)queryObject.get("$orderby");
        } else {
            query = queryObject;
        }
        if (this.count() == 0) {
            return Collections.emptyList();
        }
        Iterable<BSONObject> objs = this.queryDocuments(query, orderBy, numberToSkip, numberToReturn);
        if (fieldSelector != null && !fieldSelector.keySet().isEmpty()) {
            return new ProjectingIterable(objs, fieldSelector, this.idField);
        }
        return objs;
    }

    @Override
    public synchronized BSONObject handleDistinct(BSONObject query) throws MongoServerException {
        String key = query.get("key").toString();
        BSONObject q = (BSONObject)query.get("query");
        TreeSet<Object> values = new TreeSet<Object>(new ValueComparator());
        for (BSONObject document : this.queryDocuments(q, null, 0, 0)) {
            if (!document.containsField(key)) continue;
            values.add(document.get(key));
        }
        BasicBSONObject response = new BasicBSONObject("values", new ArrayList<Object>(values));
        Utils.markOkay((BSONObject)response);
        return response;
    }

    @Override
    public synchronized int insertDocuments(List<BSONObject> documents) throws MongoServerException {
        for (BSONObject document : documents) {
            this.addDocument(document);
        }
        return documents.size();
    }

    @Override
    public synchronized int deleteDocuments(BSONObject selector, int limit) throws MongoServerException {
        int n = 0;
        for (BSONObject document : this.handleQuery(selector, 0, limit)) {
            if (limit > 0 && n >= limit) {
                throw new MongoServerException("internal error: too many elements (" + n + " >= " + limit + ")");
            }
            this.removeDocument(document);
            ++n;
        }
        return n;
    }

    @Override
    public synchronized BSONObject updateDocuments(BSONObject selector, BSONObject updateQuery, boolean isMulti, boolean isUpsert) throws MongoServerException {
        int n = 0;
        boolean updatedExisting = false;
        if (isMulti) {
            for (String key : updateQuery.keySet()) {
                if (key.startsWith("$")) continue;
                throw new MongoServerError(10158, "multi update only works with $ operators");
            }
        }
        for (BSONObject document : this.queryDocuments(selector, null, 0, 0)) {
            Integer matchPos = this.matcher.matchPosition(document, selector);
            this.updateDocument(document, updateQuery, matchPos);
            updatedExisting = true;
            ++n;
            if (isMulti) continue;
            break;
        }
        BasicBSONObject result = new BasicBSONObject();
        if (n == 0 && isUpsert) {
            BSONObject newDocument = this.handleUpsert(updateQuery, selector);
            if (!selector.containsField(this.idField)) {
                result.put("upserted", newDocument.get(this.idField));
            }
            ++n;
        }
        result.put("n", (Object)n);
        result.put("updatedExisting", (Object)updatedExisting);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BSONObject updateDocument(BSONObject document, BSONObject updateQuery, Integer matchPos) throws MongoServerException {
        BSONObject bSONObject = document;
        synchronized (bSONObject) {
            BasicBSONObject oldDocument = new BasicBSONObject();
            this.cloneInto((BSONObject)oldDocument, document);
            BSONObject newDocument = this.calculateUpdateDocument(document, updateQuery, matchPos, false);
            if (!newDocument.equals(oldDocument)) {
                for (Index<KEY> index : this.indexes) {
                    index.checkUpdate((BSONObject)oldDocument, newDocument);
                }
                for (Index<KEY> index : this.indexes) {
                    index.updateInPlace((BSONObject)oldDocument, newDocument);
                }
                long oldSize = Utils.calculateSize((BSONObject)oldDocument);
                long newSize = Utils.calculateSize(newDocument);
                this.updateDataSize(newSize - oldSize);
                HashSet fields = new HashSet(document.keySet());
                fields.removeAll(newDocument.keySet());
                for (String key : fields) {
                    document.removeField(key);
                }
                for (String key : newDocument.keySet()) {
                    if (key.contains(".")) {
                        throw new MongoServerException("illegal field name. must not happen as it must be catched by the driver");
                    }
                    document.put(key, newDocument.get(key));
                }
            }
            return oldDocument;
        }
    }

    private void cloneInto(BSONObject targetDocument, BSONObject sourceDocument) {
        for (String key : sourceDocument.keySet()) {
            targetDocument.put(key, this.cloneValue(sourceDocument.get(key)));
        }
    }

    private Object cloneValue(Object value) {
        if (value instanceof BSONObject) {
            BasicBSONObject newValue = new BasicBSONObject();
            this.cloneInto((BSONObject)newValue, (BSONObject)value);
            return newValue;
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Object> newValue = new ArrayList<Object>();
            for (Object v : list) {
                newValue.add(this.cloneValue(v));
            }
            return newValue;
        }
        return value;
    }

    private BSONObject handleUpsert(BSONObject updateQuery, BSONObject selector) throws MongoServerException {
        BSONObject document = this.convertSelectorToDocument(selector);
        BSONObject newDocument = this.calculateUpdateDocument(document, updateQuery, null, true);
        if (newDocument.get(this.idField) == null) {
            newDocument.put(this.idField, this.deriveDocumentId(selector));
        }
        this.addDocument(newDocument);
        return newDocument;
    }

    BSONObject convertSelectorToDocument(BSONObject selector) throws MongoServerException {
        BasicBSONObject document = new BasicBSONObject();
        for (String key : selector.keySet()) {
            Object value;
            if (key.startsWith("$") || Utils.containsQueryExpression(value = selector.get(key))) continue;
            this.changeSubdocumentValue((Object)document, key, value, (AtomicReference<Integer>)null);
        }
        return document;
    }

    @Override
    public int getNumIndexes() {
        return this.indexes.size();
    }

    @Override
    public int count(BSONObject query) throws MongoServerException {
        if (query.keySet().isEmpty()) {
            return this.count();
        }
        int count = 0;
        Iterator<BSONObject> it = this.queryDocuments(query, null, 0, 0).iterator();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public BSONObject getStats() {
        long dataSize = this.getDataSize();
        BasicBSONObject response = new BasicBSONObject("ns", (Object)this.getFullName());
        response.put("count", (Object)this.count());
        response.put("size", (Object)dataSize);
        double averageSize = 0.0;
        if (this.count() > 0) {
            averageSize = (double)dataSize / (double)this.count();
        }
        response.put("avgObjSize", (Object)averageSize);
        response.put("storageSize", (Object)0);
        response.put("numExtents", (Object)0);
        response.put("nindexes", (Object)this.indexes.size());
        BasicBSONObject indexSizes = new BasicBSONObject();
        for (Index<KEY> index : this.indexes) {
            indexSizes.put(index.getName(), (Object)index.getDataSize());
        }
        response.put("indexSize", (Object)indexSizes);
        Utils.markOkay((BSONObject)response);
        return response;
    }

    @Override
    public synchronized void removeDocument(BSONObject document) throws MongoServerException {
        KEY key = null;
        if (!this.indexes.isEmpty()) {
            for (Index<KEY> index : this.indexes) {
                key = index.remove(document);
            }
        } else {
            key = this.findDocument(document);
        }
        if (key == null) {
            return;
        }
        this.updateDataSize(-Utils.calculateSize(document));
        this.removeDocumentWithKey(key);
    }

    @Override
    public BSONObject validate() {
        BasicBSONObject response = new BasicBSONObject("ns", (Object)this.getFullName());
        response.put("extentCount", (Object)0);
        response.put("datasize", (Object)this.getDataSize());
        response.put("nrecords", (Object)this.getRecordCount());
        response.put("padding", (Object)1);
        response.put("deletedCount", (Object)this.getDeletedCount());
        response.put("deletedSize", (Object)0);
        response.put("nIndexes", (Object)this.indexes.size());
        BasicBSONObject keysPerIndex = new BasicBSONObject();
        for (Index<KEY> index : this.indexes) {
            keysPerIndex.put(index.getName(), (Object)index.getCount());
        }
        response.put("keysPerIndex", (Object)keysPerIndex);
        response.put("valid", (Object)Boolean.TRUE);
        response.put("errors", Arrays.asList(new Object[0]));
        Utils.markOkay((BSONObject)response);
        return response;
    }

    @Override
    public void renameTo(String newDatabaseName, String newCollectionName) {
        this.databaseName = newDatabaseName;
        this.collectionName = newCollectionName;
    }

    protected abstract void removeDocumentWithKey(KEY var1);

    protected abstract KEY findDocument(BSONObject var1);

    protected abstract int getRecordCount();

    protected abstract int getDeletedCount();

    private static class ProjectingIterable
    implements Iterable<BSONObject> {
        private Iterable<BSONObject> iterable;
        private BSONObject fieldSelector;
        private String idField;

        public ProjectingIterable(Iterable<BSONObject> iterable, BSONObject fieldSelector, String idField) {
            this.iterable = iterable;
            this.fieldSelector = fieldSelector;
            this.idField = idField;
        }

        @Override
        public Iterator<BSONObject> iterator() {
            return new ProjectingIterator(this.iterable.iterator(), this.fieldSelector, this.idField);
        }
    }

    private static class ProjectingIterator
    implements Iterator<BSONObject> {
        private Iterator<BSONObject> iterator;
        private BSONObject fieldSelector;
        private String idField;

        public ProjectingIterator(Iterator<BSONObject> iterator, BSONObject fieldSelector, String idField) {
            this.iterator = iterator;
            this.fieldSelector = fieldSelector;
            this.idField = idField;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public BSONObject next() {
            BSONObject document = this.iterator.next();
            BSONObject projectedDocument = AbstractMongoCollection.projectDocument(document, this.fieldSelector, this.idField);
            return projectedDocument;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

