/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.accumulator;

import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.Accumulator;
import java.util.Comparator;

abstract class ComparingAccumulator
extends Accumulator {
    private final Comparator<Object> comparator = ValueComparator.ascWithoutListHandling();
    private Object result;

    ComparingAccumulator(String field, Object expression) {
        super(field, expression);
    }

    @Override
    public void aggregate(Object value) {
        if (Missing.isNullOrMissing(value)) {
            return;
        }
        if (this.result == null) {
            this.result = value;
        } else {
            int comparisonResult = this.comparator.compare(value, this.result);
            if (this.shouldTakeValue(comparisonResult)) {
                this.result = value;
            }
        }
    }

    protected abstract boolean shouldTakeValue(int var1);

    @Override
    public Object getResult() {
        return this.result;
    }
}

