/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.backend.AbstractMongoDatabase;
import de.bwaldvogel.mongo.backend.ArrayFilters;
import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.backend.DefaultQueryMatcher;
import de.bwaldvogel.mongo.backend.DocumentComparator;
import de.bwaldvogel.mongo.backend.DocumentWithPosition;
import de.bwaldvogel.mongo.backend.FieldUpdates;
import de.bwaldvogel.mongo.backend.Index;
import de.bwaldvogel.mongo.backend.LinkedTreeSet;
import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.QueryMatcher;
import de.bwaldvogel.mongo.backend.UpdateOperator;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.projection.ProjectingIterable;
import de.bwaldvogel.mongo.backend.projection.Projection;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.ObjectId;
import de.bwaldvogel.mongo.exception.BadValueException;
import de.bwaldvogel.mongo.exception.ConflictingUpdateOperatorsException;
import de.bwaldvogel.mongo.exception.FailedToParseException;
import de.bwaldvogel.mongo.exception.ImmutableFieldException;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMongoCollection<P>
implements MongoCollection<P> {
    private static final Logger log = LoggerFactory.getLogger(AbstractMongoCollection.class);
    private String collectionName;
    private String databaseName;
    private final List<Index<P>> indexes = new ArrayList<Index<P>>();
    private final QueryMatcher matcher = new DefaultQueryMatcher();
    protected final String idField;

    protected AbstractMongoCollection(String databaseName, String collectionName, String idField) {
        this.databaseName = databaseName;
        this.collectionName = collectionName;
        this.idField = idField;
    }

    protected boolean documentMatchesQuery(Document document, Document query) {
        return this.matcher.matches(document, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<Document> queryDocuments(Document query, Document orderBy, int numberToSkip, int numberToReturn) {
        List<Index<P>> list = this.indexes;
        synchronized (list) {
            for (Index<P> index : this.indexes) {
                if (!index.canHandle(query)) continue;
                Iterable<P> positions = index.getPositions(query);
                return this.matchDocuments(query, positions, orderBy, numberToSkip, numberToReturn);
            }
        }
        return this.matchDocuments(query, orderBy, numberToSkip, numberToReturn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sortDocumentsInMemory(List<Document> documents, Document orderBy) {
        if (orderBy == null || orderBy.keySet().isEmpty()) return;
        if (orderBy.keySet().iterator().next().equals("$natural")) {
            int sortValue = (Integer)orderBy.get("$natural");
            if (sortValue == 1) return;
            if (sortValue != -1) throw new IllegalArgumentException("Illegal sort value: " + sortValue);
            Collections.reverse(documents);
            return;
        } else {
            documents.sort(new DocumentComparator(orderBy));
        }
    }

    protected abstract Iterable<Document> matchDocuments(Document var1, Document var2, int var3, int var4);

    protected abstract Iterable<Document> matchDocuments(Document var1, Iterable<P> var2, Document var3, int var4, int var5);

    protected abstract Document getDocument(P var1);

    protected abstract void updateDataSize(int var1);

    protected abstract int getDataSize();

    protected abstract P addDocumentInternal(Document var1);

    @Override
    public synchronized void addDocument(Document document) {
        if (document.get("_id") instanceof Collection) {
            throw new BadValueException("can't use an array for _id");
        }
        if (!document.containsKey("_id") && !this.isSystemCollection()) {
            ObjectId generatedObjectId = new ObjectId();
            log.debug("Generated {} for {} in {}", new Object[]{generatedObjectId, document, this});
            document.put("_id", (Object)generatedObjectId);
        }
        for (Index index : this.indexes) {
            index.checkAdd(document, this);
        }
        P position = this.addDocumentInternal(document);
        for (Index<P> index : this.indexes) {
            index.add(document, position, this);
        }
        this.updateDataSize(Utils.calculateSize(document));
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public String getFullName() {
        return this.getDatabaseName() + "." + this.getCollectionName();
    }

    @Override
    public String getCollectionName() {
        return this.collectionName;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getFullName() + ")";
    }

    @Override
    public void addIndex(Index<P> index) {
        if (index.isEmpty()) {
            this.streamAllDocumentsWithPosition().forEach(documentWithPosition -> {
                Document document = documentWithPosition.getDocument();
                index.checkAdd(document, this);
            });
            this.streamAllDocumentsWithPosition().forEach(documentWithPosition -> {
                Document document = documentWithPosition.getDocument();
                Object position = documentWithPosition.getPosition();
                index.add(document, position, this);
            });
        } else {
            log.debug("Index is not empty");
        }
        this.indexes.add(index);
    }

    private void modifyField(Document document, String modifier, Document update, ArrayFilters arrayFilters, Integer matchPos, boolean isUpsert) {
        Document change = (Document)update.get(modifier);
        UpdateOperator updateOperator = this.getUpdateOperator(modifier, change);
        FieldUpdates updates = new FieldUpdates(document, updateOperator, this.idField, isUpsert, matchPos, arrayFilters);
        updates.apply(change, modifier);
    }

    private UpdateOperator getUpdateOperator(String modifier, Document change) {
        UpdateOperator op;
        try {
            op = UpdateOperator.fromValue(modifier);
        }
        catch (IllegalArgumentException e) {
            throw new FailedToParseException("Unknown modifier: " + modifier);
        }
        if (op != UpdateOperator.UNSET) {
            for (String key : change.keySet()) {
                if (!key.startsWith("$") || key.startsWith("$[")) continue;
                throw new MongoServerError(15896, "Modified field name may not start with $");
            }
        }
        return op;
    }

    private void applyUpdate(Document oldDocument, Document newDocument) {
        if (newDocument.equals(oldDocument)) {
            return;
        }
        Object oldId = oldDocument.get(this.idField);
        Object newId = newDocument.get(this.idField);
        if (newId != null && !Utils.nullAwareEquals(oldId, newId)) {
            throw new ImmutableFieldException("After applying the update, the (immutable) field '_id' was found to have been altered to _id: " + newId);
        }
        if (newId == null && oldId != null) {
            newDocument.put(this.idField, oldId);
        }
        this.cloneInto(oldDocument, newDocument);
    }

    Object deriveDocumentId(Document selector) {
        Object value = selector.get(this.idField);
        if (value != null) {
            if (!Utils.containsQueryExpression(value)) {
                return value;
            }
            return this.deriveIdFromExpression(value);
        }
        return new ObjectId();
    }

    private Object deriveIdFromExpression(Object value) {
        Document expression = (Document)value;
        for (String key : expression.keySet()) {
            Collection list;
            Object expressionValue = expression.get(key);
            if (!key.equals("$in") || (list = (Collection)expressionValue).isEmpty()) continue;
            return list.iterator().next();
        }
        return new ObjectId();
    }

    private Document calculateUpdateDocument(Document oldDocument, Document update, ArrayFilters arrayFilters, Integer matchPos, boolean isUpsert) {
        int numStartsWithDollar = 0;
        for (String key : update.keySet()) {
            if (!key.startsWith("$")) continue;
            ++numStartsWithDollar;
        }
        Document newDocument = new Document(this.idField, oldDocument.get(this.idField));
        if (numStartsWithDollar == update.keySet().size()) {
            AbstractMongoCollection.validateUpdateQuery(update);
            this.cloneInto(newDocument, oldDocument);
            for (String key : update.keySet()) {
                this.modifyField(newDocument, key, update, arrayFilters, matchPos, isUpsert);
            }
        } else if (numStartsWithDollar == 0) {
            this.applyUpdate(newDocument, update);
        } else {
            throw new MongoServerException("illegal update: " + update);
        }
        return newDocument;
    }

    static void validateUpdateQuery(Document update) {
        LinkedHashSet<String> allModifiedPaths = new LinkedHashSet<String>();
        for (Object value : update.values()) {
            Document modification = (Document)value;
            for (String path : modification.keySet()) {
                for (String otherPath : allModifiedPaths) {
                    String commonPathPrefix = Utils.getShorterPathIfPrefix(path, otherPath);
                    if (commonPathPrefix == null) continue;
                    throw new ConflictingUpdateOperatorsException(path, commonPathPrefix);
                }
                allModifiedPaths.add(path);
            }
        }
    }

    @Override
    public synchronized Document findAndModify(Document query) {
        boolean returnNew = Utils.isTrue(query.get("new"));
        if (!query.containsKey("remove") && !query.containsKey("update")) {
            throw new FailedToParseException("Either an update or remove=true must be specified");
        }
        Document queryObject = new Document();
        if (query.containsKey("query")) {
            queryObject.put("query", query.get("query"));
        } else {
            queryObject.put("query", (Object)new Document());
        }
        if (query.containsKey("sort")) {
            queryObject.put("orderby", query.get("sort"));
        }
        Document lastErrorObject = null;
        Document returnDocument = null;
        int num = 0;
        for (Document document : this.handleQuery(queryObject, 0, 1)) {
            ++num;
            if (Utils.isTrue(query.get("remove"))) {
                this.removeDocument(document);
                returnDocument = document;
                continue;
            }
            if (query.get("update") == null) continue;
            Document updateQuery = (Document)query.get("update");
            Integer matchPos = this.matcher.matchPosition(document, (Document)queryObject.get("query"));
            ArrayFilters arrayFilters = ArrayFilters.parse(query, updateQuery);
            Document oldDocument = this.updateDocument(document, updateQuery, arrayFilters, matchPos);
            returnDocument = returnNew ? document : oldDocument;
            lastErrorObject = new Document("updatedExisting", Boolean.TRUE);
            lastErrorObject.put("n", (Object)1);
        }
        if (num == 0 && Utils.isTrue(query.get("upsert"))) {
            Document selector = (Document)query.get("query");
            Document updateQuery = (Document)query.get("update");
            ArrayFilters arrayFilters = ArrayFilters.parse(query, updateQuery);
            Document newDocument = this.handleUpsert(updateQuery, selector, arrayFilters);
            returnDocument = returnNew ? newDocument : new Document();
            ++num;
        }
        if (query.get("fields") != null) {
            Document fields = (Document)query.get("fields");
            returnDocument = Projection.projectDocument(returnDocument, fields, this.idField);
        }
        Document result = new Document();
        if (lastErrorObject != null) {
            result.put("lastErrorObject", (Object)lastErrorObject);
        }
        result.put("value", (Object)returnDocument);
        Utils.markOkay(result);
        return result;
    }

    @Override
    public synchronized Iterable<Document> handleQuery(Document queryObject, int numberToSkip, int numberToReturn, Document fieldSelector) {
        Document orderBy;
        Document query;
        if (numberToReturn < 0) {
            numberToReturn = -numberToReturn;
        }
        if (queryObject.containsKey("query")) {
            query = (Document)queryObject.get("query");
            orderBy = (Document)queryObject.get("orderby");
        } else if (queryObject.containsKey("$query")) {
            query = (Document)queryObject.get("$query");
            orderBy = (Document)queryObject.get("$orderby");
        } else {
            query = queryObject;
            orderBy = null;
        }
        if (this.count() == 0) {
            return Collections.emptyList();
        }
        Iterable<Document> objs = this.queryDocuments(query, orderBy, numberToSkip, numberToReturn);
        if (fieldSelector != null && !fieldSelector.keySet().isEmpty()) {
            return new ProjectingIterable(objs, fieldSelector, this.idField);
        }
        return objs;
    }

    @Override
    public synchronized Document handleDistinct(Document query) {
        String key = (String)query.get("key");
        Document filter = query.getOrDefault("query", new Document());
        LinkedTreeSet<Object> values = new LinkedTreeSet<Object>();
        for (Document document : this.queryDocuments(filter, null, 0, 0)) {
            Object value = Utils.getSubdocumentValueCollectionAware(document, key);
            if (value instanceof Missing) continue;
            if (value instanceof Collection) {
                values.addAll((Collection)value);
                continue;
            }
            values.add(value);
        }
        Document response = new Document("values", values);
        Utils.markOkay(response);
        return response;
    }

    @Override
    public synchronized void insertDocuments(List<Document> documents) {
        for (Document document : documents) {
            this.addDocument(document);
        }
    }

    @Override
    public synchronized int deleteDocuments(Document selector, int limit) {
        int n = 0;
        for (Document document : this.handleQuery(selector, 0, limit)) {
            if (limit > 0 && n >= limit) {
                throw new MongoServerException("internal error: too many elements (" + n + " >= " + limit + ")");
            }
            this.removeDocument(document);
            ++n;
        }
        return n;
    }

    @Override
    public synchronized Document updateDocuments(Document selector, Document updateQuery, ArrayFilters arrayFilters, boolean isMulti, boolean isUpsert) {
        if (isMulti) {
            for (String key : updateQuery.keySet()) {
                if (key.startsWith("$")) continue;
                throw new MongoServerError(10158, "multi update only works with $ operators");
            }
        }
        int nMatched = 0;
        int nModified = 0;
        for (Document document : this.queryDocuments(selector, null, 0, 0)) {
            Integer matchPos;
            Document oldDocument = this.updateDocument(document, updateQuery, arrayFilters, matchPos = this.matcher.matchPosition(document, selector));
            if (!Utils.nullAwareEquals(oldDocument, document)) {
                ++nModified;
            }
            ++nMatched;
            if (isMulti) continue;
            break;
        }
        Document result = new Document();
        if (nMatched == 0 && isUpsert) {
            Document newDocument = this.handleUpsert(updateQuery, selector, arrayFilters);
            result.put("upserted", newDocument.get(this.idField));
        }
        result.put("n", (Object)nMatched);
        result.put("nModified", (Object)nModified);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document updateDocument(Document document, Document updateQuery, ArrayFilters arrayFilters, Integer matchPos) {
        Document document2 = document;
        synchronized (document2) {
            Document oldDocument = new Document();
            this.cloneInto(oldDocument, document);
            Document newDocument = this.calculateUpdateDocument(document, updateQuery, arrayFilters, matchPos, false);
            if (!newDocument.equals(oldDocument)) {
                for (Index<P> index : this.indexes) {
                    index.checkUpdate(oldDocument, newDocument, this);
                }
                for (Index<P> index : this.indexes) {
                    index.updateInPlace(oldDocument, newDocument, this);
                }
                int oldSize = Utils.calculateSize(oldDocument);
                int newSize = Utils.calculateSize(newDocument);
                this.updateDataSize(newSize - oldSize);
                LinkedHashSet<String> fields = new LinkedHashSet<String>(document.keySet());
                fields.removeAll(newDocument.keySet());
                for (String key : fields) {
                    document.remove(key);
                }
                for (String key : newDocument.keySet()) {
                    if (key.contains(".")) {
                        throw new MongoServerException("illegal field name. must not happen as it must be caught by the driver");
                    }
                    document.put(key, newDocument.get(key));
                }
                this.handleUpdate(document);
            }
            return oldDocument;
        }
    }

    protected abstract void handleUpdate(Document var1);

    private void cloneInto(Document targetDocument, Document sourceDocument) {
        for (String key : sourceDocument.keySet()) {
            targetDocument.put(key, this.cloneValue(sourceDocument.get(key)));
        }
    }

    private Object cloneValue(Object value) {
        if (value instanceof Document) {
            Document newValue = new Document();
            this.cloneInto(newValue, (Document)value);
            return newValue;
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Object> newValue = new ArrayList<Object>();
            for (Object v : list) {
                newValue.add(this.cloneValue(v));
            }
            return newValue;
        }
        return value;
    }

    private Document handleUpsert(Document updateQuery, Document selector, ArrayFilters arrayFilters) {
        Document document = this.convertSelectorToDocument(selector);
        Document newDocument = this.calculateUpdateDocument(document, updateQuery, arrayFilters, null, true);
        if (newDocument.get(this.idField) == null) {
            newDocument.put(this.idField, this.deriveDocumentId(selector));
        }
        this.addDocument(newDocument);
        return newDocument;
    }

    Document convertSelectorToDocument(Document selector) {
        Document document = new Document();
        for (String key : selector.keySet()) {
            Object value;
            if (key.startsWith("$") || Utils.containsQueryExpression(value = selector.get(key))) continue;
            Utils.changeSubdocumentValue((Object)document, key, value, (AtomicReference<Integer>)null);
        }
        return document;
    }

    @Override
    public int getNumIndexes() {
        return this.indexes.size();
    }

    @Override
    public int count(Document query, int skip, int limit) {
        if (query.keySet().isEmpty()) {
            int count = this.count();
            if (skip > 0) {
                count = Math.max(0, count - skip);
            }
            if (limit > 0) {
                return Math.min(limit, count);
            }
            return count;
        }
        int numberToReturn = limit >= 0 ? limit : 0;
        int count = 0;
        Iterator<Document> it = this.queryDocuments(query, null, skip, numberToReturn).iterator();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    @Override
    public Document getStats() {
        int dataSize = this.getDataSize();
        Document response = new Document("ns", this.getFullName());
        response.put("count", (Object)this.count());
        response.put("size", (Object)dataSize);
        int averageSize = 0;
        if (this.count() > 0) {
            averageSize = dataSize / this.count();
        }
        response.put("avgObjSize", (Object)averageSize);
        response.put("storageSize", (Object)0);
        response.put("numExtents", (Object)0);
        response.put("nindexes", (Object)this.indexes.size());
        Document indexSizes = new Document();
        for (Index<P> index : this.indexes) {
            indexSizes.put(index.getName(), (Object)index.getDataSize());
        }
        response.put("indexSize", (Object)indexSizes);
        Utils.markOkay(response);
        return response;
    }

    @Override
    public synchronized void removeDocument(Document document) {
        Object position = null;
        if (!this.indexes.isEmpty()) {
            for (Index<P> index : this.indexes) {
                P indexPosition = index.remove(document);
                if (indexPosition == null) {
                    if (index.isSparse()) continue;
                    throw new IllegalStateException("Found no position for " + document + " in " + index);
                }
                if (position != null) {
                    Assert.equals(position, indexPosition, () -> "Got different positions for " + document);
                }
                position = indexPosition;
            }
        } else {
            position = this.findDocumentPosition(document);
        }
        if (position == null) {
            return;
        }
        this.updateDataSize(-Utils.calculateSize(document));
        this.removeDocument(position);
    }

    @Override
    public Document validate() {
        Document response = new Document("ns", this.getFullName());
        response.put("extentCount", (Object)0);
        response.put("datasize", (Object)this.getDataSize());
        response.put("nrecords", (Object)this.count());
        response.put("nIndexes", (Object)this.indexes.size());
        Document keysPerIndex = new Document();
        for (Index<P> index : this.indexes) {
            keysPerIndex.put(index.getName(), (Object)index.getCount());
        }
        response.put("keysPerIndex", (Object)keysPerIndex);
        response.put("valid", (Object)Boolean.TRUE);
        response.put("errors", (Object)Collections.emptyList());
        Utils.markOkay(response);
        return response;
    }

    @Override
    public void renameTo(String newDatabaseName, String newCollectionName) {
        this.databaseName = newDatabaseName;
        this.collectionName = newCollectionName;
    }

    protected abstract void removeDocument(P var1);

    protected abstract P findDocumentPosition(Document var1);

    protected abstract Stream<DocumentWithPosition<P>> streamAllDocumentsWithPosition();

    private boolean isSystemCollection() {
        return AbstractMongoDatabase.isSystemCollection(this.getCollectionName());
    }
}

