/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview.layered;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import de.blox.graphview.Edge;
import de.blox.graphview.Graph;
import de.blox.graphview.Node;
import de.blox.graphview.edgerenderer.ArrowEdgeRenderer;
import de.blox.graphview.layered.SugiyamaEdgeData;
import de.blox.graphview.layered.SugiyamaNodeData;
import de.blox.graphview.util.VectorF;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\b\u0000\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/blox/graphview/layered/SugiyamaEdgeRenderer;", "Lde/blox/graphview/edgerenderer/ArrowEdgeRenderer;", "nodeData", "", "Lde/blox/graphview/Node;", "Lde/blox/graphview/layered/SugiyamaNodeData;", "edgeData", "Lde/blox/graphview/Edge;", "Lde/blox/graphview/layered/SugiyamaEdgeData;", "(Ljava/util/Map;Ljava/util/Map;)V", "render", "", "canvas", "Landroid/graphics/Canvas;", "graph", "Lde/blox/graphview/Graph;", "paint", "Landroid/graphics/Paint;", "graphview_release"})
public final class SugiyamaEdgeRenderer
extends ArrowEdgeRenderer {
    private final Map<Node, SugiyamaNodeData> nodeData;
    private final Map<Edge, SugiyamaEdgeData> edgeData;

    /*
     * WARNING - void declaration
     */
    @Override
    public void render(@NotNull Canvas canvas, @NotNull Graph graph, @NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        Paint trianglePaint = new Paint(paint);
        trianglePaint.setStyle(Paint.Style.FILL);
        Path path = new Path();
        Iterable $this$forEach$iv = graph.getEdges();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void x1;
            void x;
            Edge edge = (Edge)element$iv;
            boolean bl = false;
            Node source = edge.getSource();
            VectorF vectorF = source.getPosition();
            float f = vectorF.component1();
            float y = vectorF.component2();
            Node destination = edge.getDestination();
            VectorF vectorF2 = destination.getPosition();
            float f2 = vectorF2.component1();
            float y1 = vectorF2.component2();
            float[] clippedLine = null;
            if (this.edgeData.containsKey(edge)) {
                Collection collection = ((SugiyamaEdgeData)MapsKt.getValue(this.edgeData, (Object)edge)).getBendPoints();
                boolean bl2 = false;
                if (!collection.isEmpty()) {
                    List<Float> bendPoints = ((SugiyamaEdgeData)MapsKt.getValue(this.edgeData, (Object)edge)).getBendPoints();
                    int size = bendPoints.size();
                    clippedLine = ((SugiyamaNodeData)MapsKt.getValue(this.nodeData, (Object)source)).isReversed() ? this.clipLine(((Number)bendPoints.get(2)).floatValue(), ((Number)bendPoints.get(3)).floatValue(), ((Number)bendPoints.get(0)).floatValue(), ((Number)bendPoints.get(1)).floatValue(), destination) : this.clipLine(((Number)bendPoints.get(size - 4)).floatValue(), ((Number)bendPoints.get(size - 3)).floatValue(), ((Number)bendPoints.get(size - 2)).floatValue(), ((Number)bendPoints.get(size - 1)).floatValue(), destination);
                    float[] triangleCentroid = this.drawTriangle(canvas, trianglePaint, clippedLine[0], clippedLine[1], clippedLine[2], clippedLine[3]);
                    path.reset();
                    path.moveTo(((Number)bendPoints.get(0)).floatValue(), ((Number)bendPoints.get(1)).floatValue());
                    IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)3, (int)(size - 2))), (int)2);
                    int n = intProgression.getFirst();
                    int n2 = intProgression.getLast();
                    int n3 = intProgression.getStep();
                    int n4 = n;
                    int n5 = n2;
                    if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
                        while (true) {
                            void i;
                            path.lineTo(((Number)bendPoints.get((int)(i - true))).floatValue(), ((Number)bendPoints.get((int)i)).floatValue());
                            if (i == n2) break;
                            i += n3;
                        }
                    }
                    path.lineTo(triangleCentroid[0], triangleCentroid[1]);
                    canvas.drawPath(path, paint);
                    continue;
                }
            }
            void startX = x + (float)source.getWidth() / 2.0f;
            float startY = y + (float)source.getHeight() / 2.0f;
            void stopX = x1 + (float)destination.getWidth() / 2.0f;
            float stopY = y1 + (float)destination.getHeight() / 2.0f;
            clippedLine = this.clipLine((float)startX, startY, (float)stopX, stopY, destination);
            float[] triangleCentroid = this.drawTriangle(canvas, trianglePaint, clippedLine[0], clippedLine[1], clippedLine[2], clippedLine[3]);
            canvas.drawLine(clippedLine[0], clippedLine[1], triangleCentroid[0], triangleCentroid[1], paint);
        }
    }

    public SugiyamaEdgeRenderer(@NotNull Map<Node, SugiyamaNodeData> nodeData, @NotNull Map<Edge, SugiyamaEdgeData> edgeData) {
        Intrinsics.checkParameterIsNotNull(nodeData, (String)"nodeData");
        Intrinsics.checkParameterIsNotNull(edgeData, (String)"edgeData");
        this.nodeData = nodeData;
        this.edgeData = edgeData;
    }
}

