/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview.tree;

import android.graphics.Canvas;
import android.graphics.Paint;
import de.blox.graphview.Graph;
import de.blox.graphview.Layout;
import de.blox.graphview.Node;
import de.blox.graphview.edgerenderer.EdgeRenderer;
import de.blox.graphview.tree.BuchheimWalkerConfiguration;
import de.blox.graphview.tree.BuchheimWalkerNodeData;
import de.blox.graphview.tree.TreeEdgeRenderer;
import de.blox.graphview.util.Size;
import de.blox.graphview.util.VectorF;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0007\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0002J \u0010\u0019\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\fH\u0002J \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\fH\u0002J$\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0(2\u0006\u0010*\u001a\u00020\u000fH\u0002J\u0016\u0010+\u001a\u00020\u001b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0(H\u0002J(\u0010,\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fH\u0002J\u0018\u0010/\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u001a\u00100\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\fH\u0002J\u0010\u00104\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u00105\u001a\u0002062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u00107\u001a\u0002062\u0006\u0010\u0017\u001a\u00020\f2\u0006\u00108\u001a\u00020\u000f2\u0006\u00109\u001a\u000206H\u0002J\u0010\u0010:\u001a\u0002022\u0006\u0010;\u001a\u00020\fH\u0002J\u001a\u0010<\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u001a\u0010=\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\fH\u0002J\"\u0010>\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010?\u001a\u0004\u0018\u00010\f2\u0006\u0010@\u001a\u00020\fH\u0002J\u0018\u0010A\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0018\u0010B\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0018\u0010C\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\fH\u0002J\"\u0010D\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010?\u001a\u0004\u0018\u00010\f2\u0006\u0010@\u001a\u00020\fH\u0002J \u0010E\u001a\u00020!2\u0006\u0010F\u001a\u00020\f2\u0006\u0010G\u001a\u00020\f2\u0006\u0010H\u001a\u000202H\u0002J\u001c\u0010I\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0002J\u001c\u0010J\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010K\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010L\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020NH\u0016J \u0010P\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010Q\u001a\u000202H\u0002J\u0018\u0010R\u001a\u00020!2\u0006\u0010;\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0010\u0010S\u001a\u00020!2\u0006\u0010T\u001a\u00020\u0006H\u0016J\u0018\u0010U\u001a\u00020!2\u0006\u0010;\u001a\u00020\f2\u0006\u0010Q\u001a\u000202H\u0002J\u001a\u0010V\u001a\u00020!2\u0006\u0010;\u001a\u00020\f2\b\u0010W\u001a\u0004\u0018\u00010\fH\u0002J \u0010X\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020NH\u0002J\u001e\u0010Y\u001a\b\u0012\u0004\u0012\u00020\f0(2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010Z\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lde/blox/graphview/tree/BuchheimWalkerAlgorithm;", "Lde/blox/graphview/Layout;", "configuration", "Lde/blox/graphview/tree/BuchheimWalkerConfiguration;", "(Lde/blox/graphview/tree/BuchheimWalkerConfiguration;)V", "edgeRenderer", "Lde/blox/graphview/edgerenderer/EdgeRenderer;", "isVertical", "", "()Z", "mNodeData", "", "Lde/blox/graphview/Node;", "Lde/blox/graphview/tree/BuchheimWalkerNodeData;", "maxNodeHeight", "", "maxNodeWidth", "minNodeHeight", "minNodeWidth", "ancestor", "graph", "Lde/blox/graphview/Graph;", "vim", "node", "defaultAncestor", "apportion", "calculateGraphSize", "Lde/blox/graphview/util/Size;", "compare", "x", "y", "createNodeData", "drawEdges", "", "canvas", "Landroid/graphics/Canvas;", "linePaint", "Landroid/graphics/Paint;", "executeShifts", "filterByLevel", "", "nodes", "level", "findMaxSize", "firstWalk", "depth", "number", "getLeftMostChild", "getLeftSibling", "getModifier", "", "vip", "getNodeData", "getOffset", "Lde/blox/graphview/util/VectorF;", "getPosition", "globalPadding", "offset", "getPrelim", "v", "getRightMostChild", "getRightSibling", "getSpacing", "leftNode", "rightNode", "hasLeftSibling", "hasRightSibling", "isLeaf", "isSibling", "moveSubtree", "wm", "wp", "shift", "nextLeft", "nextRight", "positionNodes", "run", "shiftX", "", "shiftY", "secondWalk", "modifier", "setAncestor", "setEdgeRenderer", "renderer", "setModifier", "setThread", "thread", "shiftCoordinates", "sortByLevel", "descending", "graphview_release"})
public final class BuchheimWalkerAlgorithm
implements Layout {
    private final Map<Node, BuchheimWalkerNodeData> mNodeData;
    private EdgeRenderer edgeRenderer;
    private int minNodeHeight;
    private int minNodeWidth;
    private int maxNodeWidth;
    private int maxNodeHeight;
    private final BuchheimWalkerConfiguration configuration;

    private final boolean isVertical() {
        int orientation = this.configuration.getOrientation();
        return orientation == 1 || orientation == 2;
    }

    private final int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private final BuchheimWalkerNodeData createNodeData(Node node) {
        BuchheimWalkerNodeData buchheimWalkerNodeData = new BuchheimWalkerNodeData();
        boolean bl = false;
        boolean bl2 = false;
        BuchheimWalkerNodeData $this$apply = buchheimWalkerNodeData;
        boolean bl3 = false;
        $this$apply.setAncestor(node);
        BuchheimWalkerNodeData nodeData = buchheimWalkerNodeData;
        this.mNodeData.put(node, nodeData);
        return nodeData;
    }

    private final BuchheimWalkerNodeData getNodeData(Node node) {
        return (BuchheimWalkerNodeData)MapsKt.getValue(this.mNodeData, (Object)node);
    }

    private final void firstWalk(Graph graph, Node node, int depth, int number) {
        int n;
        BuchheimWalkerNodeData nodeData = this.createNodeData(node);
        nodeData.setDepth(depth);
        nodeData.setNumber(number);
        int n2 = this.minNodeHeight;
        int n3 = node.getHeight();
        BuchheimWalkerAlgorithm buchheimWalkerAlgorithm = this;
        boolean bl = false;
        buchheimWalkerAlgorithm.minNodeHeight = n = Math.min(n2, n3);
        n2 = this.minNodeWidth;
        n3 = node.getWidth();
        buchheimWalkerAlgorithm = this;
        bl = false;
        buchheimWalkerAlgorithm.minNodeWidth = n = Math.min(n2, n3);
        n2 = this.maxNodeWidth;
        n3 = node.getWidth();
        buchheimWalkerAlgorithm = this;
        bl = false;
        buchheimWalkerAlgorithm.maxNodeWidth = n = Math.max(n2, n3);
        n2 = this.maxNodeHeight;
        n3 = node.getHeight();
        buchheimWalkerAlgorithm = this;
        bl = false;
        buchheimWalkerAlgorithm.maxNodeHeight = n = Math.max(n2, n3);
        if (this.isLeaf(graph, node)) {
            if (this.hasLeftSibling(graph, node)) {
                Node leftSibling;
                Node node2 = leftSibling = this.getLeftSibling(graph, node);
                if (node2 == null) {
                    Intrinsics.throwNpe();
                }
                nodeData.setPrelim(this.getPrelim(node2) + (double)this.getSpacing(graph, leftSibling, node));
            }
        } else {
            Node leftMost = this.getLeftMostChild(graph, node);
            Node rightMost = this.getRightMostChild(graph, node);
            Node defaultAncestor = leftMost;
            Node next = leftMost;
            int i = 1;
            while (next != null) {
                this.firstWalk(graph, next, depth + 1, i++);
                defaultAncestor = this.apportion(graph, next, defaultAncestor);
                next = this.getRightSibling(graph, next);
            }
            this.executeShifts(graph, node);
            boolean isVertical = this.isVertical();
            double d = this.getPrelim(leftMost);
            Node node3 = rightMost;
            if (node3 == null) {
                Intrinsics.throwNpe();
            }
            double midPoint = 0.5 * (d + this.getPrelim(node3) + (double)(isVertical ? rightMost.getWidth() : rightMost.getHeight()) - (double)(isVertical ? node.getWidth() : node.getHeight()));
            if (this.hasLeftSibling(graph, node)) {
                Node leftSibling;
                Node node4 = leftSibling = this.getLeftSibling(graph, node);
                if (node4 == null) {
                    Intrinsics.throwNpe();
                }
                nodeData.setPrelim(this.getPrelim(node4) + (double)this.getSpacing(graph, leftSibling, node));
                nodeData.setModifier(nodeData.getPrelim() - midPoint);
            } else {
                nodeData.setPrelim(midPoint);
            }
        }
    }

    private final void secondWalk(Graph graph, Node node, double modifier) {
        BuchheimWalkerNodeData nodeData = this.getNodeData(node);
        int depth = nodeData.getDepth();
        boolean vertical = this.isVertical();
        node.setPosition(new VectorF((float)(nodeData.getPrelim() + modifier), depth * (vertical ? this.minNodeHeight : this.minNodeWidth) + depth * this.configuration.getLevelSeparation()));
        Iterable $this$forEach$iv = graph.successorsOf(node);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node w = (Node)element$iv;
            boolean bl = false;
            this.secondWalk(graph, w, modifier + nodeData.getModifier());
        }
    }

    private final Size calculateGraphSize(Graph graph) {
        int left = Integer.MAX_VALUE;
        int top = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        int bottom = Integer.MIN_VALUE;
        Iterable $this$forEach$iv = graph.getNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node node = (Node)element$iv;
            boolean bl = false;
            float f = left;
            float f2 = node.getX();
            boolean bl2 = false;
            float f3 = Math.min(f, f2);
            left = (int)f3;
            f = top;
            f2 = node.getY();
            bl2 = false;
            f3 = Math.min(f, f2);
            top = (int)f3;
            f = right;
            f2 = node.getX() + (float)node.getWidth();
            bl2 = false;
            f3 = Math.max(f, f2);
            right = (int)f3;
            f = bottom;
            f2 = node.getY() + (float)node.getHeight();
            bl2 = false;
            f3 = Math.max(f, f2);
            bottom = (int)f3;
        }
        return new Size(right - left, bottom - top);
    }

    private final void executeShifts(Graph graph, Node node) {
        double shift = 0.0;
        double change = 0.0;
        Node w = this.getRightMostChild(graph, node);
        while (w != null) {
            BuchheimWalkerNodeData nodeData = this.getNodeData(w);
            nodeData.setPrelim(nodeData.getPrelim() + shift);
            nodeData.setModifier(nodeData.getModifier() + shift);
            shift += nodeData.getShift() + (change += nodeData.getChange());
            w = this.getLeftSibling(graph, w);
        }
    }

    private final Node apportion(Graph graph, Node node, Node defaultAncestor) {
        Node ancestor = defaultAncestor;
        if (this.hasLeftSibling(graph, node)) {
            Node leftSibling = this.getLeftSibling(graph, node);
            Node vip = node;
            Node vop = node;
            Node vim = leftSibling;
            Node vom = this.getLeftMostChild(graph, graph.predecessorsOf(vip).get(0));
            double sip = this.getModifier(vip);
            Node node2 = vop;
            if (node2 == null) {
                Intrinsics.throwNpe();
            }
            double sop = this.getModifier(node2);
            Node node3 = vim;
            if (node3 == null) {
                Intrinsics.throwNpe();
            }
            double sim = this.getModifier(node3);
            Node node4 = vom;
            if (node4 == null) {
                Intrinsics.throwNpe();
            }
            double som = this.getModifier(node4);
            Node nextRight = this.nextRight(graph, vim);
            Node nextLeft = this.nextLeft(graph, vip);
            while (nextRight != null && nextLeft != null) {
                vim = nextRight;
                vip = nextLeft;
                vom = this.nextLeft(graph, vom);
                Node node5 = vop = this.nextRight(graph, vop);
                if (node5 == null) {
                    Intrinsics.throwNpe();
                }
                this.setAncestor(node5, node);
                double shift = this.getPrelim(vim) + sim - (this.getPrelim(vip) + sip) + (double)this.getSpacing(graph, vim, node);
                if (shift > 0.0) {
                    this.moveSubtree(this.ancestor(graph, vim, node, ancestor), node, shift);
                    sip += shift;
                    sop += shift;
                }
                sim += this.getModifier(vim);
                sip += this.getModifier(vip);
                Node node6 = vom;
                if (node6 == null) {
                    Intrinsics.throwNpe();
                }
                som += this.getModifier(node6);
                sop += this.getModifier(vop);
                nextRight = this.nextRight(graph, vim);
                nextLeft = this.nextLeft(graph, vip);
            }
            if (nextRight != null && this.nextRight(graph, vop) == null) {
                this.setThread(vop, nextRight);
                this.setModifier(vop, this.getModifier(vop) + sim - sop);
            }
            if (nextLeft != null && this.nextLeft(graph, vom) == null) {
                this.setThread(vom, nextLeft);
                this.setModifier(vom, this.getModifier(vom) + sip - som);
                ancestor = node;
            }
        }
        return ancestor;
    }

    private final void setAncestor(Node v, Node ancestor) {
        this.getNodeData(v).setAncestor(ancestor);
    }

    private final void setModifier(Node v, double modifier) {
        this.getNodeData(v).setModifier(modifier);
    }

    private final void setThread(Node v, Node thread) {
        this.getNodeData(v).setThread(thread);
    }

    private final double getPrelim(Node v) {
        return this.getNodeData(v).getPrelim();
    }

    private final double getModifier(Node vip) {
        return this.getNodeData(vip).getModifier();
    }

    private final void moveSubtree(Node wm, Node wp, double shift) {
        BuchheimWalkerNodeData wpNodeData = this.getNodeData(wp);
        BuchheimWalkerNodeData wmNodeData = this.getNodeData(wm);
        int subtrees = wpNodeData.getNumber() - wmNodeData.getNumber();
        wpNodeData.setChange(wpNodeData.getChange() - shift / (double)subtrees);
        wpNodeData.setShift(wpNodeData.getShift() + shift);
        wmNodeData.setChange(wmNodeData.getChange() + shift / (double)subtrees);
        wpNodeData.setPrelim(wpNodeData.getPrelim() + shift);
        wpNodeData.setModifier(wpNodeData.getModifier() + shift);
    }

    private final Node ancestor(Graph graph, Node vim, Node node, Node defaultAncestor) {
        BuchheimWalkerNodeData vipNodeData = this.getNodeData(vim);
        return graph.predecessorsOf(vipNodeData.getAncestor()).get(0) == graph.predecessorsOf(node).get(0) ? vipNodeData.getAncestor() : defaultAncestor;
    }

    private final Node nextRight(Graph graph, Node node) {
        Node node2 = node;
        if (node2 == null) {
            Intrinsics.throwNpe();
        }
        return graph.hasSuccessor(node2) ? this.getRightMostChild(graph, node) : this.getNodeData(node).getThread();
    }

    private final Node nextLeft(Graph graph, Node node) {
        Node node2 = node;
        if (node2 == null) {
            Intrinsics.throwNpe();
        }
        return graph.hasSuccessor(node2) ? this.getLeftMostChild(graph, node) : this.getNodeData(node).getThread();
    }

    private final int getSpacing(Graph graph, Node leftNode, Node rightNode) {
        int n;
        boolean vertical;
        int separation = this.configuration.getSubtreeSeparation();
        if (this.isSibling(graph, leftNode, rightNode)) {
            separation = this.configuration.getSiblingSeparation();
        }
        if (vertical = this.isVertical()) {
            Node node = leftNode;
            if (node == null) {
                Intrinsics.throwNpe();
            }
            n = node.getWidth();
        } else {
            Node node = leftNode;
            if (node == null) {
                Intrinsics.throwNpe();
            }
            n = node.getHeight();
        }
        return separation + n;
    }

    private final boolean isSibling(Graph graph, Node leftNode, Node rightNode) {
        Node node = leftNode;
        if (node == null) {
            Intrinsics.throwNpe();
        }
        Node leftParent = graph.predecessorsOf(node).get(0);
        return graph.successorsOf(leftParent).contains(rightNode);
    }

    private final boolean isLeaf(Graph graph, Node node) {
        return graph.successorsOf(node).isEmpty();
    }

    private final Node getLeftSibling(Graph graph, Node node) {
        if (!this.hasLeftSibling(graph, node)) {
            return null;
        }
        Node parent = graph.predecessorsOf(node).get(0);
        List<Node> children = graph.successorsOf(parent);
        int nodeIndex = children.indexOf(node);
        return children.get(nodeIndex - 1);
    }

    private final boolean hasLeftSibling(Graph graph, Node node) {
        List<Node> parents = graph.predecessorsOf(node);
        if (parents.isEmpty()) {
            return false;
        }
        Node parent = parents.get(0);
        int nodeIndex = graph.successorsOf(parent).indexOf(node);
        return nodeIndex > 0;
    }

    private final Node getRightSibling(Graph graph, Node node) {
        if (!this.hasRightSibling(graph, node)) {
            return null;
        }
        Node parent = graph.predecessorsOf(node).get(0);
        List<Node> children = graph.successorsOf(parent);
        int nodeIndex = children.indexOf(node);
        return children.get(nodeIndex + 1);
    }

    private final boolean hasRightSibling(Graph graph, Node node) {
        List<Node> parents = graph.predecessorsOf(node);
        if (parents.isEmpty()) {
            return false;
        }
        Node parent = parents.get(0);
        List<Node> children = graph.successorsOf(parent);
        int nodeIndex = children.indexOf(node);
        return nodeIndex < children.size() - 1;
    }

    private final Node getLeftMostChild(Graph graph, Node node) {
        return graph.successorsOf(node).get(0);
    }

    private final Node getRightMostChild(Graph graph, Node node) {
        List<Node> children = graph.successorsOf(node);
        return children.isEmpty() ? null : children.get(children.size() - 1);
    }

    @Override
    @NotNull
    public Size run(@NotNull Graph graph, float shiftX, float shiftY) {
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        this.mNodeData.clear();
        Node firstNode = graph.getNodeAtPosition(0);
        this.firstWalk(graph, firstNode, 0, 0);
        this.secondWalk(graph, firstNode, 0.0);
        this.positionNodes(graph);
        this.shiftCoordinates(graph, shiftX, shiftY);
        return this.calculateGraphSize(graph);
    }

    private final void positionNodes(Graph graph) {
        int globalPadding = 0;
        int localPadding = 0;
        VectorF offset = this.getOffset(graph);
        int orientation = this.configuration.getOrientation();
        boolean needReverseOrder = orientation == 2 || orientation == 4;
        List<Node> nodes = this.sortByLevel(graph, needReverseOrder);
        int firstLevel = this.getNodeData(nodes.get(0)).getDepth();
        Size localMaxSize = this.findMaxSize(this.filterByLevel(nodes, firstLevel));
        int currentLevel = needReverseOrder ? firstLevel : 0;
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node node = (Node)element$iv;
            boolean bl = false;
            int depth = this.getNodeData(node).getDepth();
            if (depth != currentLevel) {
                switch (this.configuration.getOrientation()) {
                    case 1: 
                    case 3: {
                        globalPadding += localPadding;
                        break;
                    }
                    case 2: 
                    case 4: {
                        globalPadding -= localPadding;
                    }
                }
                localPadding = 0;
                currentLevel = depth;
                localMaxSize = this.findMaxSize(this.filterByLevel(nodes, currentLevel));
            }
            int height = node.getHeight();
            int width = node.getWidth();
            switch (this.configuration.getOrientation()) {
                case 1: {
                    int n;
                    if (height <= this.minNodeHeight) break;
                    int diff = height - this.minNodeHeight;
                    int n2 = localPadding;
                    boolean bl2 = false;
                    localPadding = n = Math.max(n2, diff);
                    break;
                }
                case 2: {
                    int n;
                    if (height >= localMaxSize.getHeight()) break;
                    int diff = localMaxSize.getHeight() - height;
                    node.setPosition(node.getPosition().subtract(new VectorF(0.0f, diff)));
                    int n2 = localPadding;
                    boolean bl2 = false;
                    localPadding = n = Math.max(n2, diff);
                    break;
                }
                case 3: {
                    int n;
                    if (width <= this.minNodeWidth) break;
                    int diff = width - this.minNodeWidth;
                    int n2 = localPadding;
                    boolean bl2 = false;
                    localPadding = n = Math.max(n2, diff);
                    break;
                }
                case 4: {
                    int n;
                    if (width >= localMaxSize.getWidth()) break;
                    int diff = localMaxSize.getWidth() - width;
                    node.setPosition(node.getPosition().subtract(new VectorF(0.0f, diff)));
                    int n2 = localPadding;
                    boolean bl2 = false;
                    localPadding = n = Math.max(n2, diff);
                }
            }
            node.setPosition(this.getPosition(node, globalPadding, offset));
        }
    }

    private final void shiftCoordinates(Graph graph, float shiftX, float shiftY) {
        Iterable $this$forEach$iv = graph.getNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node node = (Node)element$iv;
            boolean bl = false;
            node.setPosition(new VectorF(node.getX() + shiftX, node.getY() + shiftY));
        }
    }

    private final Size findMaxSize(List<Node> nodes) {
        int width = Integer.MIN_VALUE;
        int height = Integer.MIN_VALUE;
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int n;
            Node node = (Node)element$iv;
            boolean bl = false;
            int n2 = width;
            int n3 = node.getWidth();
            boolean bl2 = false;
            width = n = Math.max(n2, n3);
            n2 = height;
            n3 = node.getHeight();
            bl2 = false;
            height = n = Math.max(n2, n3);
        }
        return new Size(width, height);
    }

    private final VectorF getOffset(Graph graph) {
        float offsetX = Float.MAX_VALUE;
        float offsetY = Float.MAX_VALUE;
        switch (this.configuration.getOrientation()) {
            case 2: 
            case 4: {
                offsetY = Float.MIN_VALUE;
                break;
            }
        }
        int orientation = this.configuration.getOrientation();
        Iterable $this$forEach$iv = graph.getNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node node = (Node)element$iv;
            boolean bl = false;
            switch (orientation) {
                case 1: 
                case 3: {
                    float f;
                    float f2 = offsetX;
                    float f3 = node.getX();
                    boolean bl2 = false;
                    offsetX = f = Math.min(f2, f3);
                    f2 = offsetY;
                    f3 = node.getY();
                    bl2 = false;
                    offsetY = f = Math.min(f2, f3);
                    break;
                }
                case 2: 
                case 4: {
                    float f;
                    float f2 = offsetX;
                    float f3 = node.getX();
                    boolean bl2 = false;
                    offsetX = f = Math.min(f2, f3);
                    f2 = offsetY;
                    f3 = node.getY();
                    bl2 = false;
                    offsetY = f = Math.max(f2, f3);
                }
            }
        }
        return new VectorF(offsetX, offsetY);
    }

    private final VectorF getPosition(Node node, int globalPadding, VectorF offset) {
        VectorF vectorF;
        switch (this.configuration.getOrientation()) {
            case 1: {
                vectorF = new VectorF(node.getX() - offset.getX(), node.getY() + (float)globalPadding);
                break;
            }
            case 2: {
                vectorF = new VectorF(node.getX() - offset.getX(), offset.getY() - node.getY() - (float)globalPadding);
                break;
            }
            case 3: {
                vectorF = new VectorF(node.getY() + (float)globalPadding, node.getX() - offset.getX());
                break;
            }
            case 4: {
                vectorF = new VectorF(offset.getY() - node.getY() - (float)globalPadding, node.getX() - offset.getX());
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unknown Orientation! " + this.configuration.getOrientation());
            }
        }
        return vectorF;
    }

    private final List<Node> sortByLevel(Graph graph, boolean descending) {
        ArrayList nodes = new ArrayList(graph.getNodes());
        Comparator comparator2 = new Comparator<Node>(this){
            final /* synthetic */ BuchheimWalkerAlgorithm this$0;

            public final int compare(Node o1, Node o2) {
                Node node = o1;
                Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"o1");
                BuchheimWalkerNodeData data1 = BuchheimWalkerAlgorithm.access$getNodeData(this.this$0, node);
                Node node2 = o2;
                Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"o2");
                BuchheimWalkerNodeData data2 = BuchheimWalkerAlgorithm.access$getNodeData(this.this$0, node2);
                return BuchheimWalkerAlgorithm.access$compare(this.this$0, data1.getDepth(), data2.getDepth());
            }
            {
                this.this$0 = buchheimWalkerAlgorithm;
            }
        };
        if (descending) {
            Comparator comparator3 = Collections.reverseOrder(comparator2);
            Intrinsics.checkExpressionValueIsNotNull(comparator3, (String)"Collections.reverseOrder(comparator)");
            comparator2 = comparator3;
        }
        Collections.sort(nodes, comparator2);
        return nodes;
    }

    private final List<Node> filterByLevel(List<Node> nodes, int level) {
        ArrayList nodeList = new ArrayList(nodes);
        Iterator iterator = nodeList.iterator();
        Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"nodeList.iterator()");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Node node;
            Node node2 = node = (Node)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"node");
            int depth = this.getNodeData(node2).getDepth();
            if (depth == level) continue;
            iterator2.remove();
        }
        return nodeList;
    }

    @Override
    public void drawEdges(@NotNull Canvas canvas, @NotNull Graph graph, @NotNull Paint linePaint) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        Intrinsics.checkParameterIsNotNull((Object)linePaint, (String)"linePaint");
        this.edgeRenderer.render(canvas, graph, linePaint);
    }

    @Override
    public void setEdgeRenderer(@NotNull EdgeRenderer renderer) {
        Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
        this.edgeRenderer = renderer;
    }

    @JvmOverloads
    public BuchheimWalkerAlgorithm(@NotNull BuchheimWalkerConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.mNodeData = new HashMap();
        this.edgeRenderer = new TreeEdgeRenderer(this.configuration);
        this.minNodeHeight = Integer.MAX_VALUE;
        this.minNodeWidth = Integer.MAX_VALUE;
        this.maxNodeWidth = Integer.MIN_VALUE;
        this.maxNodeHeight = Integer.MIN_VALUE;
    }

    public /* synthetic */ BuchheimWalkerAlgorithm(BuchheimWalkerConfiguration buchheimWalkerConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            buchheimWalkerConfiguration = new BuchheimWalkerConfiguration.Builder().build();
        }
        this(buchheimWalkerConfiguration);
    }

    @JvmOverloads
    public BuchheimWalkerAlgorithm() {
        this(null, 1, null);
    }

    public static final /* synthetic */ BuchheimWalkerNodeData access$getNodeData(BuchheimWalkerAlgorithm $this, Node node) {
        return $this.getNodeData(node);
    }

    public static final /* synthetic */ int access$compare(BuchheimWalkerAlgorithm $this, int x, int y) {
        return $this.compare(x, y);
    }
}

