/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview.edgerenderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import de.blox.graphview.Edge;
import de.blox.graphview.Graph;
import de.blox.graphview.Node;
import de.blox.graphview.edgerenderer.EdgeRenderer;
import de.blox.graphview.util.VectorF;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0004J:\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0004J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/blox/graphview/edgerenderer/ArrowEdgeRenderer;", "Lde/blox/graphview/edgerenderer/EdgeRenderer;", "()V", "trianglePath", "Landroid/graphics/Path;", "clipLine", "", "startX", "", "startY", "stopX", "stopY", "destination", "Lde/blox/graphview/Node;", "drawTriangle", "canvas", "Landroid/graphics/Canvas;", "paint", "Landroid/graphics/Paint;", "x1", "y1", "x2", "y2", "render", "", "graph", "Lde/blox/graphview/Graph;", "Companion", "graphview_release"})
public class ArrowEdgeRenderer
implements EdgeRenderer {
    private final Path trianglePath = new Path();
    private static final float ARROW_DEGREES = 0.5f;
    private static final float ARROW_LENGTH = 50.0f;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public void render(@NotNull Canvas canvas, @NotNull Graph graph, @NotNull Paint paint) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        Paint trianglePaint = new Paint(paint);
        trianglePaint.setStyle(Paint.Style.FILL);
        Iterable $this$forEach$iv = graph.getEdges();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void x2;
            void x1;
            void source;
            Edge $dstr$source$destination = (Edge)element$iv;
            boolean bl = false;
            Node node = $dstr$source$destination.component1();
            Node destination = $dstr$source$destination.component2();
            VectorF vectorF = source.getPosition();
            float f = vectorF.component1();
            float y1 = vectorF.component2();
            VectorF vectorF2 = destination.getPosition();
            float f2 = vectorF2.component1();
            float y2 = vectorF2.component2();
            void startX = x1 + (float)source.getWidth() / 2.0f;
            float startY = y1 + (float)source.getHeight() / 2.0f;
            void stopX = x2 + (float)destination.getWidth() / 2.0f;
            float stopY = y2 + (float)destination.getHeight() / 2.0f;
            float[] clippedLine = this.clipLine((float)startX, startY, (float)stopX, stopY, destination);
            float[] triangleCentroid = this.drawTriangle(canvas, trianglePaint, clippedLine[0], clippedLine[1], clippedLine[2], clippedLine[3]);
            canvas.drawLine(clippedLine[0], clippedLine[1], triangleCentroid[0], triangleCentroid[1], paint);
        }
    }

    @NotNull
    protected final float[] clipLine(float startX, float startY, float stopX, float stopY, @NotNull Node destination) {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        float[] resultLine = new float[4];
        resultLine[0] = startX;
        resultLine[1] = startY;
        float slope = (startY - stopY) / (startX - stopX);
        float halfHeight = (float)destination.getHeight() / 2.0f;
        float halfWidth = (float)destination.getWidth() / 2.0f;
        float halfSlopeWidth = slope * halfWidth;
        float halfSlopeHeight = halfHeight / slope;
        if (-halfHeight <= halfSlopeWidth && halfSlopeWidth <= halfHeight) {
            if (destination.getX() > startX) {
                resultLine[2] = stopX - halfWidth;
                resultLine[3] = stopY - halfSlopeWidth;
            } else if (destination.getX() < startX) {
                resultLine[2] = stopX + halfWidth;
                resultLine[3] = stopY + halfSlopeWidth;
            }
        }
        if (-halfWidth <= halfSlopeHeight && halfSlopeHeight <= halfWidth) {
            if (destination.getY() < startY) {
                resultLine[2] = stopX + halfSlopeHeight;
                resultLine[3] = stopY + halfHeight;
            } else if (destination.getY() > startY) {
                resultLine[2] = stopX - halfSlopeHeight;
                resultLine[3] = stopY - halfHeight;
            }
        }
        return resultLine;
    }

    @NotNull
    protected final float[] drawTriangle(@NotNull Canvas canvas, @Nullable Paint paint, float x1, float y1, float x2, float y2) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        float angle = (float)(Math.atan2((double)y2 - (double)y1, (double)x2 - (double)x1) + Math.PI);
        float x3 = (float)((double)x2 + (double)50.0f * Math.cos(angle - 0.5f));
        float y3 = (float)((double)y2 + (double)50.0f * Math.sin(angle - 0.5f));
        float x4 = (float)((double)x2 + (double)50.0f * Math.cos(angle + 0.5f));
        float y4 = (float)((double)y2 + (double)50.0f * Math.sin(angle + 0.5f));
        this.trianglePath.moveTo(x2, y2);
        this.trianglePath.lineTo(x3, y3);
        this.trianglePath.lineTo(x4, y4);
        this.trianglePath.close();
        Paint paint2 = paint;
        if (paint2 == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawPath(this.trianglePath, paint2);
        float x = (x2 + x3 + x4) / (float)3;
        float y = (y2 + y3 + y4) / (float)3;
        float[] triangleCentroid = new float[]{x, y};
        this.trianglePath.reset();
        return triangleCentroid;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/blox/graphview/edgerenderer/ArrowEdgeRenderer$Companion;", "", "()V", "ARROW_DEGREES", "", "ARROW_LENGTH", "graphview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

