/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview;

import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import de.blox.graphview.Algorithm;
import de.blox.graphview.Conditions;
import de.blox.graphview.Graph;
import de.blox.graphview.GraphAdapter;
import de.blox.graphview.Node;
import de.blox.graphview.Vector;
import de.blox.graphview.ViewHolder;
import de.blox.graphview.tree.BuchheimWalkerAlgorithm;

public abstract class BaseGraphAdapter<VH extends ViewHolder>
implements GraphAdapter<VH> {
    private Graph graph;
    private Algorithm mAlgorithm;
    private DataSetObservable mDataSetObservable = new DataSetObservable();

    public BaseGraphAdapter() {
    }

    public BaseGraphAdapter(@NonNull Graph graph) {
        this.setGraph(graph);
    }

    @Override
    public void notifySizeChanged() {
        if (this.graph != null && this.graph.getNodeCount() > 0) {
            this.getAlgorithm().run(this.graph);
        }
    }

    @Override
    public Algorithm getAlgorithm() {
        if (this.mAlgorithm == null) {
            this.mAlgorithm = new BuchheimWalkerAlgorithm();
        }
        return this.mAlgorithm;
    }

    @Override
    public void setAlgorithm(@NonNull Algorithm algorithm) {
        Conditions.isNonNull(algorithm, "algorithm can't be null");
        this.mAlgorithm = algorithm;
        if (this.graph != null) {
            this.graph.setAsTree(this.getAlgorithm() instanceof BuchheimWalkerAlgorithm);
        }
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public void setGraph(@NonNull Graph graph) {
        Conditions.isNonNull(graph, "graph can't be null");
        if (this.graph != null) {
            this.graph.removeNodeObserver(this);
        }
        this.graph = graph;
        this.graph.addNodeObserver(this);
        this.mDataSetObservable.notifyChanged();
        graph.setAsTree(this.getAlgorithm() instanceof BuchheimWalkerAlgorithm);
    }

    @Override
    public Node getNode(int position) {
        return this.graph != null ? this.graph.getNode(position) : null;
    }

    @Override
    public Vector getScreenPosition(int position) {
        return this.getNode(position).getPosition();
    }

    public int getCount() {
        return this.graph != null ? this.graph.getNodeCount() : 0;
    }

    @Override
    public void notifyDataChanged(Node node) {
        this.mDataSetObservable.notifyChanged();
    }

    @Override
    public void notifyNodeAdded(Node node) {
        this.mDataSetObservable.notifyInvalidated();
    }

    @Override
    public void notifyNodeRemoved(Node node) {
        this.mDataSetObservable.notifyInvalidated();
    }

    @Override
    public void notifyInvalidated() {
        this.mDataSetObservable.notifyInvalidated();
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.registerObserver((Object)observer);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.unregisterObserver((Object)observer);
    }

    public Object getItem(int position) {
        return this.getNode(position).getData();
    }

    public long getItemId(int position) {
        return 0L;
    }

    public boolean hasStableIds() {
        return false;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View view;
        ViewHolder viewHolder;
        if (convertView == null) {
            viewHolder = this.onCreateViewHolder(parent, this.getItemViewType(position));
            view = viewHolder.itemView;
            view.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)convertView.getTag();
            view = viewHolder.itemView;
        }
        Node node = this.getNode(position);
        this.onBindViewHolder(viewHolder, node.getData(), position);
        return view;
    }

    public int getItemViewType(int position) {
        return 0;
    }

    public int getViewTypeCount() {
        return 0;
    }

    public boolean isEmpty() {
        return false;
    }
}

