/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview.tree;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import de.blox.graphview.Graph;
import de.blox.graphview.Node;
import de.blox.graphview.edgerenderer.EdgeRenderer;
import de.blox.graphview.tree.BuchheimWalkerConfiguration;
import java.util.List;

class TreeEdgeRenderer
implements EdgeRenderer {
    private BuchheimWalkerConfiguration configuration;
    private Path linePath = new Path();

    TreeEdgeRenderer(BuchheimWalkerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void render(Canvas canvas, Graph graph, Paint paint) {
        List<Node> nodes = graph.getNodes();
        for (Node node : nodes) {
            List<Node> children = graph.successorsOf(node);
            for (Node child : children) {
                this.linePath.reset();
                switch (this.configuration.getOrientation()) {
                    case 1: {
                        this.linePath.moveTo(child.getX() + (float)(child.getWidth() / 2), child.getY());
                        this.linePath.lineTo(child.getX() + (float)(child.getWidth() / 2), child.getY() - (float)(this.configuration.getLevelSeparation() / 2));
                        this.linePath.lineTo(node.getX() + (float)(node.getWidth() / 2), child.getY() - (float)(this.configuration.getLevelSeparation() / 2));
                        this.linePath.moveTo(node.getX() + (float)(node.getWidth() / 2), child.getY() - (float)(this.configuration.getLevelSeparation() / 2));
                        this.linePath.lineTo(node.getX() + (float)(node.getWidth() / 2), node.getY() + (float)node.getHeight());
                        break;
                    }
                    case 2: {
                        this.linePath.moveTo(child.getX() + (float)(child.getWidth() / 2), child.getY() + (float)child.getHeight());
                        this.linePath.lineTo(child.getX() + (float)(child.getWidth() / 2), child.getY() + (float)child.getHeight() + (float)(this.configuration.getLevelSeparation() / 2));
                        this.linePath.lineTo(node.getX() + (float)(node.getWidth() / 2), child.getY() + (float)child.getHeight() + (float)(this.configuration.getLevelSeparation() / 2));
                        this.linePath.moveTo(node.getX() + (float)(node.getWidth() / 2), child.getY() + (float)child.getHeight() + (float)(this.configuration.getLevelSeparation() / 2));
                        this.linePath.lineTo(node.getX() + (float)(node.getWidth() / 2), node.getY() + (float)node.getHeight());
                        break;
                    }
                    case 3: {
                        this.linePath.moveTo(child.getX(), child.getY() + (float)(child.getHeight() / 2));
                        this.linePath.lineTo(child.getX() - (float)(this.configuration.getLevelSeparation() / 2), child.getY() + (float)(child.getHeight() / 2));
                        this.linePath.lineTo(child.getX() - (float)(this.configuration.getLevelSeparation() / 2), node.getY() + (float)(node.getHeight() / 2));
                        this.linePath.moveTo(child.getX() - (float)(this.configuration.getLevelSeparation() / 2), node.getY() + (float)(node.getHeight() / 2));
                        this.linePath.lineTo(node.getX() + (float)node.getWidth(), node.getY() + (float)(node.getHeight() / 2));
                        break;
                    }
                    case 4: {
                        this.linePath.moveTo(child.getX() + (float)child.getWidth(), child.getY() + (float)(child.getHeight() / 2));
                        this.linePath.lineTo(child.getX() + (float)child.getWidth() + (float)(this.configuration.getLevelSeparation() / 2), child.getY() + (float)(child.getHeight() / 2));
                        this.linePath.lineTo(child.getX() + (float)child.getWidth() + (float)(this.configuration.getLevelSeparation() / 2), node.getY() + (float)(node.getHeight() / 2));
                        this.linePath.moveTo(child.getX() + (float)child.getWidth() + (float)(this.configuration.getLevelSeparation() / 2), node.getY() + (float)(node.getHeight() / 2));
                        this.linePath.lineTo(node.getX() + (float)node.getWidth(), node.getY() + (float)(node.getHeight() / 2));
                    }
                }
                canvas.drawPath(this.linePath, paint);
            }
        }
    }
}

