/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview.tree;

import android.graphics.Canvas;
import android.graphics.Paint;
import de.blox.graphview.Algorithm;
import de.blox.graphview.Graph;
import de.blox.graphview.Node;
import de.blox.graphview.Size;
import de.blox.graphview.Vector;
import de.blox.graphview.edgerenderer.EdgeRenderer;
import de.blox.graphview.tree.BuchheimWalkerConfiguration;
import de.blox.graphview.tree.BuchheimWalkerNodeData;
import de.blox.graphview.tree.TreeEdgeRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BuchheimWalkerAlgorithm
implements Algorithm {
    private BuchheimWalkerConfiguration configuration;
    private Map<Node, BuchheimWalkerNodeData> mNodeData = new HashMap<Node, BuchheimWalkerNodeData>();
    private EdgeRenderer edgeRenderer;
    private int minNodeHeight = Integer.MAX_VALUE;
    private int minNodeWidth = Integer.MAX_VALUE;
    private int maxNodeWidth = Integer.MIN_VALUE;
    private int maxNodeHeight = Integer.MIN_VALUE;
    private Size size;

    public BuchheimWalkerAlgorithm(BuchheimWalkerConfiguration configuration) {
        this.configuration = configuration;
        this.edgeRenderer = new TreeEdgeRenderer(configuration);
    }

    public BuchheimWalkerAlgorithm() {
        this(new BuchheimWalkerConfiguration.Builder().build());
    }

    private static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private BuchheimWalkerNodeData createNodeData(Node node) {
        BuchheimWalkerNodeData nodeData = new BuchheimWalkerNodeData();
        nodeData.setAncestor(node);
        this.mNodeData.put(node, nodeData);
        return nodeData;
    }

    private BuchheimWalkerNodeData getNodeData(Node node) {
        return this.mNodeData.get(node);
    }

    private void firstWalk(Graph graph, Node node, int depth, int number) {
        BuchheimWalkerNodeData nodeData = this.createNodeData(node);
        nodeData.setDepth(depth);
        nodeData.setNumber(number);
        this.minNodeHeight = Math.min(this.minNodeHeight, node.getHeight());
        this.minNodeWidth = Math.min(this.minNodeWidth, node.getWidth());
        this.maxNodeWidth = Math.max(this.maxNodeWidth, node.getWidth());
        this.maxNodeHeight = Math.max(this.maxNodeHeight, node.getHeight());
        if (this.isLeaf(graph, node)) {
            if (this.hasLeftSibling(graph, node)) {
                Node leftSibling = this.getLeftSibling(graph, node);
                nodeData.setPrelim(this.getPrelim(leftSibling) + (double)this.getSpacing(graph, leftSibling, node));
            }
        } else {
            Node leftMost = this.getLeftMostChild(graph, node);
            Node rightMost = this.getRightMostChild(graph, node);
            Node defaultAncestor = leftMost;
            Node next = leftMost;
            int i = 1;
            while (next != null) {
                this.firstWalk(graph, next, depth + 1, i++);
                defaultAncestor = this.apportion(graph, next, defaultAncestor);
                next = this.getRightSibling(graph, next);
            }
            this.executeShifts(graph, node);
            boolean isVertical = this.isVertical();
            double midPoint = 0.5 * (this.getPrelim(leftMost) + this.getPrelim(rightMost) + (double)(isVertical ? rightMost.getWidth() : rightMost.getHeight()) - (double)(isVertical ? node.getWidth() : node.getHeight()));
            if (this.hasLeftSibling(graph, node)) {
                Node leftSibling = this.getLeftSibling(graph, node);
                nodeData.setPrelim(this.getPrelim(leftSibling) + (double)this.getSpacing(graph, leftSibling, node));
                nodeData.setModifier(nodeData.getPrelim() - midPoint);
            } else {
                nodeData.setPrelim(midPoint);
            }
        }
    }

    private void secondWalk(Graph graph, Node node, double modifier) {
        BuchheimWalkerNodeData nodeData = this.getNodeData(node);
        int depth = nodeData.getDepth();
        boolean vertical = this.isVertical();
        node.setPos(new Vector((float)(nodeData.getPrelim() + modifier), depth * (vertical ? this.minNodeHeight : this.minNodeWidth) + depth * this.configuration.getLevelSeparation()));
        for (Node w : graph.successorsOf(node)) {
            this.secondWalk(graph, w, modifier + nodeData.getModifier());
        }
    }

    private void calculateGraphSize(Graph graph) {
        int left = Integer.MAX_VALUE;
        int top = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        int bottom = Integer.MIN_VALUE;
        for (Node node : graph.getNodes()) {
            left = (int)Math.min((float)left, node.getX());
            top = (int)Math.min((float)top, node.getY());
            right = (int)Math.max((float)right, node.getX() + (float)node.getWidth());
            bottom = (int)Math.max((float)bottom, node.getY() + (float)node.getHeight());
        }
        this.size = new Size(right - left, bottom - top);
    }

    private boolean isVertical() {
        int orientation = this.configuration.getOrientation();
        return orientation == 1 || orientation == 2;
    }

    private void executeShifts(Graph graph, Node node) {
        double shift = 0.0;
        double change = 0.0;
        Node w = this.getRightMostChild(graph, node);
        while (w != null) {
            BuchheimWalkerNodeData nodeData = this.getNodeData(w);
            nodeData.setPrelim(nodeData.getPrelim() + shift);
            nodeData.setModifier(nodeData.getModifier() + shift);
            shift += nodeData.getShift() + (change += nodeData.getChange());
            w = this.getLeftSibling(graph, w);
        }
    }

    private Node apportion(Graph graph, Node node, Node defaultAncestor) {
        if (this.hasLeftSibling(graph, node)) {
            Node leftSibling = this.getLeftSibling(graph, node);
            Node vip = node;
            Node vop = node;
            Node vim = leftSibling;
            Node vom = this.getLeftMostChild(graph, graph.predecessorsOf(vip).get(0));
            double sip = this.getModifier(vip);
            double sop = this.getModifier(vop);
            double sim = this.getModifier(vim);
            double som = this.getModifier(vom);
            Node nextRight = this.nextRight(graph, vim);
            Node nextLeft = this.nextLeft(graph, vip);
            while (nextRight != null && nextLeft != null) {
                vim = nextRight;
                vip = nextLeft;
                vom = this.nextLeft(graph, vom);
                vop = this.nextRight(graph, vop);
                this.setAncestor(vop, node);
                double shift = this.getPrelim(vim) + sim - (this.getPrelim(vip) + sip) + (double)this.getSpacing(graph, vim, node);
                if (shift > 0.0) {
                    this.moveSubtree(this.ancestor(graph, vim, node, defaultAncestor), node, shift);
                    sip += shift;
                    sop += shift;
                }
                sim += this.getModifier(vim);
                sip += this.getModifier(vip);
                som += this.getModifier(vom);
                sop += this.getModifier(vop);
                nextRight = this.nextRight(graph, vim);
                nextLeft = this.nextLeft(graph, vip);
            }
            if (nextRight != null && this.nextRight(graph, vop) == null) {
                this.setThread(vop, nextRight);
                this.setModifier(vop, this.getModifier(vop) + sim - sop);
            }
            if (nextLeft != null && this.nextLeft(graph, vom) == null) {
                this.setThread(vom, nextLeft);
                this.setModifier(vom, this.getModifier(vom) + sip - som);
                defaultAncestor = node;
            }
        }
        return defaultAncestor;
    }

    private void setAncestor(Node v, Node ancestor) {
        this.getNodeData(v).setAncestor(ancestor);
    }

    private void setModifier(Node v, double modifier) {
        this.getNodeData(v).setModifier(modifier);
    }

    private void setThread(Node v, Node thread) {
        this.getNodeData(v).setThread(thread);
    }

    private double getPrelim(Node v) {
        return this.getNodeData(v).getPrelim();
    }

    private double getModifier(Node vip) {
        return this.getNodeData(vip).getModifier();
    }

    private void moveSubtree(Node wm, Node wp, double shift) {
        BuchheimWalkerNodeData wpNodeData = this.getNodeData(wp);
        BuchheimWalkerNodeData wmNodeData = this.getNodeData(wm);
        int subtrees = wpNodeData.getNumber() - wmNodeData.getNumber();
        wpNodeData.setChange(wpNodeData.getChange() - shift / (double)subtrees);
        wpNodeData.setShift(wpNodeData.getShift() + shift);
        wmNodeData.setChange(wmNodeData.getChange() + shift / (double)subtrees);
        wpNodeData.setPrelim(wpNodeData.getPrelim() + shift);
        wpNodeData.setModifier(wpNodeData.getModifier() + shift);
    }

    private Node ancestor(Graph graph, Node vim, Node node, Node defaultAncestor) {
        BuchheimWalkerNodeData vipNodeData = this.getNodeData(vim);
        if (graph.predecessorsOf(vipNodeData.getAncestor()).get(0) == graph.predecessorsOf(node).get(0)) {
            return vipNodeData.getAncestor();
        }
        return defaultAncestor;
    }

    private Node nextRight(Graph graph, Node node) {
        if (graph.hasSuccessor(node)) {
            return this.getRightMostChild(graph, node);
        }
        return this.getNodeData(node).getThread();
    }

    private Node nextLeft(Graph graph, Node node) {
        if (graph.hasSuccessor(node)) {
            return this.getLeftMostChild(graph, node);
        }
        return this.getNodeData(node).getThread();
    }

    private int getSpacing(Graph graph, Node leftNode, Node rightNode) {
        boolean vertical;
        int separation = this.configuration.getSubtreeSeparation();
        if (this.isSibling(graph, leftNode, rightNode)) {
            separation = this.configuration.getSiblingSeparation();
        }
        return separation + ((vertical = this.isVertical()) ? leftNode.getWidth() : leftNode.getHeight());
    }

    private boolean isSibling(Graph graph, Node leftNode, Node rightNode) {
        Node leftParent = graph.predecessorsOf(leftNode).get(0);
        return graph.successorsOf(leftParent).contains(rightNode);
    }

    private boolean isLeaf(Graph graph, Node node) {
        return graph.successorsOf(node).isEmpty();
    }

    private Node getLeftSibling(Graph graph, Node node) {
        if (!this.hasLeftSibling(graph, node)) {
            return null;
        }
        Node parent = graph.predecessorsOf(node).get(0);
        List<Node> children = graph.successorsOf(parent);
        int nodeIndex = children.indexOf(node);
        return children.get(nodeIndex - 1);
    }

    private boolean hasLeftSibling(Graph graph, Node node) {
        List<Node> parents = graph.predecessorsOf(node);
        if (parents.isEmpty()) {
            return false;
        }
        Node parent = parents.get(0);
        int nodeIndex = graph.successorsOf(parent).indexOf(node);
        return nodeIndex > 0;
    }

    private Node getRightSibling(Graph graph, Node node) {
        if (!this.hasRightSibling(graph, node)) {
            return null;
        }
        Node parent = graph.predecessorsOf(node).get(0);
        List<Node> children = graph.successorsOf(parent);
        int nodeIndex = children.indexOf(node);
        return children.get(nodeIndex + 1);
    }

    private boolean hasRightSibling(Graph graph, Node node) {
        List<Node> parents = graph.predecessorsOf(node);
        if (parents.isEmpty()) {
            return false;
        }
        Node parent = parents.get(0);
        List<Node> children = graph.successorsOf(parent);
        int nodeIndex = children.indexOf(node);
        return nodeIndex < children.size() - 1;
    }

    private Node getLeftMostChild(Graph graph, Node node) {
        return graph.successorsOf(node).get(0);
    }

    private Node getRightMostChild(Graph graph, Node node) {
        List<Node> children = graph.successorsOf(node);
        if (children.isEmpty()) {
            return null;
        }
        return children.get(children.size() - 1);
    }

    @Override
    public void run(Graph graph) {
        this.mNodeData.clear();
        Node firstNode = graph.getNode(0);
        this.firstWalk(graph, firstNode, 0, 0);
        this.secondWalk(graph, firstNode, 0.0);
        this.positionNodes(graph);
        this.calculateGraphSize(graph);
    }

    private void positionNodes(Graph graph) {
        int globalPadding = 0;
        int localPadding = 0;
        Vector offset = this.getOffset(graph);
        int orientation = this.configuration.getOrientation();
        boolean needReverseOrder = orientation == 2 || orientation == 4;
        List<Node> nodes = this.sortByLevel(graph, needReverseOrder);
        int firstLevel = this.getNodeData(nodes.get(0)).getDepth();
        Size localMaxSize = this.findMaxSize(this.filterByLevel(nodes, firstLevel));
        int currentLevel = needReverseOrder ? firstLevel : 0;
        for (Node node : nodes) {
            int depth = this.getNodeData(node).getDepth();
            if (depth != currentLevel) {
                switch (this.configuration.getOrientation()) {
                    case 1: 
                    case 3: {
                        globalPadding += localPadding;
                        break;
                    }
                    case 2: 
                    case 4: {
                        globalPadding -= localPadding;
                    }
                }
                localPadding = 0;
                currentLevel = depth;
                localMaxSize = this.findMaxSize(this.filterByLevel(nodes, currentLevel));
            }
            int height = node.getHeight();
            int width = node.getWidth();
            switch (this.configuration.getOrientation()) {
                case 1: {
                    if (height <= this.minNodeHeight) break;
                    int diff = height - this.minNodeHeight;
                    localPadding = Math.max(localPadding, diff);
                    break;
                }
                case 2: {
                    if (height >= localMaxSize.getHeight()) break;
                    int diff = localMaxSize.getHeight() - height;
                    node.setPos(node.getPosition().subtract(new Vector(0.0f, diff)));
                    localPadding = Math.max(localPadding, diff);
                    break;
                }
                case 3: {
                    if (width <= this.minNodeWidth) break;
                    int diff = width - this.minNodeWidth;
                    localPadding = Math.max(localPadding, diff);
                    break;
                }
                case 4: {
                    if (width >= localMaxSize.getWidth()) break;
                    int diff = localMaxSize.getWidth() - width;
                    node.setPos(node.getPosition().subtract(new Vector(0.0f, diff)));
                    localPadding = Math.max(localPadding, diff);
                }
            }
            node.setPos(this.getPosition(node, globalPadding, offset));
        }
    }

    private Size findMaxSize(List<Node> nodes) {
        int width = Integer.MIN_VALUE;
        int height = Integer.MIN_VALUE;
        for (Node node : nodes) {
            width = Math.max(width, node.getWidth());
            height = Math.max(height, node.getHeight());
        }
        return new Size(width, height);
    }

    private Vector getOffset(Graph graph) {
        float offsetX = Float.MAX_VALUE;
        float offsetY = Float.MAX_VALUE;
        switch (this.configuration.getOrientation()) {
            case 2: 
            case 4: {
                offsetY = Float.MIN_VALUE;
            }
        }
        int orientation = this.configuration.getOrientation();
        for (Node node : graph.getNodes()) {
            switch (orientation) {
                case 1: 
                case 3: {
                    offsetX = Math.min(offsetX, node.getX());
                    offsetY = Math.min(offsetY, node.getY());
                    break;
                }
                case 2: 
                case 4: {
                    offsetX = Math.min(offsetX, node.getX());
                    offsetY = Math.max(offsetY, node.getY());
                }
            }
        }
        return new Vector(offsetX, offsetY);
    }

    private Vector getPosition(Node node, int globalPadding, Vector offset) {
        Vector position = null;
        switch (this.configuration.getOrientation()) {
            case 1: {
                position = new Vector(node.getX() - offset.getX(), node.getY() + (float)globalPadding);
                break;
            }
            case 2: {
                position = new Vector(node.getX() - offset.getX(), offset.getY() - node.getY() - (float)globalPadding);
                break;
            }
            case 3: {
                position = new Vector(node.getY() + (float)globalPadding, node.getX() - offset.getX());
                break;
            }
            case 4: {
                position = new Vector(offset.getY() - node.getY() - (float)globalPadding, node.getX() - offset.getX());
            }
        }
        return position;
    }

    private List<Node> sortByLevel(Graph graph, boolean descending) {
        ArrayList<Node> nodes = new ArrayList<Node>(graph.getNodes());
        Comparator<Node> comparator = new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                BuchheimWalkerNodeData data1 = BuchheimWalkerAlgorithm.this.getNodeData(o1);
                BuchheimWalkerNodeData data2 = BuchheimWalkerAlgorithm.this.getNodeData(o2);
                return BuchheimWalkerAlgorithm.compare(data1.getDepth(), data2.getDepth());
            }
        };
        if (descending) {
            comparator = Collections.reverseOrder(comparator);
        }
        Collections.sort(nodes, comparator);
        return nodes;
    }

    private List<Node> filterByLevel(List<Node> nodes, int level) {
        ArrayList<Node> nodeList = new ArrayList<Node>(nodes);
        Iterator iterator = nodeList.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            int depth = this.getNodeData(node).getDepth();
            if (depth == level) continue;
            iterator.remove();
        }
        return nodeList;
    }

    @Override
    public void drawEdges(Canvas canvas, Graph graph, Paint linePaint) {
        this.edgeRenderer.render(canvas, graph, linePaint);
    }

    @Override
    public void setEdgeRenderer(EdgeRenderer renderer) {
        this.edgeRenderer = renderer;
    }

    @Override
    public Size getGraphSize() {
        return this.size;
    }
}

