/*
 * Decompiled with CFR 0.152.
 */
package de.blox.graphview;

import android.support.annotation.NonNull;
import de.blox.graphview.Edge;
import de.blox.graphview.Node;
import de.blox.graphview.NodeObserver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Graph {
    private List<Node> nodes = new ArrayList<Node>();
    private List<Edge> edges = new ArrayList<Edge>();
    private List<NodeObserver> observers = new ArrayList<NodeObserver>();

    public void removeNode(@NonNull Node node) {
        if (!this.nodes.contains(node)) {
            throw new IllegalArgumentException("Unable to find node in graph.");
        }
        this.nodes.remove(node);
        Iterator<Edge> iterator = this.edges.iterator();
        while (iterator.hasNext()) {
            Edge edge = iterator.next();
            if (!edge.getSource().equals(node) && !edge.getDestination().equals(node)) continue;
            iterator.remove();
        }
        for (NodeObserver observer : this.observers) {
            observer.notifyNodeRemoved(node);
        }
    }

    public void addEdge(Node source, Node destination) {
        if (!this.nodes.contains(source)) {
            this.nodes.add(source);
        }
        if (!this.nodes.contains(destination)) {
            this.nodes.add(destination);
        }
        this.edges.add(new Edge(source, destination));
        for (NodeObserver observer : this.observers) {
            observer.notifyInvalidated();
        }
    }

    public void addNodeObserver(NodeObserver nodeObserver) {
        this.observers.add(nodeObserver);
    }

    public void removeNodeObserver(NodeObserver nodeObserver) {
        this.observers.remove(nodeObserver);
    }

    public Node getNode(int position) {
        if (position < 0) {
            throw new IllegalArgumentException("position can't be negative");
        }
        int size = this.nodes.size();
        if (position >= size) {
            throw new IndexOutOfBoundsException("Position: " + position + ", Size: " + size);
        }
        return this.nodes.get(position);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public boolean hasSuccessor(Node node) {
        for (Edge edge : this.edges) {
            if (!edge.getSource().equals(node)) continue;
            return true;
        }
        return false;
    }

    public List<Node> successorsOf(Node node) {
        ArrayList<Node> successors = new ArrayList<Node>();
        for (Edge edge : this.edges) {
            if (!edge.getSource().equals(node)) continue;
            successors.add(edge.getDestination());
        }
        return successors;
    }

    public List<Node> predecessorsOf(Node node) {
        ArrayList<Node> predecessors = new ArrayList<Node>();
        for (Edge edge : this.edges) {
            if (!edge.getDestination().equals(node)) continue;
            predecessors.add(edge.getSource());
        }
        return predecessors;
    }
}

